/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.header_extensions.HeaderExtensionHelpers;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/rtp/rtp/RtpHeader;", "", "<init>", "()V", "Companion", "rtp"})
public final class RtpHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int FIXED_HEADER_SIZE_BYTES = 12;
    public static final int CSRCS_OFFSET = 12;
    public static final int EXT_HEADER_SIZE_BYTES = 4;
    public static final int VERSION = 2;

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0011J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u0019\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0011J\u0016\u0010\u001c\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\u0016\u0010\u001f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010 \u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J\u0016\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010$\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010%\u001a\u00020#J\u0016\u0010&\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010'\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010(\u001a\u00020#J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020#0*2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J$\u0010+\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020#0*J\u0018\u0010-\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0016\u0010.\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010/\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jitsi/rtp/rtp/RtpHeader$Companion;", "", "<init>", "()V", "FIXED_HEADER_SIZE_BYTES", "", "CSRCS_OFFSET", "EXT_HEADER_SIZE_BYTES", "VERSION", "getVersion", "buf", "", "baseOffset", "setVersion", "", "version", "hasPadding", "", "setPadding", "hasExtensions", "setHasExtensions", "hasExtension", "getCsrcCount", "setCsrcCount", "csrcCount", "getMarker", "setMarker", "isSet", "getPayloadType", "setPayloadType", "payloadType", "getSequenceNumber", "setSequenceNumber", "sequenceNumber", "getTimestamp", "", "setTimestamp", "timestamp", "getSsrc", "setSsrc", "ssrc", "getCsrcs", "", "setCsrcs", "csrcs", "getFixedHeaderAndCcLength", "getTotalLength", "getExtensionsProfileType", "rtp"})
    @SourceDebugExtension(value={"SMAP\nRtpHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtpHeader.kt\norg/jitsi/rtp/rtp/RtpHeader$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1557#2:166\n1628#2,3:167\n1872#2,3:170\n*S KotlinDebug\n*F\n+ 1 RtpHeader.kt\norg/jitsi/rtp/rtp/RtpHeader$Companion\n*L\n120#1:166\n120#1:167,3\n128#1:170,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getVersion(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return (buf[baseOffset] & 0xC0) >>> 6;
        }

        public final void setVersion(@NotNull byte[] buf, int baseOffset, int version) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            buf[baseOffset] = (byte)(buf[baseOffset] & 0xFFFFFF3F | version << 6 & 0xC0);
        }

        public final boolean hasPadding(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return (buf[baseOffset] & 0x20) == 32;
        }

        public final void setPadding(@NotNull byte[] buf, int baseOffset, boolean hasPadding) {
            byte by;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            boolean bl = hasPadding;
            if (bl) {
                by = (byte)(buf[baseOffset] | 0x20);
            } else if (!bl) {
                by = (byte)(buf[baseOffset] & 0xFFFFFFDF);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            buf[baseOffset] = by;
        }

        public final boolean hasExtensions(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return (buf[baseOffset] & 0x10) == 16;
        }

        public final void setHasExtensions(@NotNull byte[] buf, int baseOffset, boolean hasExtension) {
            byte by;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            boolean bl = hasExtension;
            if (bl) {
                by = (byte)(buf[baseOffset] | 0x10);
            } else if (!bl) {
                by = (byte)(buf[baseOffset] & 0xFFFFFFEF);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            buf[baseOffset] = by;
        }

        public final int getCsrcCount(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return buf[baseOffset] & 0xF;
        }

        public final void setCsrcCount(@NotNull byte[] buf, int baseOffset, int csrcCount) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            buf[baseOffset] = (byte)(buf[baseOffset] & 0xF0 | csrcCount & 0xF);
        }

        public final boolean getMarker(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return (buf[baseOffset + 1] & 0x80) == 128;
        }

        public final void setMarker(@NotNull byte[] buf, int baseOffset, boolean isSet) {
            byte by;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            boolean bl = isSet;
            if (bl) {
                by = (byte)(buf[baseOffset + 1] | 0x80);
            } else if (!bl) {
                by = (byte)(buf[baseOffset + 1] & 0xFFFFFF7F);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            buf[baseOffset + 1] = by;
        }

        public final int getPayloadType(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return UnsignedKt.toPositiveInt(buf[baseOffset + 1] & 0x7F);
        }

        public final void setPayloadType(@NotNull byte[] buf, int baseOffset, int payloadType) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            buf[baseOffset + 1] = (byte)((byte)(buf[baseOffset + 1] & 0xFFFFFF80) | (byte)(payloadType & 0x7F));
        }

        public final int getSequenceNumber(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return FieldParsersKt.getShortAsInt(buf, baseOffset + 2);
        }

        public final void setSequenceNumber(@NotNull byte[] buf, int baseOffset, int sequenceNumber) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ByteArrayExtensionsKt.putShort(buf, baseOffset + 2, (short)sequenceNumber);
        }

        public final long getTimestamp(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return FieldParsersKt.getIntAsLong(buf, baseOffset + 4);
        }

        public final void setTimestamp(@NotNull byte[] buf, int baseOffset, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ByteArrayExtensionsKt.putInt(buf, baseOffset + 4, (int)timestamp);
        }

        public final long getSsrc(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return FieldParsersKt.getIntAsLong(buf, baseOffset + 8);
        }

        public final void setSsrc(@NotNull byte[] buf, int baseOffset, long ssrc) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ByteArrayExtensionsKt.putInt(buf, baseOffset + 8, (int)ssrc);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Long> getCsrcs(@NotNull byte[] buf, int baseOffset) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int numCsrcs = this.getCsrcCount(buf, baseOffset);
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)numCsrcs);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FieldParsersKt.getIntAsLong(buf, 12 + 4 * it));
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        public final void setCsrcs(@NotNull byte[] buf, int baseOffset, @NotNull List<Long> csrcs) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter(csrcs, (String)"csrcs");
            Iterable $this$forEachIndexed$iv = csrcs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void csrc;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                long l = ((Number)item$iv).longValue();
                int index = n;
                boolean bl = false;
                ByteArrayExtensionsKt.putInt(buf, 12 + 4 * index, (int)csrc);
            }
            this.setCsrcCount(buf, baseOffset, csrcs.size());
        }

        private final int getFixedHeaderAndCcLength(byte[] buf, int baseOffset) {
            return 12 + this.getCsrcCount(buf, baseOffset) * 4;
        }

        public final int getTotalLength(@NotNull byte[] buf, int baseOffset) {
            int n;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int length = this.getFixedHeaderAndCcLength(buf, baseOffset);
            if (this.hasExtensions(buf, baseOffset)) {
                int extHeaderOffset = length;
                n = HeaderExtensionHelpers.Companion.getExtensionsTotalLength(buf, baseOffset + extHeaderOffset);
            } else {
                n = 0;
            }
            int extLength = n;
            return length + extLength;
        }

        public final int getExtensionsProfileType(@NotNull byte[] buf, int baseOffset) {
            int n;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            if (this.hasExtensions(buf, baseOffset)) {
                int extHeaderOffset = this.getFixedHeaderAndCcLength(buf, baseOffset);
                n = HeaderExtensionHelpers.Companion.getExtensionsProfileType(buf, baseOffset + extHeaderOffset);
            } else {
                n = -1;
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

