/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp.header_extensions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtensionKt;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorStatelessSubset;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyException;
import org.jitsi.rtp.rtp.header_extensions.Av1TemplateDependencyStructure;
import org.jitsi.rtp.rtp.header_extensions.DTI;
import org.jitsi.rtp.rtp.header_extensions.FrameInfo;
import org.jitsi.rtp.util.BitWriter;
import org.jitsi.utils.OrderedJsonObject;
import org.json.simple.JSONAware;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002Bs\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r\u0012\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r\u0012\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010*\u001a\u00020\u0000H\u0016J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u001e\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007J\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00107\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00108\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00109\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010:\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010;\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0002J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020=H\u0016R\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0019\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010\u001f\u001a\u00020 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u0011\u0010%\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'\u00a8\u0006?"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorHeaderExtension;", "Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorStatelessSubset;", "Lorg/json/simple/JSONAware;", "startOfFrame", "", "endOfFrame", "frameDependencyTemplateId", "", "frameNumber", "newTemplateDependencyStructure", "Lorg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure;", "activeDecodeTargetsBitmask", "customDtis", "", "Lorg/jitsi/rtp/rtp/header_extensions/DTI;", "customFdiffs", "customChains", "structure", "<init>", "(ZZIILorg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure;Ljava/lang/Integer;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lorg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure;)V", "getActiveDecodeTargetsBitmask", "()Ljava/lang/Integer;", "setActiveDecodeTargetsBitmask", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getCustomDtis", "()Ljava/util/List;", "getCustomFdiffs", "getCustomChains", "getStructure", "()Lorg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure;", "frameInfo", "Lorg/jitsi/rtp/rtp/header_extensions/FrameInfo;", "getFrameInfo", "()Lorg/jitsi/rtp/rtp/header_extensions/FrameInfo;", "frameInfo$delegate", "Lkotlin/Lazy;", "encodedLength", "getEncodedLength", "()I", "unpaddedLengthBits", "getUnpaddedLengthBits", "clone", "write", "", "ext", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "buffer", "", "offset", "length", "writeMandatoryDescriptorFields", "writer", "Lorg/jitsi/rtp/util/BitWriter;", "writeOptionalDescriptorFields", "writeActiveDecodeTargets", "writeFrameDtis", "writeFrameFdiffs", "writeFrameChains", "writePadding", "toJSONString", "", "toString", "rtp"})
@SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
@SourceDebugExtension(value={"SMAP\nAv1DependencyDescriptorHeaderExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1DependencyDescriptorHeaderExtension.kt\norg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorHeaderExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,905:1\n1863#2,2:906\n1863#2,2:908\n1863#2,2:910\n1863#2,2:912\n1#3:914\n*S KotlinDebug\n*F\n+ 1 Av1DependencyDescriptorHeaderExtension.kt\norg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorHeaderExtension\n*L\n125#1:906,2\n231#1:908,2\n237#1:910,2\n246#1:912,2\n*E\n"})
public final class Av1DependencyDescriptorHeaderExtension
extends Av1DependencyDescriptorStatelessSubset
implements JSONAware {
    @Nullable
    private Integer activeDecodeTargetsBitmask;
    @Nullable
    private final List<DTI> customDtis;
    @Nullable
    private final List<Integer> customFdiffs;
    @Nullable
    private final List<Integer> customChains;
    @NotNull
    private final Av1TemplateDependencyStructure structure;
    @NotNull
    private final Lazy frameInfo$delegate;

    public Av1DependencyDescriptorHeaderExtension(boolean startOfFrame, boolean endOfFrame, int frameDependencyTemplateId, int frameNumber, @Nullable Av1TemplateDependencyStructure newTemplateDependencyStructure, @Nullable Integer activeDecodeTargetsBitmask, @Nullable List<? extends DTI> customDtis, @Nullable List<Integer> customFdiffs, @Nullable List<Integer> customChains, @NotNull Av1TemplateDependencyStructure structure) {
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        super(startOfFrame, endOfFrame, frameDependencyTemplateId, frameNumber, newTemplateDependencyStructure);
        this.activeDecodeTargetsBitmask = activeDecodeTargetsBitmask;
        this.customDtis = customDtis;
        this.customFdiffs = customFdiffs;
        this.customChains = customChains;
        this.structure = structure;
        this.frameInfo$delegate = LazyKt.lazy(() -> Av1DependencyDescriptorHeaderExtension.frameInfo_delegate$lambda$0(frameDependencyTemplateId, this));
    }

    @Nullable
    public final Integer getActiveDecodeTargetsBitmask() {
        return this.activeDecodeTargetsBitmask;
    }

    public final void setActiveDecodeTargetsBitmask(@Nullable Integer n) {
        this.activeDecodeTargetsBitmask = n;
    }

    @Nullable
    public final List<DTI> getCustomDtis() {
        return this.customDtis;
    }

    @Nullable
    public final List<Integer> getCustomFdiffs() {
        return this.customFdiffs;
    }

    @Nullable
    public final List<Integer> getCustomChains() {
        return this.customChains;
    }

    @NotNull
    public final Av1TemplateDependencyStructure getStructure() {
        return this.structure;
    }

    @NotNull
    public final FrameInfo getFrameInfo() {
        Lazy lazy = this.frameInfo$delegate;
        return (FrameInfo)lazy.getValue();
    }

    public final int getEncodedLength() {
        return (this.getUnpaddedLengthBits() + 7) / 8;
    }

    private final int getUnpaddedLengthBits() {
        int length;
        block9: {
            block10: {
                length = 0;
                length = 24;
                if (this.getNewTemplateDependencyStructure() != null || this.activeDecodeTargetsBitmask != null || this.customDtis != null || this.customFdiffs != null || this.customChains != null) {
                    length += 5;
                }
                if (this.getNewTemplateDependencyStructure() != null) {
                    length += this.getNewTemplateDependencyStructure().getUnpaddedLengthBits();
                }
                if (this.activeDecodeTargetsBitmask == null) break block9;
                if (this.getNewTemplateDependencyStructure() == null) break block10;
                Integer n = this.activeDecodeTargetsBitmask;
                int n2 = (1 << this.getNewTemplateDependencyStructure().getDecodeTargetCount()) - 1;
                if (n != null && n == n2) break block9;
            }
            length += this.structure.getDecodeTargetCount();
        }
        if (this.customDtis != null) {
            length += 2 * this.structure.getDecodeTargetCount();
        }
        if (this.customFdiffs != null) {
            Iterable $this$forEach$iv = this.customFdiffs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                length += 2 + Av1DependencyDescriptorHeaderExtensionKt.bitsForFdiff(it);
            }
            length += 2;
        }
        if (this.customChains != null) {
            length += 8 * this.customChains.size();
        }
        return length;
    }

    @Override
    @NotNull
    public Av1DependencyDescriptorHeaderExtension clone() {
        Av1TemplateDependencyStructure structureCopy = this.structure.clone();
        Av1TemplateDependencyStructure newStructure = this.getNewTemplateDependencyStructure() == null ? null : structureCopy;
        return new Av1DependencyDescriptorHeaderExtension(this.getStartOfFrame(), this.getEndOfFrame(), this.getFrameDependencyTemplateId(), this.getFrameNumber(), newStructure, this.activeDecodeTargetsBitmask, this.customDtis, this.customFdiffs, this.customChains, structureCopy);
    }

    public final void write(@NotNull RtpPacket.HeaderExtension ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        this.write(ext.getBuffer(), ext.getDataOffset(), ext.getDataLengthBytes());
    }

    public final void write(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!(length <= this.getEncodedLength())) {
            boolean bl = false;
            String string = "Cannot write AV1 DD to buffer: buffer length " + length + " must be at least " + this.getEncodedLength();
            throw new IllegalStateException(string.toString());
        }
        BitWriter writer = new BitWriter(buffer, offset, length);
        this.writeMandatoryDescriptorFields(writer);
        if (this.getNewTemplateDependencyStructure() != null || this.activeDecodeTargetsBitmask != null || this.customDtis != null || this.customFdiffs != null || this.customChains != null) {
            this.writeOptionalDescriptorFields(writer);
            this.writePadding(writer);
        } else if (!(length == 3)) {
            boolean bl = false;
            String string = "AV1 DD without optional descriptors must be 3 bytes in length";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void writeMandatoryDescriptorFields(BitWriter writer) {
        writer.writeBit(this.getStartOfFrame());
        writer.writeBit(this.getEndOfFrame());
        writer.writeBits(6, this.getFrameDependencyTemplateId());
        writer.writeBits(16, this.getFrameNumber());
    }

    /*
     * Unable to fully structure code
     */
    private final void writeOptionalDescriptorFields(BitWriter writer) {
        v0 = templateDependencyStructurePresent = this.getNewTemplateDependencyStructure() != null;
        if (this.activeDecodeTargetsBitmask == null) ** GOTO lbl-1000
        if (this.getNewTemplateDependencyStructure() == null) ** GOTO lbl-1000
        v1 = this.activeDecodeTargetsBitmask;
        var4_3 = (1 << this.getNewTemplateDependencyStructure().getDecodeTargetCount()) - 1;
        if (v1 == null || v1 != var4_3) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        activeDecodeTargetsPresent = v2;
        customDtisFlag = this.customDtis != null;
        customFdiffsFlag = this.customFdiffs != null;
        customChainsFlag = this.customChains != null;
        writer.writeBit(templateDependencyStructurePresent);
        writer.writeBit(activeDecodeTargetsPresent);
        writer.writeBit(customDtisFlag);
        writer.writeBit(customFdiffsFlag);
        writer.writeBit(customChainsFlag);
        if (templateDependencyStructurePresent) {
            v3 = this.getNewTemplateDependencyStructure();
            Intrinsics.checkNotNull((Object)v3);
            v3.write(writer);
        }
        if (activeDecodeTargetsPresent) {
            this.writeActiveDecodeTargets(writer);
        }
        if (customDtisFlag) {
            this.writeFrameDtis(writer);
        }
        if (customFdiffsFlag) {
            this.writeFrameFdiffs(writer);
        }
        if (customChainsFlag) {
            this.writeFrameChains(writer);
        }
    }

    private final void writeActiveDecodeTargets(BitWriter writer) {
        int n = this.structure.getDecodeTargetCount();
        Integer n2 = this.activeDecodeTargetsBitmask;
        Intrinsics.checkNotNull((Object)n2);
        writer.writeBits(n, n2);
    }

    private final void writeFrameDtis(BitWriter writer) {
        List<DTI> list = this.customDtis;
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DTI dti = (DTI)((Object)element$iv);
            boolean bl = false;
            writer.writeBits(2, dti.getDti());
        }
    }

    private final void writeFrameFdiffs(BitWriter writer) {
        List<Integer> list = this.customFdiffs;
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int fdiff = ((Number)element$iv).intValue();
            boolean bl = false;
            int bits = Av1DependencyDescriptorHeaderExtensionKt.bitsForFdiff(fdiff);
            writer.writeBits(2, bits / 4);
            writer.writeBits(bits, fdiff - 1);
        }
        writer.writeBits(2, 0);
    }

    private final void writeFrameChains(BitWriter writer) {
        List<Integer> list = this.customChains;
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int chain = ((Number)element$iv).intValue();
            boolean bl = false;
            writer.writeBits(8, chain);
        }
    }

    private final void writePadding(BitWriter writer) {
        writer.writeBits(writer.getRemainingBits(), 0);
    }

    @NotNull
    public String toJSONString() {
        OrderedJsonObject orderedJsonObject;
        block3: {
            List<Integer> it;
            OrderedJsonObject $this$toJSONString_u24lambda_u2411 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJSONString_u24lambda_u2411.put((Object)"startOfFrame", (Object)this.getStartOfFrame());
            $this$toJSONString_u24lambda_u2411.put((Object)"endOfFrame", (Object)this.getEndOfFrame());
            $this$toJSONString_u24lambda_u2411.put((Object)"frameDependencyTemplateId", (Object)this.getFrameDependencyTemplateId());
            $this$toJSONString_u24lambda_u2411.put((Object)"frameNumber", (Object)this.getFrameNumber());
            Av1TemplateDependencyStructure av1TemplateDependencyStructure = this.getNewTemplateDependencyStructure();
            if (av1TemplateDependencyStructure != null) {
                it = av1TemplateDependencyStructure;
                boolean bl2 = false;
                $this$toJSONString_u24lambda_u2411.put((Object)"templateStructure", (Object)it);
            }
            List<DTI> list = this.customDtis;
            if (list != null) {
                it = list;
                boolean bl3 = false;
                $this$toJSONString_u24lambda_u2411.put((Object)"customDTIs", (Object)it);
            }
            List<Integer> list2 = this.customFdiffs;
            if (list2 != null) {
                it = list2;
                boolean bl4 = false;
                $this$toJSONString_u24lambda_u2411.put((Object)"customFdiffs", it);
            }
            List<Integer> list3 = this.customChains;
            if (list3 == null) break block3;
            it = list3;
            boolean bl5 = false;
            $this$toJSONString_u24lambda_u2411.put((Object)"customChains", it);
        }
        return orderedJsonObject.toJSONString();
    }

    @NotNull
    public String toString() {
        return this.toJSONString();
    }

    private static final FrameInfo frameInfo_delegate$lambda$0(int $frameDependencyTemplateId, Av1DependencyDescriptorHeaderExtension this$0) {
        List<Integer> list;
        List<Integer> list2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int templateIndex = ($frameDependencyTemplateId + 64 - this$0.structure.getTemplateIdOffset()) % 64;
        if (templateIndex >= this$0.structure.getTemplateCount()) {
            int maxTemplate = (this$0.structure.getTemplateIdOffset() + this$0.structure.getTemplateCount() - 1) % 64;
            throw new Av1DependencyException("Invalid template ID " + $frameDependencyTemplateId + ". Should be in range " + this$0.structure.getTemplateIdOffset() + " .. " + maxTemplate + ". Missed a keyframe?");
        }
        FrameInfo templateVal = this$0.structure.getTemplateInfo().get(templateIndex);
        int n = templateVal.getSpatialId();
        int n2 = templateVal.getTemporalId();
        List<DTI> list3 = this$0.customDtis;
        if (list3 == null) {
            list3 = templateVal.getDti();
        }
        if ((list2 = this$0.customFdiffs) == null) {
            list2 = templateVal.getFdiff();
        }
        if ((list = this$0.customChains) == null) {
            list = templateVal.getChains();
        }
        return new FrameInfo(n, n2, list3, list2, list);
    }
}

