/*
 * Copyright (c) 1994, 2001, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package glue.java.lang;

/**
 * Thrown to indicate that the application has attempted to convert a string to
 * one of the numeric types, but that the string does not have the appropriate
 * format.
 *
 * @author unascribed
 * @see java.lang.Integer#toString()
 * @since JDK1.0
 */
public class NumberFormatException {

    /**
     * Factory method for making a <code>NumberFormatException</code> given the
     * specified input which caused the error.
     *
     * @param s
     *            the input causing the error
     */
    public static java.lang.NumberFormatException forInputString(String s) {
        return new java.lang.NumberFormatException("For input string: \"" + s + "\"");
    }
}
