/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.Wrapper;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;

public class JSONObject
extends JSON
implements Map<String, Object>,
Cloneable,
Serializable,
InvocationHandler,
Wrapper {
    static ObjectReader<com.alibaba.fastjson.JSONArray> arrayReader;
    static ObjectReader<JSONObject> objectReader;
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<String, Object> map;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null.");
        }
        this.map = map;
    }

    public JSONObject(boolean ordered) {
        this(16, ordered);
    }

    public JSONObject(int initialCapacity) {
        this(initialCapacity, false);
    }

    public JSONObject(int initialCapacity, boolean ordered) {
        this.map = ordered ? new LinkedHashMap<String, Object>(initialCapacity) : new HashMap<String, Object>(initialCapacity);
    }

    public static <T> T toJavaObject(JSON json, Class<T> clazz) {
        return TypeUtils.cast((Object)json, clazz, JSONFactory.getDefaultObjectReaderProvider());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        boolean result = this.map.containsKey(key);
        if (!result && (key instanceof Number || key instanceof Character || key instanceof Boolean || key instanceof UUID)) {
            result = this.map.containsKey(key.toString());
        }
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        Object val = this.map.get(key);
        if (val == null && (key instanceof Number || key instanceof Boolean || key instanceof Character)) {
            val = this.map.get(key.toString());
        }
        if (val instanceof com.alibaba.fastjson2.JSONObject) {
            val = new JSONObject((com.alibaba.fastjson2.JSONObject)val);
        }
        if (val instanceof JSONArray) {
            val = new com.alibaba.fastjson.JSONArray((JSONArray)val);
        }
        return val;
    }

    public JSONObject getJSONObject(String key) {
        Object value = this.map.get(key);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            if (objectReader == null) {
                objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
            }
            return objectReader.readObject(reader, null, null, 0L);
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value);
        }
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(valueClass);
        if (objectWriter instanceof ObjectWriterAdapter) {
            ObjectWriterAdapter writerAdapter = (ObjectWriterAdapter)objectWriter;
            return new JSONObject(writerAdapter.toJSONObject(value));
        }
        return null;
    }

    public com.alibaba.fastjson.JSONArray getJSONArray(String key) {
        Object value = this.map.get(key);
        if (value == null || value instanceof com.alibaba.fastjson.JSONArray) {
            return (com.alibaba.fastjson.JSONArray)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            if (arrayReader == null) {
                arrayReader = reader.getObjectReader((Type)((Object)com.alibaba.fastjson.JSONArray.class));
            }
            return arrayReader.readObject(reader, null, null, 0L);
        }
        if (value instanceof List) {
            return new com.alibaba.fastjson.JSONArray((List)value);
        }
        String jsonString = JSON.toJSONString(value);
        return JSON.parseArray(jsonString);
    }

    public <T> T getObject(String key, Class<T> clazz) {
        return this.getObject(key, clazz, new Feature[0]);
    }

    public <T> T getObject(String key, Class<T> clazz, Feature ... features) {
        String str;
        Object obj = this.map.get(key);
        if (obj == null) {
            return null;
        }
        if (clazz == Object.class && obj instanceof JSONObject) {
            return (T)obj;
        }
        if (clazz != Object.class && clazz.isInstance(obj)) {
            return (T)obj;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Function typeConvert = provider.getTypeConvert(obj.getClass(), clazz);
        if (typeConvert != null) {
            return (T)typeConvert.apply(obj);
        }
        if (obj instanceof String && ((str = (String)obj).isEmpty() || "null".equals(str))) {
            return null;
        }
        String json = JSON.toJSONString(obj);
        JSONReader jsonReader = JSONReader.of(json, JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), JSON.DEFAULT_PARSER_FEATURE, features));
        boolean fieldBased = jsonReader.getContext().isEnabled(JSONReader.Feature.FieldBased);
        ObjectReader objectReader = provider.getObjectReader(clazz, fieldBased);
        String defaultDateFormat = JSON.DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            jsonReader.getContext().setDateFormat(defaultDateFormat);
        }
        return objectReader.readObject(jsonReader, null, null, 0L);
    }

    public <T> T getObject(String key, TypeReference typeReference) {
        String str;
        Class clazz;
        Type type;
        Object obj = this.map.get(key);
        if (obj == null || typeReference == null || (type = typeReference.getType()) == null) {
            return (T)obj;
        }
        if (type instanceof Class && (clazz = (Class)type) != Object.class && clazz.isInstance(obj)) {
            return (T)obj;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Function typeConvert = provider.getTypeConvert(obj.getClass(), type);
        if (typeConvert != null) {
            return (T)typeConvert.apply(obj);
        }
        if (obj instanceof String && ((str = (String)obj).isEmpty() || "null".equals(str))) {
            return null;
        }
        String json = JSON.toJSONString(obj);
        ObjectReader objectReader = provider.getObjectReader(type);
        JSONReader jsonReader = JSONReader.of(json);
        String defaultDateFormat = JSON.DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            jsonReader.getContext().setDateFormat(defaultDateFormat);
        }
        return objectReader.readObject(jsonReader, null, null, 0L);
    }

    public Boolean getBoolean(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return "true".equalsIgnoreCase(str) || "1".equals(str);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to Boolean");
    }

    public Byte getByte(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Byte.parseByte(str);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to Byte");
    }

    public byte[] getBytes(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return IOUtils.decodeBase64((String)value);
        }
        throw new JSONException("can not cast to byte[], value : " + value);
    }

    public <T> T getObject(String key, Type type) {
        return this.getObject(key, type, new Feature[0]);
    }

    public <T> T getObject(String key, Type type, Feature ... features) {
        Class clazz;
        Object obj = this.map.get(key);
        if (obj == null) {
            return null;
        }
        if (type instanceof Class && (clazz = (Class)type) != Object.class && clazz.isInstance(obj)) {
            return (T)obj;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Function typeConvert = provider.getTypeConvert(obj.getClass(), type);
        if (typeConvert != null) {
            return (T)typeConvert.apply(obj);
        }
        if (obj instanceof String && ((String)obj).isEmpty()) {
            return null;
        }
        String json = JSON.toJSONString(obj);
        JSONReader jsonReader = JSONReader.of(json, JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features));
        boolean fieldBased = jsonReader.getContext().isEnabled(JSONReader.Feature.FieldBased);
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        String defaultDateFormat = JSON.DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            jsonReader.getContext().setDateFormat(defaultDateFormat);
        }
        return objectReader.readObject(jsonReader, null, null, 0L);
    }

    public boolean getBooleanValue(String key) {
        Object value = this.get(key);
        Boolean booleanVal = TypeUtils.toBoolean(value);
        if (booleanVal == null) {
            return false;
        }
        return booleanVal;
    }

    public byte getByteValue(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Byte.parseByte(str);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to byte value");
    }

    public Short getShort(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Short.parseShort(str);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to Short");
    }

    public short getShortValue(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Short.parseShort(str);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to short value");
    }

    public Integer getInteger(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            if (str.indexOf(46) != -1) {
                return (int)Double.parseDouble(str);
            }
            return Integer.parseInt(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to Integer");
    }

    public int getIntValue(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            if (str.indexOf(46) != -1) {
                return (int)Double.parseDouble(str);
            }
            return Integer.parseInt(str);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to int value");
    }

    public Long getLong(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            if (str.indexOf(46) != -1) {
                return (long)Double.parseDouble(str);
            }
            return Long.parseLong(str);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to Long");
    }

    public long getLongValue(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0L;
            }
            if (str.indexOf(46) != -1) {
                return (long)Double.parseDouble(str);
            }
            return Long.parseLong(str);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to long value");
    }

    public Float getFloat(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(str));
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to Float");
    }

    public float getFloatValue(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to float value");
    }

    public Double getDouble(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Double.parseDouble(str);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to Double");
    }

    public double getDoubleValue(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0.0;
            }
            return Double.parseDouble(str);
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to double value");
    }

    public BigDecimal getBigDecimal(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            if (value instanceof Float) {
                float floatValue = ((Float)value).floatValue();
                return TypeUtils.toBigDecimal(floatValue);
            }
            if (value instanceof Double) {
                double doubleValue = (Double)value;
                return TypeUtils.toBigDecimal(doubleValue);
            }
            long longValue = ((Number)value).longValue();
            return BigDecimal.valueOf(longValue);
        }
        if (value instanceof String) {
            return TypeUtils.toBigDecimal((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to BigDecimal");
    }

    public BigInteger getBigInteger(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            long longValue = ((Number)value).longValue();
            return BigInteger.valueOf(longValue);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return new BigInteger(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        throw new com.alibaba.fastjson2.JSONException("Can not cast '" + value.getClass() + "' to BigInteger");
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public java.util.Date getDate(String key) {
        Object value = this.get(key);
        return TypeUtils.toDate(value);
    }

    public Date getSqlDate(String key) {
        Object value = this.get(key);
        return TypeUtils.cast(value, Date.class, JSONFactory.getDefaultObjectReaderProvider());
    }

    public Timestamp getTimestamp(String key) {
        Object value = this.get(key);
        return TypeUtils.cast(value, Timestamp.class, JSONFactory.getDefaultObjectReaderProvider());
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    public JSONObject fluentPut(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
    }

    public JSONObject fluentPutAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public JSONObject fluentClear() {
        this.map.clear();
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    public JSONObject fluentRemove(Object key) {
        this.map.remove(key);
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Object clone() {
        return new JSONObject(this.map instanceof LinkedHashMap ? new LinkedHashMap<String, Object>(this.map) : new HashMap<String, Object>(this.map));
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 1) {
            if ("equals".equals(method.getName())) {
                return this.equals(args[0]);
            }
            Class<?> returnType = method.getReturnType();
            if (returnType != Void.TYPE) {
                throw new com.alibaba.fastjson2.JSONException("illegal setter");
            }
            String name = null;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation != null && annotation.name().length() != 0) {
                name = annotation.name();
            }
            if (name == null) {
                name = method.getName();
                if (!name.startsWith("set")) {
                    throw new com.alibaba.fastjson2.JSONException("illegal setter");
                }
                if ((name = name.substring(3)).length() == 0) {
                    throw new com.alibaba.fastjson2.JSONException("illegal setter");
                }
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            this.map.put(name, args[0]);
            return null;
        }
        if (parameterTypes.length == 0) {
            Class<?> returnType = method.getReturnType();
            if (returnType == Void.TYPE) {
                throw new com.alibaba.fastjson2.JSONException("illegal getter");
            }
            String name = null;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation != null && annotation.name().length() != 0) {
                name = annotation.name();
            }
            if (name == null) {
                name = method.getName();
                if (name.startsWith("get")) {
                    if ((name = name.substring(3)).length() == 0) {
                        throw new com.alibaba.fastjson2.JSONException("illegal getter");
                    }
                    name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                } else if (name.startsWith("is")) {
                    if ((name = name.substring(2)).length() == 0) {
                        throw new com.alibaba.fastjson2.JSONException("illegal getter");
                    }
                    name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                } else {
                    if (name.startsWith("hashCode")) {
                        return this.hashCode();
                    }
                    if (name.startsWith("toString")) {
                        return this.toString();
                    }
                    throw new com.alibaba.fastjson2.JSONException("illegal getter");
                }
            }
            Object value = this.map.get(name);
            return com.alibaba.fastjson.util.TypeUtils.cast(value, method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        }
        throw new UnsupportedOperationException(method.toGenericString());
    }

    public Map<String, Object> getInnerMap() {
        return this.map;
    }

    @Override
    public <T> T toJavaObject(Type type) {
        if (type instanceof Class) {
            return JSONFactory.getDefaultObjectReaderProvider().getObjectReader(type).createInstance((Map)this, 0L);
        }
        String str = com.alibaba.fastjson2.JSON.toJSONString(this);
        return com.alibaba.fastjson2.JSON.parseObject(str, type);
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) {
        if (clazz == Map.class) {
            return (T)this;
        }
        if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
            return (T)this;
        }
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(clazz);
        return objectReader.createInstance((Map)this, JSONReader.Feature.SupportSmartMatch.mask);
    }

    public <T> T toJavaObject(Class<T> clazz, ParserConfig config, int features) {
        if (clazz == Map.class) {
            return (T)this;
        }
        if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
            return (T)this;
        }
        return com.alibaba.fastjson.util.TypeUtils.castToJavaBean(this, clazz, config);
    }

    public String toString() {
        return com.alibaba.fastjson2.JSON.toJSONString((Object)this, JSONWriter.Feature.ReferenceDetection);
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        if (iface == Map.class) {
            return (T)this.map;
        }
        return (T)this;
    }

    static final class Creator
    implements Supplier<Map> {
        static final Creator INSTANCE = new Creator();

        Creator() {
        }

        @Override
        public Map get() {
            return new JSONObject();
        }
    }
}

