/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.extractor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.downloader.Downloader;
import com.github.kiulian.downloader.downloader.request.RequestWebpage;
import com.github.kiulian.downloader.downloader.response.Response;
import com.github.kiulian.downloader.extractor.Extractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtractorImpl
implements Extractor {
    private static final String DEFAULT_CLIENT_VERSION = "2.20200720.00.02";
    private static final List<Pattern> YT_PLAYER_CONFIG_PATTERNS = Arrays.asList(Pattern.compile(";ytplayer\\.config = (\\{.*?\\})\\;ytplayer"), Pattern.compile(";ytplayer\\.config = (\\{.*?\\})\\;"), Pattern.compile("ytInitialPlayerResponse\\s*=\\s*(\\{.+?\\})\\s*\\;"));
    private static final List<Pattern> YT_INITIAL_DATA_PATTERNS = Arrays.asList(Pattern.compile("window\\[\"ytInitialData\"\\] = (\\{.*?\\});"), Pattern.compile("ytInitialData = (\\{.*?\\});"));
    private static final Pattern SUBTITLES_LANG_CODE_PATTERN = Pattern.compile("lang_code=\"(.{2,3})\"");
    private static final Pattern TEXT_NUMBER_REGEX = Pattern.compile("[0-9]+[0-9, ']*");
    private static final Pattern ASSETS_JS_REGEX = Pattern.compile("\"assets\":.+?\"js\":\\s*\"([^\"]+)\"");
    private static final Pattern EMB_JS_REGEX = Pattern.compile("\"jsUrl\":\\s*\"([^\"]+)\"");
    private final Downloader downloader;

    public ExtractorImpl(Downloader downloader) {
        this.downloader = downloader;
    }

    @Override
    public JSONObject extractInitialDataFromHtml(String string) throws YoutubeException {
        String string2 = null;
        for (Pattern pattern : YT_INITIAL_DATA_PATTERNS) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(1);
        }
        if (string2 == null) {
            throw new YoutubeException.BadPageException("Could not find initial data on web page");
        }
        try {
            return JSON.parseObject(string2);
        }
        catch (Exception exception) {
            throw new YoutubeException.BadPageException("Initial data contains invalid json");
        }
    }

    @Override
    public JSONObject extractPlayerConfigFromHtml(String string) throws YoutubeException {
        String string2 = null;
        for (Pattern pattern : YT_PLAYER_CONFIG_PATTERNS) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(1);
            break;
        }
        if (string2 == null) {
            throw new YoutubeException.BadPageException("Could not find player config on web page");
        }
        try {
            JSONObject jSONObject = JSON.parseObject(string2);
            if (jSONObject.containsKey("args")) {
                return jSONObject;
            }
            return new JSONObject().fluentPut("args", new JSONObject().fluentPut("player_response", jSONObject));
        }
        catch (Exception exception) {
            throw new YoutubeException.BadPageException("Player config contains invalid json");
        }
    }

    @Override
    public List<String> extractSubtitlesLanguagesFromXml(String string) throws YoutubeException {
        Matcher matcher = SUBTITLES_LANG_CODE_PATTERN.matcher(string);
        if (!matcher.find()) {
            throw new YoutubeException.BadPageException("Could not find any language code in subtitles xml");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            String string2 = matcher.group(1);
            arrayList.add(string2);
        } while (matcher.find());
        return arrayList;
    }

    @Override
    public String extractJsUrlFromConfig(JSONObject jSONObject, String string) throws YoutubeException {
        String string2 = null;
        if (jSONObject.containsKey("assets")) {
            string2 = jSONObject.getJSONObject("assets").getString("js");
        } else {
            Response<String> response = this.downloader.downloadWebpage(new RequestWebpage("https://www.youtube.com/embed/" + string));
            String string3 = response.data();
            Matcher matcher = ASSETS_JS_REGEX.matcher(string3);
            if (matcher.find()) {
                string2 = matcher.group(1).replace("\\", "");
            } else {
                matcher = EMB_JS_REGEX.matcher(string3);
                if (matcher.find()) {
                    string2 = matcher.group(1).replace("\\", "");
                }
            }
        }
        if (string2 == null) {
            throw new YoutubeException.BadPageException("Could not extract js url: assets not found");
        }
        return "https://youtube.com" + string2;
    }

    @Override
    public String extractClientVersionFromContext(JSONObject jSONObject) {
        JSONArray jSONArray = jSONObject.getJSONArray("serviceTrackingParams");
        if (jSONArray == null) {
            return DEFAULT_CLIENT_VERSION;
        }
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONArray jSONArray2 = jSONArray.getJSONObject(i).getJSONArray("params");
            for (int j = 0; j < jSONArray2.size(); ++j) {
                if (!jSONArray2.getJSONObject(j).getString("key").equals("cver")) continue;
                return jSONArray2.getJSONObject(j).getString("value");
            }
        }
        return DEFAULT_CLIENT_VERSION;
    }

    @Override
    public int extractIntegerFromText(String string) {
        Matcher matcher = TEXT_NUMBER_REGEX.matcher(string);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(0).replaceAll("[, ']", ""));
        }
        return 0;
    }

    @Override
    public long extractLongFromText(String string) {
        Matcher matcher = TEXT_NUMBER_REGEX.matcher(string);
        if (matcher.find()) {
            return Long.parseLong(matcher.group(0).replaceAll("[, ']", ""));
        }
        return 0L;
    }
}

