/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.videos.formats;

import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.model.videos.formats.Format;
import com.github.kiulian.downloader.model.videos.quality.AudioQuality;

public class AudioFormat
extends Format {
    private final Integer averageBitrate;
    private final Integer audioSampleRate;
    private final AudioQuality audioQuality;

    public AudioFormat(JSONObject jSONObject, boolean bl, String string) {
        super(jSONObject, bl, string);
        this.audioSampleRate = jSONObject.getInteger("audioSampleRate");
        this.averageBitrate = jSONObject.getInteger("averageBitrate");
        AudioQuality audioQuality = null;
        if (jSONObject.containsKey("audioQuality")) {
            String[] stringArray = jSONObject.getString("audioQuality").split("_");
            String string2 = stringArray[stringArray.length - 1].toLowerCase();
            try {
                audioQuality = AudioQuality.valueOf(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.audioQuality = audioQuality;
    }

    @Override
    public String type() {
        return "audio";
    }

    public Integer averageBitrate() {
        return this.averageBitrate;
    }

    public AudioQuality audioQuality() {
        return this.audioQuality != null ? this.audioQuality : this.itag.audioQuality();
    }

    public Integer audioSampleRate() {
        return this.audioSampleRate;
    }
}

