/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.videos.formats;

import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.model.videos.formats.Format;
import com.github.kiulian.downloader.model.videos.quality.VideoQuality;

public class VideoFormat
extends Format {
    private final int fps;
    private final String qualityLabel;
    private final Integer width;
    private final Integer height;
    private final VideoQuality videoQuality;

    public VideoFormat(JSONObject jSONObject, boolean bl, String string) {
        super(jSONObject, bl, string);
        Object object;
        this.fps = jSONObject.getInteger("fps");
        this.qualityLabel = jSONObject.getString("qualityLabel");
        if (jSONObject.containsKey("size")) {
            object = jSONObject.getString("size").split("x");
            this.width = Integer.parseInt(object[0]);
            this.height = Integer.parseInt(object[1]);
        } else {
            this.width = jSONObject.getInteger("width");
            this.height = jSONObject.getInteger("height");
        }
        object = null;
        if (jSONObject.containsKey("quality")) {
            try {
                object = VideoQuality.valueOf(jSONObject.getString("quality"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.videoQuality = object;
    }

    @Override
    public String type() {
        return "video";
    }

    public int fps() {
        return this.fps;
    }

    public VideoQuality videoQuality() {
        return this.videoQuality != null ? this.videoQuality : this.itag.videoQuality();
    }

    public String qualityLabel() {
        return this.qualityLabel;
    }

    public Integer width() {
        return this.width;
    }

    public Integer height() {
        return this.height;
    }
}

