/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtendedAttribute;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.util.ArrayList;
import java.util.List;

public class ExtendedAttributeDescriptor
extends UDFDescriptor {
    public long implementationAttributesLocation;
    public long applicationAttributesLocation;
    public List<ExtendedAttribute> extendedAttribs;
    public static final int LENGTH = 24;

    public ExtendedAttributeDescriptor() {
    }

    public ExtendedAttributeDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 262;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 24) {
            throw new InvalidDescriptor("Extended Attribute Header Descriptor too short");
        }
        this.deserializeTag(bytes);
        this.implementationAttributesLocation = this.getUInt32(bytes);
        this.applicationAttributesLocation = this.getUInt32(bytes);
        this.extendedAttribs = new ArrayList<ExtendedAttribute>();
        byte[] fragment = this.getBytes(bytes, bytes.length - 24);
        while (fragment.length > 0) {
            ExtendedAttribute ea = new ExtendedAttribute(bytes);
            this.extendedAttribs.add(ea);
        }
    }
}

