/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.CharSpec;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DString;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LongAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.Timestamp;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class FileSetDescriptor
extends UDFDescriptor {
    public Timestamp recordDateTime;
    public Integer interchangeLevel;
    public Integer maxInterchangeLevel;
    public Long charsetList;
    public Long maxCharsetList;
    public Long fileSetNum;
    public Long fileSetDescriptorNum;
    public CharSpec lvIdentifierCharset;
    public DString lvIdentifier;
    public CharSpec fileSetCharset;
    public DString fileSetIdentifier;
    public DString copyrightFileId;
    public DString abstractFileId;
    public LongAD rootICB;
    public RegId domainIdentifier;
    public LongAD nextExtent;
    public LongAD sysStreamDirICB;
    public static final int LENGTH = 512;

    public FileSetDescriptor() {
    }

    public FileSetDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 256;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 512) {
            throw new InvalidDescriptor("File set descriptor too short");
        }
        this.deserializeTag(bytes);
        this.recordDateTime = new Timestamp(this.getBytes(bytes, 12));
        this.interchangeLevel = this.getUInt16(bytes);
        this.maxInterchangeLevel = this.getUInt16(bytes);
        this.charsetList = this.getUInt32(bytes);
        this.maxCharsetList = this.getUInt32(bytes);
        this.fileSetNum = this.getUInt32(bytes);
        this.fileSetDescriptorNum = this.getUInt32(bytes);
        this.lvIdentifierCharset = new CharSpec(this.getBytes(bytes, 64));
        this.lvIdentifier = new DString(this.getBytes(bytes, 128));
        this.fileSetCharset = new CharSpec(this.getBytes(bytes, 64));
        this.fileSetIdentifier = new DString(this.getBytes(bytes, 32));
        this.copyrightFileId = new DString(this.getBytes(bytes, 32));
        this.abstractFileId = new DString(this.getBytes(bytes, 32));
        this.rootICB = new LongAD(this.getBytes(bytes, 16));
        this.domainIdentifier = new RegId(this.getBytes(bytes, 32));
        this.nextExtent = new LongAD(this.getBytes(bytes, 16));
        this.sysStreamDirICB = new LongAD(this.getBytes(bytes, 16));
        this.currentPos = 512;
    }
}

