/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.CharSpec;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DString;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LongAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMap;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMapMetadata;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMapSparable;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMapType1;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMapType2;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.util.ArrayList;
import java.util.List;

public class LogicalVolumeDescriptor
extends UDFDescriptor {
    public Long volumeDescriptorSequenceNumber;
    public CharSpec descriptorCharacterSet;
    public DString logicalVolumeIdentifier;
    public Long logicalBlockSize;
    public RegId domainIdentifier;
    public LongAD logicalVolumeContentsUse;
    public Long mapTableLength;
    public Long numberofPartitionMaps;
    public RegId implementationIdentifier;
    public byte[] implementationUse;
    public ExtentAD integritySequenceExtent;
    public List<PartitionMap> partitionMaps;
    public final int MINIMUM_LENGTH = 512;

    public LogicalVolumeDescriptor() {
    }

    public LogicalVolumeDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 6;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 512) {
            throw new InvalidDescriptor("Logical volume descriptor too short");
        }
        this.deserializeTag(bytes);
        this.volumeDescriptorSequenceNumber = this.getUInt32(bytes);
        this.descriptorCharacterSet = new CharSpec(this.getBytes(bytes, 64));
        this.logicalVolumeIdentifier = new DString(this.getBytes(bytes, 128));
        this.logicalBlockSize = this.getUInt32(bytes);
        this.domainIdentifier = new RegId(this.getBytes(bytes, 32));
        this.logicalVolumeContentsUse = new LongAD(this.getBytes(bytes, 16));
        this.mapTableLength = this.getUInt32(bytes);
        this.numberofPartitionMaps = this.getUInt32(bytes);
        this.implementationIdentifier = new RegId(this.getBytes(bytes, 32));
        this.implementationUse = this.getBytes(bytes, 128);
        this.integritySequenceExtent = new ExtentAD(this.getBytes(bytes, 8));
        this.partitionMaps = new ArrayList<PartitionMap>();
        int i = 0;
        while ((long)i < this.numberofPartitionMaps) {
            byte type = bytes[this.currentPos];
            if (type == 1) {
                PartitionMapType1 pm1 = new PartitionMapType1(this.getBytes(bytes, 6));
                this.partitionMaps.add(pm1);
            } else if (type == 2) {
                byte[] frag = this.getBytes(bytes, 64);
                PartitionMapType2 pm2 = new PartitionMapType2(frag);
                if (pm2.partitionTypeIdentifier.getId().equals("*UDF Sparable Partition")) {
                    this.partitionMaps.add(new PartitionMapSparable(frag));
                } else if (pm2.partitionTypeIdentifier.getId().equals("*UDF Metadata Partition")) {
                    this.partitionMaps.add(new PartitionMapMetadata(frag));
                }
            } else {
                new InvalidDescriptor("Unknown partition map type " + type);
            }
            ++i;
        }
    }
}

