/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.CharSpec;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DString;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.Timestamp;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class PrimaryVolumeDescriptor
extends UDFDescriptor {
    public Long volumeDescriptorSeq;
    public Long primaryVolumeDescriptorNum;
    public DString volumeIdentifier;
    public Integer volumeSeq;
    public Integer maxVolumeSeq;
    public Integer interchangeLevel;
    public Integer maxInterchangeLevel;
    public Long charsetList;
    public Long maxCharsetList;
    public DString volumeSetIdentifier;
    public CharSpec descriptorCharset;
    public CharSpec explanatoryCharset;
    public ExtentAD volumeAbstract;
    public ExtentAD volumeCopyrightNotice;
    public RegId appIdentifier;
    public Timestamp recordDateTime;
    public RegId implIdentifier;
    public byte[] implUse;
    public Long predecessorVDSeq;
    public Integer flags;
    public static final int LENGTH = 512;

    public PrimaryVolumeDescriptor() {
    }

    public PrimaryVolumeDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 1;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 512) {
            throw new InvalidDescriptor("Primary volume descriptor too short");
        }
        this.deserializeTag(bytes);
        this.volumeDescriptorSeq = this.getUInt32(bytes);
        this.primaryVolumeDescriptorNum = this.getUInt32(bytes);
        this.volumeIdentifier = new DString(this.getBytes(bytes, 32));
        this.volumeSeq = this.getUInt16(bytes);
        this.maxVolumeSeq = this.getUInt16(bytes);
        this.interchangeLevel = this.getUInt16(bytes);
        this.maxInterchangeLevel = this.getUInt16(bytes);
        this.charsetList = this.getUInt32(bytes);
        this.maxCharsetList = this.getUInt32(bytes);
        this.volumeSetIdentifier = new DString(this.getBytes(bytes, 128));
        this.descriptorCharset = new CharSpec(this.getBytes(bytes, 64));
        this.explanatoryCharset = new CharSpec(this.getBytes(bytes, 64));
        this.volumeAbstract = new ExtentAD(this.getBytes(bytes, 8));
        this.volumeCopyrightNotice = new ExtentAD(this.getBytes(bytes, 8));
        this.appIdentifier = new RegId(this.getBytes(bytes, 32));
        this.recordDateTime = new Timestamp(this.getBytes(bytes, 12));
        this.implIdentifier = new RegId(this.getBytes(bytes, 32));
        this.implUse = this.getBytes(bytes, 64);
        this.predecessorVDSeq = this.getUInt32(bytes);
        this.flags = this.getUInt16(bytes);
        this.currentPos = 512;
    }
}

