/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.nio.charset.StandardCharsets;

public class RegId {
    public int Flags;
    public byte[] Identifier;
    public byte[] IdentifierSuffix;
    public static final int LENGTH = 32;

    public RegId(byte[] bytes) throws InvalidDescriptor {
        this.deserialize(bytes);
    }

    private void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 32) {
            throw new InvalidDescriptor("RegId allocation descriptor too short");
        }
        this.Flags = UDFUtil.getUInt8(bytes, 0);
        this.Identifier = UDFUtil.getBytes(bytes, 1, 23);
        this.IdentifierSuffix = UDFUtil.getBytes(bytes, 24, 31);
    }

    public String getId() {
        return new String(this.Identifier);
    }

    public String toString() {
        return "RegId [Flags=" + this.Flags + ", Identifier=" + new String(this.Identifier, StandardCharsets.UTF_8).trim() + ", IdentifierSuffix=" + new String(this.IdentifierSuffix, StandardCharsets.UTF_8).trim() + "]";
    }
}

