/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.util.BigEndian;
import com.github.stephenc.javaisotools.loopfs.util.LittleEndian;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;

public final class Util {
    public static int getUInt8(byte[] block, int pos) {
        return LittleEndian.getUInt8((byte[])block, (int)(pos - 1));
    }

    public static int getInt8(byte[] block, int pos) {
        return LittleEndian.getInt8((byte[])block, (int)(pos - 1));
    }

    public static int getUInt16LE(byte[] block, int pos) {
        return LittleEndian.getUInt16((byte[])block, (int)(pos - 1));
    }

    public static int getUInt16BE(byte[] block, int pos) {
        return BigEndian.getUInt16((byte[])block, (int)(pos - 1));
    }

    public static int getUInt16Both(byte[] block, int pos) {
        return LittleEndian.getUInt16((byte[])block, (int)(pos - 1));
    }

    public static long getUInt32LE(byte[] block, int pos) {
        return LittleEndian.getUInt32((byte[])block, (int)(pos - 1));
    }

    public static long getUInt32BE(byte[] block, int pos) {
        return BigEndian.getUInt32((byte[])block, (int)(pos - 1));
    }

    public static long getUInt32Both(byte[] block, int pos) {
        return LittleEndian.getUInt32((byte[])block, (int)(pos - 1));
    }

    public static String getAChars(byte[] block, int pos, int length) {
        return new String(block, pos - 1, length).trim();
    }

    public static String getDChars(byte[] block, int pos, int length) {
        return new String(block, pos - 1, length).trim();
    }

    public static String getAChars(byte[] block, int pos, int length, String encoding) {
        try {
            return new String(block, pos - 1, length, encoding).trim();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getDChars(byte[] block, int pos, int length, String encoding) {
        if (block.length >= pos + length) {
            try {
                return new String(block, pos - 1, length, encoding).trim();
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return "";
    }

    public static byte[] getBytes(byte[] bytes, int pos, int length) {
        return Arrays.copyOfRange(bytes, pos, pos + length);
    }

    public static String getString(byte[] bytes, int pos, int length) {
        return Util.getString(bytes, pos, length, "ASCII");
    }

    public static String getString(byte[] bytes, int pos, int length, String encoding) {
        byte[] subArray = Util.getBytes(bytes, pos - 1, length);
        try {
            return new String(subArray, encoding).trim();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static long getStringDate(byte[] block, int pos) {
        int i = pos - 1;
        Calendar cal = Calendar.getInstance();
        cal.set(1, Util.toInt(block, i, 4));
        cal.set(2, Util.toInt(block, i += 4, 2) - 1);
        cal.set(5, Util.toInt(block, i += 2, 2));
        cal.set(11, Util.toInt(block, i += 2, 2));
        cal.set(12, Util.toInt(block, i += 2, 2));
        cal.set(13, Util.toInt(block, i += 2, 2));
        cal.set(14, Util.toInt(block, i += 2, 2) * 10);
        cal.setTimeZone(TimeZone.getTimeZone(Util.getGMTpos(block[i + 2])));
        return cal.getTimeInMillis();
    }

    private static int toInt(byte[] block, int pos, int len) {
        try {
            return Integer.parseInt(new String(block, pos, len));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static long getDateTime(byte[] sector, int pos) {
        int i = pos - 1;
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1900 + sector[i]);
        cal.set(2, sector[i + 1] - 1);
        cal.set(5, sector[i + 2]);
        cal.set(11, sector[i + 3]);
        cal.set(12, sector[i + 4]);
        cal.set(13, sector[i + 5]);
        cal.set(14, 0);
        cal.setTimeZone(TimeZone.getTimeZone(Util.getGMTpos(sector[i + 6])));
        return cal.getTimeInMillis();
    }

    private static String getGMTpos(byte b) {
        if (0 == b) {
            return "GMT";
        }
        StringBuffer buf = new StringBuffer("GMT");
        buf.append(b < 0 ? (char)'-' : '+');
        int posMinutes = Math.abs(b) * 15;
        int hours = posMinutes / 60;
        int minutes = posMinutes % 60;
        buf.append(hours).append(':').append(0 == minutes ? "00" : String.valueOf(minutes));
        return buf.toString();
    }

    private Util() {
    }
}

