/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import com.floreysoft.jmte.AnnotationProcessor;
import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import com.floreysoft.jmte.encoder.Encoder;
import com.floreysoft.jmte.encoder.XMLEncoder;
import com.floreysoft.jmte.extended.ChainedNamedRenderer;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.jmte.HtmlEncoder;
import org.tinymediamanager.core.jmte.JSONEncoder;
import org.tinymediamanager.core.jmte.NamedArrayRenderer;
import org.tinymediamanager.core.jmte.NamedArrayUniqueRenderer;
import org.tinymediamanager.core.jmte.NamedBitrateRenderer;
import org.tinymediamanager.core.jmte.NamedDateRenderer;
import org.tinymediamanager.core.jmte.NamedFilesizeRenderer;
import org.tinymediamanager.core.jmte.NamedFirstCharacterRenderer;
import org.tinymediamanager.core.jmte.NamedFramerateRenderer;
import org.tinymediamanager.core.jmte.NamedLowerCaseRenderer;
import org.tinymediamanager.core.jmte.NamedNumberRenderer;
import org.tinymediamanager.core.jmte.NamedReplacementRenderer;
import org.tinymediamanager.core.jmte.NamedSplitRenderer;
import org.tinymediamanager.core.jmte.NamedTitleCaseRenderer;
import org.tinymediamanager.core.jmte.NamedUpperCaseRenderer;
import org.tinymediamanager.core.jmte.RegexpProcessor;

public abstract class MediaEntityExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaEntityExporter.class);
    protected static final String TEMPLATE_DIRECTORY = "templates";
    protected Engine engine;
    protected Properties properties;
    protected String fileName;
    protected String fileExtension;
    protected String listTemplate = "";
    protected String detailTemplate = "";
    protected Path templateDir;
    protected boolean cancel = false;

    protected MediaEntityExporter(Path templatePath, TemplateType type) throws Exception {
        this.templateDir = templatePath;
        if (!Files.isDirectory(this.templateDir, new LinkOption[0])) {
            throw new FileNotFoundException("illegal template path");
        }
        Path configFile = this.templateDir.resolve("template.conf");
        if (!Files.exists(configFile, new LinkOption[0])) {
            throw new FileNotFoundException("no template config found");
        }
        this.properties = new Properties();
        try (InputStream is = Files.newInputStream(configFile, new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(is);){
            this.properties.load(bis);
        }
        String typeInConfig = this.properties.getProperty("type");
        if (!typeInConfig.equalsIgnoreCase(type.name())) {
            throw new Exception("illegal template");
        }
        String listTemplateFile = this.properties.getProperty("list");
        if (StringUtils.isBlank((CharSequence)listTemplateFile)) {
            throw new Exception("illegal template");
        }
        String detailTemplateFile = this.properties.getProperty("detail");
        this.fileName = StringUtils.isBlank((CharSequence)this.properties.getProperty("filename")) ? "" : this.properties.getProperty("filename");
        this.fileExtension = StringUtils.isBlank((CharSequence)this.properties.getProperty("extension")) ? "html" : this.properties.getProperty("extension").toLowerCase();
        this.engine = Engine.createEngine();
        this.engine.registerAnnotationProcessor((AnnotationProcessor)new RegexpProcessor());
        if ("html".equals(this.fileExtension)) {
            this.engine.setEncoder((Encoder)new HtmlEncoder());
        } else if ("xml".equals(this.fileExtension)) {
            this.engine.setEncoder((Encoder)new XMLEncoder());
        } else if ("json".equals(this.fileExtension)) {
            this.engine.setEncoder((Encoder)new JSONEncoder());
        }
        this.listTemplate = Utils.readFileToString(this.templateDir.resolve(listTemplateFile));
        if (StringUtils.isNotBlank((CharSequence)detailTemplateFile)) {
            this.detailTemplate = Utils.readFileToString(this.templateDir.resolve(detailTemplateFile));
        }
    }

    protected void registerDefaultRenderers() {
        this.engine.registerNamedRenderer((NamedRenderer)new NamedArrayRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedArrayUniqueRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedBitrateRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedDateRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedFilesizeRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedFirstCharacterRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedFramerateRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedLowerCaseRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedNumberRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedReplacementRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedSplitRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedTitleCaseRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new NamedUpperCaseRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new ChainedNamedRenderer(this.engine.getAllNamedRenderers()));
    }

    public abstract <T extends MediaEntity> void export(List<T> var1, Path var2) throws Exception;

    public void cancel() {
        this.cancel = true;
    }

    public static List<ExportTemplate> findTemplates(TemplateType type) {
        ArrayList<ExportTemplate> templatesFound = new ArrayList<ExportTemplate>();
        Path templateInTmmDir = Paths.get(TEMPLATE_DIRECTORY, new String[0]).toAbsolutePath();
        templatesFound.addAll(MediaEntityExporter.findTemplatesInFolder(templateInTmmDir, type));
        Path templateInContentDir = Paths.get(Globals.CONTENT_FOLDER, TEMPLATE_DIRECTORY).toAbsolutePath();
        if (!templateInContentDir.equals(templateInTmmDir)) {
            templatesFound.addAll(MediaEntityExporter.findTemplatesInFolder(templateInContentDir, type));
        }
        templatesFound.sort((o1, o2) -> StringUtils.compare((String)o1.getName(), (String)o2.getName()));
        return templatesFound;
    }

    private static List<ExportTemplate> findTemplatesInFolder(Path folder, TemplateType type) {
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<ExportTemplate> templatesFound = new ArrayList<ExportTemplate>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(folder);){
            for (Path path : directoryStream) {
                Path config;
                if (!Files.isDirectory(path, new LinkOption[0]) || !Files.exists(config = path.resolve("template.conf"), new LinkOption[0])) continue;
                Properties properties = new Properties();
                try (InputStream is = Files.newInputStream(config, new OpenOption[0]);
                     BufferedInputStream bis = new BufferedInputStream(is);){
                    properties.load(bis);
                }
                catch (Exception e) {
                    LOGGER.warn("error in config \"{}\" - {} ", (Object)path, (Object)e.getMessage());
                    continue;
                }
                String typeInConfig = properties.getProperty("type");
                if (StringUtils.isBlank((CharSequence)typeInConfig) || !typeInConfig.equalsIgnoreCase(type.name())) continue;
                ExportTemplate template = new ExportTemplate();
                template.setName(properties.getProperty("name"));
                template.setType(type);
                template.setPath(path.toAbsolutePath().toString());
                template.setUrl(properties.getProperty("url"));
                template.setDescription(properties.getProperty("description"));
                if (StringUtils.isNotBlank((CharSequence)properties.getProperty("detail"))) {
                    template.setDetail(true);
                } else {
                    template.setDetail(false);
                }
                templatesFound.add(template);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return templatesFound;
    }

    public static enum TemplateType {
        MOVIE,
        MOVIE_SET,
        TV_SHOW;

    }

    protected static abstract class ArtworkCopyRenderer
    implements NamedRenderer {
        protected Path pathToExport;

        public ArtworkCopyRenderer(Path pathToExport) {
            this.pathToExport = pathToExport;
        }

        public RenderFormatInfo getFormatInfo() {
            return null;
        }

        public String getName() {
            return "copyArtwork";
        }

        protected Map<String, Object> parseParameters(String parameters) {
            String[] details;
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("thumb", Boolean.FALSE);
            parameterMap.put("destination", "images");
            block20: for (String detail : details = parameters.split(",")) {
                String key = "";
                String value = "";
                try {
                    String[] d = detail.split("=");
                    key = d[0].strip();
                    value = d[1].strip();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) continue;
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "type": {
                        try {
                            MediaFileType type = MediaFileType.valueOf(value.toUpperCase(Locale.ROOT));
                            parameterMap.put(key, (Object)type);
                        }
                        catch (Exception exception) {}
                        continue block20;
                    }
                    case "destination": 
                    case "default": {
                        parameterMap.put(key, value);
                        continue block20;
                    }
                    case "thumb": 
                    case "escape": {
                        parameterMap.put(key, Boolean.parseBoolean(value));
                        continue block20;
                    }
                    case "width": {
                        try {
                            parameterMap.put(key, Integer.parseInt(value));
                        }
                        catch (Exception exception) {}
                        continue block20;
                    }
                }
            }
            return parameterMap;
        }
    }
}

