/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.IPrintable;
import org.tinymediamanager.core.TmmToStringStyle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.StrgUtils;

public class Person
extends AbstractModelObject
implements IPrintable {
    public static final String ACTOR_DIR = ".actors";
    public static final String PRODUCER_DIR = ".producers";
    @JsonProperty
    private Type type = Type.OTHER;
    @JsonProperty
    private String name = "";
    @JsonProperty
    private String role = "";
    @JsonProperty
    private String thumbUrl = "";
    @JsonProperty
    private String profileUrl = "";
    @JsonProperty
    private Map<String, Object> ids = null;

    public Person() {
    }

    public Person(Type type) {
        this.type = type;
    }

    public Person(Type type, String name) {
        this(type);
        this.setName(name);
    }

    public Person(Type type, String name, String role) {
        this(type, name);
        this.setRole(role);
    }

    public Person(Type type, String name, String role, String thumbUrl) {
        this(type, name, role);
        this.setThumbUrl(thumbUrl);
    }

    public Person(Type type, String name, String role, String thumbUrl, String profileUrl) {
        this(type, name, role, thumbUrl);
        this.setProfileUrl(profileUrl);
    }

    public Person(Person source) {
        this.type = source.type;
        this.name = source.name;
        this.role = source.role;
        this.thumbUrl = source.thumbUrl;
        this.profileUrl = source.profileUrl;
        if (source.ids != null && !source.ids.isEmpty()) {
            this.ids = new HashMap<String, Object>(source.ids);
        }
    }

    public void merge(Person other) {
        this.merge(other, false);
    }

    public void merge(Person other, boolean force) {
        if (other == null) {
            return;
        }
        this.setName(StringUtils.isBlank((CharSequence)this.name) || force ? other.name : this.name);
        this.setRole(StringUtils.isBlank((CharSequence)this.role) || force ? other.role : this.role);
        this.setThumbUrl(StringUtils.isBlank((CharSequence)this.thumbUrl) || force ? other.thumbUrl : this.thumbUrl);
        this.setProfileUrl(StringUtils.isBlank((CharSequence)this.profileUrl) || force ? other.profileUrl : this.profileUrl);
        if (this.ids == null && !other.getIds().isEmpty()) {
            this.ids = new HashMap<String, Object>(other.ids);
        } else if (this.ids != null) {
            for (String key : other.getIds().keySet()) {
                if (force) {
                    this.ids.put(key, other.getId(key));
                    continue;
                }
                this.ids.putIfAbsent(key, other.getId(key));
            }
        }
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setId(String key, Object value) {
        String v;
        if (this.ids == null) {
            this.ids = new HashMap<String, Object>(0);
        }
        if ("".equals(v = StringUtils.strip((String)String.valueOf(value))) || "0".equals(v) || "null".equals(v)) {
            this.ids.remove(key);
        } else {
            this.ids.put(key, value);
        }
    }

    public Object getId(String key) {
        if (this.ids == null) {
            return null;
        }
        return this.ids.get(key);
    }

    public String getIdAsString(String key) {
        return MediaIdUtil.getIdAsString(this.ids, key);
    }

    public int getIdAsInt(String key) {
        return MediaIdUtil.getIdAsInt(this.ids, key);
    }

    public Map<String, Object> getIds() {
        if (this.ids == null) {
            return Collections.emptyMap();
        }
        return this.ids;
    }

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String getName() {
        return this.name;
    }

    public String getNameForStorage() {
        String n = this.name.replace(" ", "_");
        n = n.replaceAll("([\"\\\\:<>|/?*])", "");
        String ext = Utils.getArtworkExtensionFromUrl(this.thumbUrl);
        if (ext.isEmpty()) {
            ext = "jpg";
        }
        return n + "." + ext;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String newValue) {
        String oldValue = this.role;
        this.role = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("role", oldValue, newValue);
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public void setThumbUrl(String newValue) {
        String oldValue = this.thumbUrl;
        this.thumbUrl = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("thumb", oldValue, newValue);
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String newValue) {
        String oldValue = this.profileUrl;
        this.profileUrl = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("profileUrl", oldValue, newValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        return (this.type == person.type || this.type == Type.ACTOR && person.type == Type.GUEST || this.type == Type.GUEST && person.type == Type.ACTOR) && Objects.equals(this.name, person.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TmmToStringStyle.TMM_STYLE, (boolean)false, Person.class);
    }

    @Override
    public String toPrintable() {
        return this.getName();
    }

    public static enum Type {
        ACTOR,
        DIRECTOR,
        WRITER,
        PRODUCER,
        GUEST,
        OTHER;

    }
}

