/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieGenericXmlConnector;
import org.tinymediamanager.core.movie.entities.Movie;
import org.w3c.dom.Element;

public class MovieToKodiConnector
extends MovieGenericXmlConnector {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MovieToKodiConnector.class);
    protected static final Pattern HD_TRAILERS_PATTERN = Pattern.compile("https?://.*(apple.com|yahoo-redir|yahoo.com|youtube.com|moviefone.com|ign.com|hd-trailers.net|aol.com).*");

    public MovieToKodiConnector(Movie movie) {
        super(movie);
    }

    @Override
    protected void addOwnTags() {
        this.addEpbookmark();
        this.addTop250();
        this.addStatusAndCode();
    }

    @Override
    protected void addSet() {
        Element set = this.document.createElement("set");
        if (this.movie.getMovieSet() != null) {
            Element name = this.document.createElement("name");
            name.setTextContent(this.movie.getMovieSet().getTitle());
            set.appendChild(name);
            Element overview = this.document.createElement("overview");
            overview.setTextContent(this.movie.getMovieSet().getPlot());
            set.appendChild(overview);
        }
        this.root.appendChild(set);
    }

    @Override
    protected void addThumb() {
        this.addThumb(MediaFileType.POSTER, "poster");
        this.addThumb(MediaFileType.BANNER, "banner");
        this.addThumb(MediaFileType.CLEARART, "clearart");
        this.addThumb(MediaFileType.CLEARLOGO, "clearlogo");
        this.addThumb(MediaFileType.DISC, "discart");
        this.addThumb(MediaFileType.THUMB, "landscape");
        this.addThumb(MediaFileType.KEYART, "keyart");
        this.addThumb(MediaFileType.LOGO, "logo");
    }

    protected void addThumb(MediaFileType type, String aspect) {
        Element thumb = this.document.createElement("thumb");
        String artworkUrl = this.movie.getArtworkUrl(type);
        if (StringUtils.isNotBlank((CharSequence)artworkUrl)) {
            thumb.setAttribute("aspect", aspect);
            thumb.setTextContent(artworkUrl);
            this.root.appendChild(thumb);
        }
    }

    @Override
    protected void addFanart() {
        Element fanart = this.document.createElement("fanart");
        LinkedHashSet<String> fanartUrls = new LinkedHashSet<String>();
        String fanartUrl = this.movie.getArtworkUrl(MediaFileType.FANART);
        if (StringUtils.isNotBlank((CharSequence)fanartUrl)) {
            fanartUrls.add(fanartUrl);
        }
        fanartUrls.addAll(this.movie.getExtraFanarts());
        for (String url : fanartUrls) {
            Element thumb = this.document.createElement("thumb");
            thumb.setTextContent(url);
            fanart.appendChild(thumb);
        }
        if (!fanartUrls.isEmpty()) {
            this.root.appendChild(fanart);
        }
    }

    @Override
    protected void addTrailer() {
        if (MovieModuleManager.getInstance().getSettings().isNfoWriteTrailer()) {
            Element trailer = this.document.createElement("trailer");
            for (MediaTrailer mediaTrailer : new ArrayList<MediaTrailer>(this.movie.getTrailer())) {
                if (!mediaTrailer.getInNfo().booleanValue()) continue;
                if (mediaTrailer.getUrl().startsWith("http")) {
                    trailer.setTextContent(this.prepareTrailerForKodi(mediaTrailer));
                    break;
                }
                trailer.setTextContent(mediaTrailer.getUrl());
                break;
            }
            this.root.appendChild(trailer);
        }
    }

    protected String prepareTrailerForKodi(MediaTrailer trailer) {
        Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(trailer.getUrl());
        if (matcher.matches()) {
            return "plugin://plugin.video.youtube/play/?video_id=" + matcher.group(5);
        }
        matcher = HD_TRAILERS_PATTERN.matcher(trailer.getUrl());
        if (matcher.matches()) {
            try {
                return "plugin://plugin.video.hdtrailers_net/video/" + matcher.group(1) + "/" + URLEncoder.encode(trailer.getUrl(), "UTF-8");
            }
            catch (Exception e) {
                LOGGER.debug("failed to escape {} - {}", (Object)trailer.getUrl(), (Object)e.getMessage());
            }
        }
        return trailer.getUrl();
    }

    @Override
    protected void addRating() {
        Element ratings = this.document.createElement("ratings");
        MediaRating mainMediaRating = this.movie.getRating();
        for (MediaRating r : this.movie.getRatings().values()) {
            if ("user".equals(r.getId())) continue;
            Element rating = this.document.createElement("rating");
            if ("tmdb".equals(r.getId())) {
                rating.setAttribute("name", "themoviedb");
            } else {
                rating.setAttribute("name", r.getId());
            }
            rating.setAttribute("max", String.valueOf(r.getMaxValue()));
            rating.setAttribute("default", r == mainMediaRating ? "true" : "false");
            Element value = this.document.createElement("value");
            value.setTextContent(String.format(Locale.US, "%.1f", Float.valueOf(r.getRating())));
            rating.appendChild(value);
            Element votes = this.document.createElement("votes");
            votes.setTextContent(Integer.toString(r.getVotes()));
            rating.appendChild(votes);
            ratings.appendChild(rating);
        }
        this.root.appendChild(ratings);
    }

    @Override
    protected void addVotes() {
    }

    protected void addEpbookmark() {
        Element epbookmark = this.document.createElement("epbookmark");
        Element year = this.getSingleElementByTag("year");
        if (this.parser != null) {
            epbookmark.setTextContent(this.parser.epbookmark);
        }
        this.root.insertBefore(epbookmark, year);
    }

    protected void addTop250() {
        Element top250 = this.document.createElement("top250");
        top250.setTextContent(Integer.toString(this.movie.getTop250()));
        Element set = this.getSingleElementByTag("set");
        this.root.insertBefore(top250, set);
    }

    protected void addStatusAndCode() {
        Element status = this.document.createElement("status");
        Element code = this.document.createElement("code");
        Element premiered = this.getSingleElementByTag("premiered");
        if (this.parser != null) {
            status.setTextContent(this.parser.status);
            code.setTextContent(this.parser.code);
        }
        this.root.insertBefore(status, premiered);
        this.root.insertBefore(code, premiered);
    }
}

