/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.filenaming.MovieExtraFanartNaming;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class MovieExtraImageFetcherTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieExtraImageFetcherTask.class);
    private final Movie movie;
    private final MediaFileType type;
    private final List<MovieExtraFanartNaming> extraFanartNamings;

    public MovieExtraImageFetcherTask(Movie movie, MediaFileType type) {
        this.movie = movie;
        this.type = type;
        this.extraFanartNamings = MovieArtworkHelper.getExtraFanartNamesForMovie(movie);
    }

    @Override
    public void run() {
        try {
            boolean ok;
            switch (this.type) {
                case EXTRATHUMB: {
                    ok = this.downloadExtraThumbs();
                    break;
                }
                case EXTRAFANART: {
                    ok = this.downloadExtraFanart();
                    break;
                }
                default: {
                    return;
                }
            }
            if (Thread.interrupted()) {
                return;
            }
            if (ok) {
                this.movie.callbackForWrittenArtwork(MediaArtwork.MediaArtworkType.ALL);
                this.movie.saveToDb();
            }
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed: ", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "message.extraimage.threadcrashed"));
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean downloadExtraFanart() {
        fanarts = this.movie.getExtraFanarts();
        if (fanarts.isEmpty()) {
            return false;
        }
        if (this.extraFanartNamings.isEmpty()) {
            return false;
        }
        for (MediaFile mediaFile : this.movie.getMediaFiles(new MediaFileType[]{MediaFileType.EXTRAFANART})) {
            Utils.deleteFileSafely(mediaFile.getFile());
            this.movie.removeFromMediaFiles(mediaFile);
        }
        fileNaming = this.extraFanartNamings.get(0);
        if (fileNaming == MovieExtraFanartNaming.FOLDER_EXTRAFANART) {
            folder = this.movie.getPathNIO().resolve("extrafanart");
            try {
                if (Files.exists(folder, new LinkOption[0])) ** GOTO lbl23
                Files.createDirectory(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                MovieExtraImageFetcherTask.LOGGER.error("could not create extrafanarts folder: {}", (Object)e.getMessage());
                return false;
            }
        } else {
            folder = this.movie.getPathNIO();
        }
lbl23:
        // 3 sources

        i = 1;
        for (String urlAsString : fanarts) {
            try {
                extension = Utils.getArtworkExtensionFromUrl(urlAsString);
                filename = MovieArtworkHelper.getArtworkFilename(this.movie, fileNaming, extension);
                basename = FilenameUtils.getBaseName((String)filename);
                filename = basename + i + "." + extension;
                destFile = ImageUtils.downloadImage(urlAsString, folder, (String)filename);
                mf = new MediaFile(destFile, MediaFileType.EXTRAFANART);
                mf.gatherMediaInformation();
                this.movie.addToMediaFiles(mf);
                ImageCache.invalidateCachedImage(destFile);
                ImageCache.cacheImageSilently(destFile);
                ++i;
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                MovieExtraImageFetcherTask.LOGGER.warn("problem downloading extrafanart {} - {} ", (Object)urlAsString, (Object)e.getMessage());
            }
        }
        return true;
    }

    private boolean downloadExtraThumbs() {
        if (this.movie.isMultiMovieDir()) {
            LOGGER.info("Movie '{}' is within a multi-movie-directory - skip downloading of {} images.", (Object)this.movie.getTitle(), (Object)this.type);
            return false;
        }
        List<String> thumbs = this.movie.getExtraThumbs();
        if (thumbs.isEmpty()) {
            return false;
        }
        Path folder = this.movie.getPathNIO().resolve("extrathumbs");
        try {
            if (Files.isDirectory(folder, new LinkOption[0])) {
                Utils.deleteDirectorySafely(folder, this.movie.getDataSource());
                this.movie.removeAllMediaFiles(MediaFileType.EXTRATHUMB);
            }
            Files.createDirectory(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("could not create extrathumbs folder: {}", (Object)e.getMessage());
            return false;
        }
        int i = 1;
        for (String urlAsString : thumbs) {
            try {
                String filename = "thumb" + i + ".";
                filename = MovieModuleManager.getInstance().getSettings().isImageExtraThumbsResize() ? filename + "jpg" : filename + FilenameUtils.getExtension((String)urlAsString);
                Path destFile = ImageUtils.downloadImage(urlAsString, folder, filename, MovieModuleManager.getInstance().getSettings().isImageExtraThumbsResize(), MovieModuleManager.getInstance().getSettings().getImageExtraThumbsSize());
                MediaFile mf = new MediaFile(destFile, MediaFileType.EXTRATHUMB);
                mf.gatherMediaInformation();
                this.movie.addToMediaFiles(mf);
                ImageCache.cacheImageSilently(destFile);
                if (Thread.interrupted()) {
                    return false;
                }
                ++i;
            }
            catch (Exception e) {
                LOGGER.warn("problem downloading extrathumb {} - {}", (Object)urlAsString, (Object)e.getMessage());
            }
        }
        return true;
    }
}

