/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieSetMetadataProvider;

public class MovieSetScrapeTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetScrapeTask.class);
    private final List<MovieSet> movieSetsToScrape;
    private final MovieSetSearchAndScrapeOptions scrapeOptions;
    private final List<MovieSetScraperMetadataConfig> scraperMetadataConfig;

    public MovieSetScrapeTask(List<MovieSet> movieSetsToScrape, MovieSetSearchAndScrapeOptions scrapeOptions, List<MovieSetScraperMetadataConfig> movieSetScraperMetadataConfig) {
        super(TmmResourceBundle.getString("movieset.scraping"));
        this.movieSetsToScrape = movieSetsToScrape;
        this.scrapeOptions = scrapeOptions;
        this.scraperMetadataConfig = movieSetScraperMetadataConfig;
    }

    @Override
    protected void doInBackground() {
        LOGGER.debug("start scraping movie sets...");
        this.start();
        this.initThreadPool(3, "scrape");
        for (MovieSet movieSet : this.movieSetsToScrape) {
            this.submitTask(new Worker(movieSet));
        }
        this.waitForCompletionOrCancel();
        LOGGER.debug("done scraping movie sets...");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private final MovieSet movieSet;

        private Worker(MovieSet movieSet) {
            this.movieSet = movieSet;
        }

        @Override
        public void run() {
            try {
                List<MovieSet.MovieSetMovie> movieSetMovies;
                MediaScraper mediaMetadataScraper = MovieSetScrapeTask.this.scrapeOptions.getMetadataScraper();
                List<MediaScraper> artworkScrapers = MovieSetScrapeTask.this.scrapeOptions.getArtworkScrapers();
                MovieSetSearchAndScrapeOptions options = new MovieSetSearchAndScrapeOptions(MovieSetScrapeTask.this.scrapeOptions);
                options.setIds(this.movieSet.getIds());
                MediaMetadata metadata = ((IMovieSetMetadataProvider)mediaMetadataScraper.getMediaProvider()).getMetadata(options);
                if (ScraperMetadataConfig.containsAnyMetadata(MovieSetScrapeTask.this.scraperMetadataConfig) || ScraperMetadataConfig.containsAnyCast(MovieSetScrapeTask.this.scraperMetadataConfig)) {
                    this.movieSet.setMetadata(metadata, MovieSetScrapeTask.this.scraperMetadataConfig);
                }
                if (ScraperMetadataConfig.containsAnyArtwork(MovieSetScrapeTask.this.scraperMetadataConfig)) {
                    this.movieSet.setArtwork(this.getArtwork(this.movieSet, metadata, artworkScrapers), MovieSetScrapeTask.this.scraperMetadataConfig);
                }
                if (!(movieSetMovies = this.createMovieSetMovies(metadata)).isEmpty()) {
                    this.movieSet.setDummyMovies(movieSetMovies);
                    this.movieSet.saveToDb();
                }
            }
            catch (Exception e) {
                LOGGER.error("getMetadata", (Throwable)e);
            }
        }

        private List<MediaArtwork> getArtwork(MovieSet movieSet, MediaMetadata metadata, List<MediaScraper> artworkScrapers) {
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.MOVIE_SET);
            options.setDataFromOtherOptions(MovieSetScrapeTask.this.scrapeOptions);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(metadata);
            if (metadata != null) {
                options.addIds(metadata.getIds());
            }
            options.setLanguage(MovieModuleManager.getInstance().getSettings().getDefaultImageScraperLanguage());
            options.setFanartSize(MovieModuleManager.getInstance().getSettings().getImageFanartSize());
            options.setPosterSize(MovieModuleManager.getInstance().getSettings().getImagePosterSize());
            for (MediaScraper scraper : artworkScrapers) {
                IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)scraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (MissingIdException missingIdException) {
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movieSet, "message.scrape.movieartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
            return artwork;
        }

        private List<MovieSet.MovieSetMovie> createMovieSetMovies(MediaMetadata info) {
            if (info == null) {
                return Collections.emptyList();
            }
            ArrayList<MovieSet.MovieSetMovie> movieSetMovies = new ArrayList<MovieSet.MovieSetMovie>();
            for (MediaMetadata item : info.getSubItems()) {
                int preferredSizeOrder;
                MovieSet.MovieSetMovie movieSetMovie = new MovieSet.MovieSetMovie();
                movieSetMovie.setMetadata(item, Arrays.asList(MovieScraperMetadataConfig.values()), true);
                movieSetMovie.setLastScraperId(MovieSetScrapeTask.this.scrapeOptions.getMetadataScraper().getId());
                movieSetMovie.setLastScrapeLanguage(MovieSetScrapeTask.this.scrapeOptions.getLanguage().name());
                if (!item.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                    preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImagePosterSize().getOrder();
                    List<MediaArtwork.ImageSizeAndUrl> sortedPosters = MovieArtworkHelper.sortArtworkUrls(item.getMediaArt(), MediaArtwork.MediaArtworkType.POSTER, preferredSizeOrder);
                    if (!sortedPosters.isEmpty()) {
                        movieSetMovie.setArtworkUrl(sortedPosters.get(0).getUrl(), MediaFileType.POSTER);
                    }
                }
                if (!item.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).isEmpty()) {
                    preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
                    List<MediaArtwork.ImageSizeAndUrl> sortedFanarts = MovieArtworkHelper.sortArtworkUrls(item.getMediaArt(), MediaArtwork.MediaArtworkType.BACKGROUND, preferredSizeOrder);
                    if (!sortedFanarts.isEmpty()) {
                        movieSetMovie.setArtworkUrl(sortedFanarts.get(0).getUrl(), MediaFileType.FANART);
                    }
                }
                movieSetMovies.add(movieSetMovie);
            }
            return movieSetMovies;
        }
    }
}

