/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;

public class TvShowUpgradeTasks
extends UpgradeTasks {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowUpgradeTasks.class);

    @Override
    public void performDbUpgrades() {
        MediaFile mf;
        TvShowModuleManager module = TvShowModuleManager.getInstance();
        TvShowList tvShowList = module.getTvShowList();
        if (module.getDbVersion() == 0) {
            module.setDbVersion(5000);
        }
        LOGGER.info("Current tvshow DB version: {}", (Object)module.getDbVersion());
        if (module.getDbVersion() < 5001) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5001);
            for (TvShow tvShow : tvShowList.getTvShows()) {
                for (MediaFile mf2 : tvShow.getMediaFiles(MediaFileType.LOGO)) {
                    tvShow.removeFromMediaFiles(mf2);
                    mf2.setType(MediaFileType.CLEARLOGO);
                    tvShow.addToMediaFiles(mf2);
                }
                String logoUrl = tvShow.getArtworkUrl(MediaFileType.LOGO);
                if (StringUtils.isNotBlank((CharSequence)logoUrl)) {
                    tvShow.removeArtworkUrl(MediaFileType.LOGO);
                    String clearlogoUrl = tvShow.getArtworkUrl(MediaFileType.CLEARLOGO);
                    if (StringUtils.isBlank((CharSequence)clearlogoUrl)) {
                        tvShow.setArtworkUrl(logoUrl, MediaFileType.CLEARLOGO);
                    }
                }
                List<MediaFile> seasonMediaFiles = tvShow.getMediaFiles(MediaFileType.SEASON_POSTER, MediaFileType.SEASON_BANNER, MediaFileType.SEASON_THUMB, MediaFileType.SEASON_FANART);
                Iterator<Object> iterator = seasonMediaFiles.iterator();
                while (iterator.hasNext()) {
                    mf = (MediaFile)iterator.next();
                    if (mf.getFilesize() != 0L) {
                        String foldername = tvShow.getPathNIO().relativize(mf.getFileAsPath().getParent()).toString();
                        int season = TvShowHelpers.detectSeasonFromFileAndFolder(mf.getFilename(), foldername);
                        if (season != Integer.MIN_VALUE) {
                            TvShowSeason tvShowSeason = tvShow.getOrCreateSeason(season);
                            tvShowSeason.addToMediaFiles(mf);
                        }
                    }
                    tvShow.removeFromMediaFiles(mf);
                }
                for (TvShowSeason season : tvShow.getSeasons()) {
                    season.setTvShow(tvShow);
                    this.registerForSaving(season);
                }
                for (TvShowEpisode episode : tvShow.getEpisodes()) {
                    this.registerForSaving(episode);
                }
                this.registerForSaving(tvShow);
            }
            module.setDbVersion(5001);
        }
        if (module.getDbVersion() < 5002) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5002);
            for (TvShow tvShow : tvShowList.getTvShows()) {
                if (tvShow.getEpisodeGroup() == null || tvShow.getEpisodeGroup() != null && tvShow.getEpisodeGroup().getEpisodeGroupType() == null) {
                    tvShow.setEpisodeGroup(MediaEpisodeGroup.DEFAULT_AIRED);
                }
                tvShow.getEpisodes().forEach(x$0 -> this.registerForSaving((MediaEntity)x$0));
                this.registerForSaving(tvShow);
            }
            module.setDbVersion(5002);
        }
        if (module.getDbVersion() < 5003) {
            for (TvShow tvShow : tvShowList.getTvShows()) {
                Iterator<TvShowSeason> toRemove = new ArrayList();
                for (MediaFile mf3 : tvShow.getMediaFiles(MediaFileType.POSTER)) {
                    if (mf3.getPath().equals(tvShow.getPath())) continue;
                    mf3.setType(MediaFileType.SEASON_POSTER);
                    String foldername = tvShow.getPathNIO().relativize(mf3.getFileAsPath().getParent()).toString();
                    int season = TvShowHelpers.detectSeasonFromFileAndFolder(mf3.getFilename(), foldername);
                    if (season == Integer.MIN_VALUE) continue;
                    TvShowSeason tvShowSeason = tvShow.getOrCreateSeason(season);
                    tvShowSeason.addToMediaFiles(mf3);
                    this.registerForSaving(tvShowSeason);
                    toRemove.add((TvShowSeason)((Object)mf3));
                }
                if (toRemove.isEmpty()) continue;
                toRemove.forEach(tvShow::removeFromMediaFiles);
                this.registerForSaving(tvShow);
            }
            module.setDbVersion(5003);
        }
        if (module.getDbVersion() < 5004) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5004);
            for (TvShow tvShow : tvShowList.getTvShows()) {
                for (TvShowEpisode episode : tvShow.getEpisodes()) {
                    if (!TvShowUpgradeTasks.fixRatings(episode)) continue;
                    this.registerForSaving(episode);
                }
                if (!TvShowUpgradeTasks.fixRatings(tvShow)) continue;
                this.registerForSaving(tvShow);
            }
            module.setDbVersion(5004);
        }
        if (module.getDbVersion() < 5005) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5005);
            for (TvShow tvShow : tvShowList.getTvShows()) {
                for (TvShowSeason season : tvShow.getSeasons()) {
                    for (int i = season.getMediaFiles().size() - 1; i >= 0; --i) {
                        mf = season.getMediaFiles().get(i);
                        if (!mf.isGraphic()) continue;
                        try {
                            String rel = Utils.relPath(tvShow.getPathNIO(), mf.getFileAsPath());
                            int nr = TvShowHelpers.detectSeasonFromFileAndFolder(mf.getFilename(), rel);
                            if (nr == season.getSeason()) continue;
                            LOGGER.debug("{}: Removing {} from season {}, because it was season {}", new Object[]{tvShow.getTitle(), mf.getType(), season.getSeason(), nr});
                            season.removeFromMediaFiles(mf);
                            this.registerForSaving(season);
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Could not upgrade 5005: {} / {}", (Object)tvShow.getPathNIO(), (Object)mf.getFileAsPath());
                        }
                    }
                }
            }
            module.setDbVersion(5005);
        }
        if (module.getDbVersion() < 5006) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5006);
            for (TvShow tvShow : tvShowList.getTvShows()) {
                boolean changed = false;
                String showDirName = tvShow.getPathNIO().getFileName().toString();
                for (TvShowSeason season : tvShow.getSeasons()) {
                    for (MediaFile mf4 : season.getMediaFiles()) {
                        if (mf4.getFileAsPath().startsWith(tvShow.getPathNIO())) continue;
                        LOGGER.info("5006: fixing wrong MediaFile {} / {}", (Object)tvShow.getPathNIO(), (Object)mf4.getFileAsPath());
                        try {
                            Path mfFolder = mf4.getFileAsPath().getParent();
                            if (mfFolder.getFileName().toString().equals(showDirName)) {
                                mf4.setFile(tvShow.getPathNIO().resolve(mf4.getFilename()));
                                changed = true;
                                continue;
                            }
                            if (!mfFolder.getParent().getFileName().toString().equals(showDirName)) continue;
                            Path newP = mf4.getFileAsPath().getParent().getFileName().resolve(mf4.getFileAsPath().getFileName());
                            mf4.setFile(tvShow.getPathNIO().resolve(newP));
                            changed = true;
                        }
                        catch (Exception e) {
                            LOGGER.warn("5006: Whoa, we had some error correcting the paths: {}", (Throwable)e);
                        }
                    }
                }
                if (!changed) continue;
                tvShow.saveToDb();
            }
            module.setDbVersion(5006);
        }
        if (module.getDbVersion() < 5007) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5007);
            for (TvShow tvShow : tvShowList.getTvShows()) {
                for (TvShowEpisode episode : tvShow.getEpisodes()) {
                    if (!TvShowUpgradeTasks.fixRatings(episode)) continue;
                    this.registerForSaving(episode);
                }
                if (!TvShowUpgradeTasks.fixRatings(tvShow)) continue;
                this.registerForSaving(tvShow);
            }
            module.setDbVersion(5007);
        }
        if (module.getDbVersion() < 5008) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5008);
            for (TvShow tvShow : tvShowList.getTvShows()) {
                for (TvShowEpisode episode : tvShow.getEpisodes()) {
                    if (!TvShowUpgradeTasks.fixHDR(episode)) continue;
                    this.registerForSaving(episode);
                }
                if (!TvShowUpgradeTasks.fixHDR(tvShow)) continue;
                this.registerForSaving(tvShow);
            }
            module.setDbVersion(5008);
        }
        if (module.getDbVersion() < 5009) {
            for (TvShow tvShow : tvShowList.getTvShows()) {
                boolean changed = this.migrateIds(tvShow);
                for (TvShowEpisode episode : tvShow.getDummyEpisodes()) {
                    changed |= this.migrateIds(episode);
                }
                if (changed) {
                    this.registerForSaving(tvShow);
                }
                for (TvShowEpisode episode : tvShow.getEpisodes()) {
                    changed = this.migrateIds(episode);
                    if (!changed) continue;
                    this.registerForSaving(episode);
                }
            }
            module.setDbVersion(5009);
        }
        this.saveAll();
    }

    @Override
    protected void saveAll() {
        for (MediaEntity mediaEntity : this.entitiesToSave) {
            if (mediaEntity instanceof TvShow) {
                TvShow tvShow = (TvShow)mediaEntity;
                TvShowModuleManager.getInstance().persistTvShow(tvShow);
                continue;
            }
            if (mediaEntity instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)mediaEntity;
                TvShowModuleManager.getInstance().persistSeason(season);
                continue;
            }
            if (!(mediaEntity instanceof TvShowEpisode)) continue;
            TvShowEpisode episode = (TvShowEpisode)mediaEntity;
            TvShowModuleManager.getInstance().persistEpisode(episode);
        }
    }
}

