/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class TvShowSeasonNfoParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowSeasonNfoParser.class);
    private static final List<String> IGNORE = Arrays.asList("epbookmark", "resume");
    private Element root;
    private final List<String> supportedElements = new ArrayList<String>();
    public int season = -1;
    public String title = "";
    public String sortTitle = "";
    public String plot = "";
    public String userNote = "";
    public List<String> posters = new ArrayList<String>();
    public List<String> banners = new ArrayList<String>();
    public List<String> thumbs = new ArrayList<String>();
    public List<String> fanarts = new ArrayList<String>();
    public List<String> unsupportedElements = new ArrayList<String>();

    private TvShowSeasonNfoParser(Document document) {
        Elements elements = document.select("season");
        if (elements.isEmpty()) {
            return;
        }
        document.outputSettings().prettyPrint(false);
        this.root = (Element)elements.get(0);
        this.parseTag(TvShowSeasonNfoParser::parseSeasonNumber);
        this.parseTag(TvShowSeasonNfoParser::parseTitle);
        this.parseTag(TvShowSeasonNfoParser::parseSortTitle);
        this.parseTag(TvShowSeasonNfoParser::parsePlot);
        this.parseTag(TvShowSeasonNfoParser::parsePosters);
        this.parseTag(TvShowSeasonNfoParser::parseBanners);
        this.parseTag(TvShowSeasonNfoParser::parseThumbs);
        this.parseTag(TvShowSeasonNfoParser::parseFanarts);
        this.parseTag(TvShowSeasonNfoParser::parseUserNote);
        this.parseTag(TvShowSeasonNfoParser::findUnsupportedElements);
    }

    private Void parseTag(Function<TvShowSeasonNfoParser, Void> function) {
        try {
            function.apply(this);
        }
        catch (Exception e) {
            LOGGER.warn("problem parsing tag (line {}): {}", (Object)e.getStackTrace()[0].getLineNumber(), (Object)e.getMessage());
        }
        return null;
    }

    public static TvShowSeasonNfoParser parseNfo(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            TvShowSeasonNfoParser tvShowSeasonNfoParser = new TvShowSeasonNfoParser(Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser()));
            return tvShowSeasonNfoParser;
        }
    }

    public static TvShowSeasonNfoParser parseNfo(String content) {
        return new TvShowSeasonNfoParser(Jsoup.parse((String)content, (String)"", (Parser)Parser.xmlParser()));
    }

    public boolean isValidNfo() {
        return this.season > -1;
    }

    private Element getSingleElement(Element parent, String tag) {
        Elements elements = parent.select(parent.tagName() + " > " + tag);
        if (elements.size() != 1) {
            return null;
        }
        return (Element)elements.get(0);
    }

    private Void parseSeasonNumber() {
        this.supportedElements.add("seasonnumber");
        Element element = this.getSingleElement(this.root, "seasonnumber");
        if (element != null) {
            this.season = MetadataUtil.parseInt(element.text(), -1);
        }
        return null;
    }

    private Void parseTitle() {
        this.supportedElements.add("title");
        Element element = this.getSingleElement(this.root, "title");
        if (element != null) {
            this.title = element.ownText();
        }
        return null;
    }

    private Void parseSortTitle() {
        this.supportedElements.add("sorttitle");
        Element element = this.getSingleElement(this.root, "sorttitle");
        if (element != null) {
            this.sortTitle = element.ownText();
        }
        return null;
    }

    private Void parsePlot() {
        this.supportedElements.add("plot");
        Element element = this.getSingleElement(this.root, "plot");
        if (element != null) {
            this.plot = element.wholeText();
        }
        return null;
    }

    private Void parsePosters() {
        this.supportedElements.add("thumb");
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                String posterUrl;
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("poster") || StringUtils.isBlank((CharSequence)(posterUrl = element.ownText())) || !posterUrl.matches("https?://.*") || this.posters.contains(posterUrl)) continue;
                this.posters.add(posterUrl);
            }
        }
        return null;
    }

    private Void parseBanners() {
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("banner") || !StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                this.banners.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseThumbs() {
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        if (!thumb.isEmpty()) {
            for (Element element : thumb) {
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("landscape") || !StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                this.thumbs.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseFanarts() {
        this.supportedElements.add("fanart");
        Element fanart = this.getSingleElement(this.root, "fanart");
        if (fanart != null) {
            String prefix = fanart.attr("url");
            Elements thumb = fanart.select(fanart.tagName() + " > thumb");
            if (!thumb.isEmpty()) {
                for (Element element : thumb) {
                    if (StringUtils.isNotBlank((CharSequence)element.ownText()) && element.ownText().matches("https?://.*")) {
                        this.fanarts.add(element.ownText());
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)element.ownText()) || !prefix.matches("https?://.*")) continue;
                    this.fanarts.add(prefix + element.ownText());
                }
            } else if (StringUtils.isNotBlank((CharSequence)fanart.ownText()) && fanart.ownText().matches("https?://.*")) {
                this.fanarts.add(fanart.ownText());
            } else if (StringUtils.isNotBlank((CharSequence)fanart.ownText()) && prefix.matches("https?://.*")) {
                this.fanarts.add(prefix + fanart.ownText());
            }
        }
        return null;
    }

    private Void parseUserNote() {
        this.supportedElements.add("user_note");
        Element element = this.getSingleElement(this.root, "user_note");
        if (element != null) {
            this.userNote = element.ownText();
        }
        return null;
    }

    private Void findUnsupportedElements() {
        this.supportedElements.add("lockdata");
        this.supportedElements.add("uniqueid");
        this.supportedElements.add("tvdbid");
        this.supportedElements.add("imdbid");
        this.supportedElements.add("tmdbid");
        this.supportedElements.add("year");
        this.supportedElements.add("showtitle");
        this.supportedElements.add("premiered");
        for (Element element : this.root.children()) {
            if (IGNORE.contains(element.tagName()) || this.supportedElements.contains(element.tagName())) continue;
            String elementText = element.toString().replaceAll(">\\r?\\n\\s*<", "><");
            this.unsupportedElements.add(elementText);
        }
        return null;
    }

    public TvShowSeason toTvShowSeason() {
        TvShowSeason showSeason = new TvShowSeason(this.season);
        showSeason.setTitle(this.title);
        showSeason.setPlot(this.plot);
        showSeason.setNote(this.userNote);
        if (!this.posters.isEmpty()) {
            showSeason.setArtworkUrl(this.posters.get(0), MediaFileType.POSTER);
        }
        if (!this.banners.isEmpty()) {
            showSeason.setArtworkUrl(this.banners.get(0), MediaFileType.BANNER);
        }
        if (!this.thumbs.isEmpty()) {
            showSeason.setArtworkUrl(this.thumbs.get(0), MediaFileType.THUMB);
        }
        if (!this.fanarts.isEmpty()) {
            showSeason.setArtworkUrl(this.fanarts.get(0), MediaFileType.FANART);
        }
        return showSeason;
    }

    private org.tinymediamanager.core.entities.Person morphPerson(Person.Type type, Person nfoPerson) {
        int tvdbId;
        org.tinymediamanager.core.entities.Person person = new org.tinymediamanager.core.entities.Person(type);
        person.setName(nfoPerson.name);
        person.setRole(nfoPerson.role);
        person.setThumbUrl(nfoPerson.thumb);
        person.setProfileUrl(nfoPerson.profile);
        int tmdbId = MetadataUtil.parseInt(nfoPerson.tmdbId, 0);
        if (tmdbId > 0) {
            person.setId("tmdb", tmdbId);
        }
        if (StringUtils.isNotBlank((CharSequence)nfoPerson.imdbId)) {
            person.setId("imdb", nfoPerson.imdbId);
        }
        if ((tvdbId = MetadataUtil.parseInt(nfoPerson.tvdbId, 0)) > 0) {
            person.setId("tvdb", tvdbId);
        }
        return person;
    }

    public static class Person {
        String name = "";
        String role = "";
        String thumb = "";
        String profile = "";
        String tmdbId = "";
        String imdbId = "";
        String tvdbId = "";
    }

    static class Rating {
        static final String DEFAULT = "default";
        static final String USER = "user";
        String id = "";
        float rating = 0.0f;
        int votes = 0;
        int maxValue = 10;

        Rating() {
        }
    }
}

