/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.TvShowToKodiConnector;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.w3c.dom.Element;

public class TvShowToJellyfinConnector
extends TvShowToKodiConnector {
    public TvShowToJellyfinConnector(TvShow tvShow) {
        super(tvShow);
    }

    @Override
    protected void addOwnTags() {
        super.addOwnTags();
        this.addEnddate();
    }

    protected void addEnddate() {
        if (!TvShowModuleManager.getInstance().getSettings().isNfoWriteDateEnded() || this.tvShow.getStatus() != MediaAiredStatus.ENDED) {
            return;
        }
        Date latestAiredDate = null;
        for (TvShowEpisode episode : this.tvShow.getEpisodes()) {
            if (episode.getFirstAired() == null || latestAiredDate != null && !latestAiredDate.before(episode.getFirstAired())) continue;
            latestAiredDate = episode.getFirstAired();
        }
        for (TvShowEpisode episode : this.tvShow.getDummyEpisodes()) {
            if (episode.getFirstAired() == null || latestAiredDate != null && !latestAiredDate.before(episode.getFirstAired())) continue;
            latestAiredDate = episode.getFirstAired();
        }
        if (latestAiredDate != null) {
            Element enddate = this.document.createElement("enddate");
            enddate.setTextContent(new SimpleDateFormat("yyyy-MM-dd").format(latestAiredDate));
            this.root.appendChild(enddate);
        }
    }

    @Override
    protected void addThumb() {
    }

    @Override
    protected void addFanart() {
    }

    @Override
    protected void addSeasonPoster() {
    }

    @Override
    protected void addSeasonThumb() {
    }

    @Override
    protected void addActor(Person tvShowActor) {
        Element profile;
        Element actor = this.document.createElement("actor");
        Element name = this.document.createElement("name");
        name.setTextContent(tvShowActor.getName());
        actor.appendChild(name);
        if (StringUtils.isNotBlank((CharSequence)tvShowActor.getRole())) {
            Element role = this.document.createElement("role");
            role.setTextContent(tvShowActor.getRole());
            actor.appendChild(role);
        }
        if (StringUtils.isNotBlank((CharSequence)tvShowActor.getProfileUrl())) {
            profile = this.document.createElement("profile");
            profile.setTextContent(tvShowActor.getProfileUrl());
            actor.appendChild(profile);
        }
        if (tvShowActor.getType() == Person.Type.GUEST) {
            profile = this.document.createElement("type");
            profile.setTextContent("GuestStar");
            actor.appendChild(profile);
        }
        this.addPersonIdsAsChildren(actor, tvShowActor);
        this.root.appendChild(actor);
    }
}

