/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.TvShowGenericXmlConnector;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.w3c.dom.Element;

public class TvShowToKodiConnector
extends TvShowGenericXmlConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowToKodiConnector.class);
    private static final Pattern HD_TRAILERS_PATTERN = Pattern.compile("https?://.*(apple.com|yahoo-redir|yahoo.com|youtube.com|moviefone.com|ign.com|hd-trailers.net|aol.com).*");

    public TvShowToKodiConnector(TvShow tvShow) {
        super(tvShow);
    }

    @Override
    protected void addRating() {
        Element ratings = this.document.createElement("ratings");
        MediaRating mainMediaRating = this.tvShow.getRating();
        if (mainMediaRating == MediaMetadata.EMPTY_RATING) {
            mainMediaRating = this.tvShow.getRating("tvdb");
            if (mainMediaRating == MediaMetadata.EMPTY_RATING) {
                mainMediaRating = this.tvShow.getRating("tmdb");
            }
            if (mainMediaRating == MediaMetadata.EMPTY_RATING) {
                mainMediaRating = this.tvShow.getRating("imdb");
            }
        }
        for (MediaRating r : this.tvShow.getRatings().values()) {
            if ("user".equals(r.getId())) continue;
            Element rating = this.document.createElement("rating");
            if ("tmdb".equals(r.getId())) {
                rating.setAttribute("name", "themoviedb");
            } else {
                rating.setAttribute("name", r.getId());
            }
            rating.setAttribute("max", String.valueOf(r.getMaxValue()));
            rating.setAttribute("default", r == mainMediaRating ? "true" : "false");
            Element value = this.document.createElement("value");
            value.setTextContent(String.format(Locale.US, "%.1f", Float.valueOf(r.getRating())));
            rating.appendChild(value);
            Element votes = this.document.createElement("votes");
            votes.setTextContent(Integer.toString(r.getVotes()));
            rating.appendChild(votes);
            ratings.appendChild(rating);
        }
        this.root.appendChild(ratings);
    }

    @Override
    protected void addVotes() {
    }

    @Override
    protected void addActors() {
        if (TvShowModuleManager.getInstance().getSettings().isNfoWriteAllActors()) {
            LinkedHashMap<String, Person> actors = new LinkedHashMap<String, Person>();
            for (Person person : this.tvShow.getActors()) {
                if (!StringUtils.isNotBlank((CharSequence)person.getName())) continue;
                actors.putIfAbsent(person.getName(), person);
            }
            for (TvShowEpisode episode : this.tvShow.getEpisodes()) {
                for (Person guest : episode.getActors()) {
                    if (!StringUtils.isNotBlank((CharSequence)guest.getName())) continue;
                    actors.putIfAbsent(guest.getName(), guest);
                }
            }
            for (Person additionalActor : actors.values()) {
                this.addActor(additionalActor);
            }
        } else {
            super.addActors();
        }
    }

    @Override
    protected void addOwnTags() {
        this.addTop250();
    }

    protected void addTop250() {
        Element top250 = this.document.createElement("top250");
        top250.setTextContent(Integer.toString(this.tvShow.getTop250()));
        Element set = this.getSingleElementByTag("ratings");
        this.root.insertBefore(top250, set);
    }

    @Override
    protected void addTrailer() {
        if (TvShowModuleManager.getInstance().getSettings().isNfoWriteTrailer()) {
            Element trailer = this.document.createElement("trailer");
            for (MediaTrailer mediaTrailer : new ArrayList<MediaTrailer>(this.tvShow.getTrailer())) {
                if (!mediaTrailer.getInNfo().booleanValue()) continue;
                if (mediaTrailer.getUrl().startsWith("http")) {
                    trailer.setTextContent(this.prepareTrailerForKodi(mediaTrailer));
                    break;
                }
                trailer.setTextContent(mediaTrailer.getUrl());
                break;
            }
            this.root.appendChild(trailer);
        }
    }

    protected String prepareTrailerForKodi(MediaTrailer trailer) {
        Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(trailer.getUrl());
        if (matcher.matches()) {
            return "plugin://plugin.video.youtube/play/?video_id=" + matcher.group(5);
        }
        matcher = HD_TRAILERS_PATTERN.matcher(trailer.getUrl());
        if (matcher.matches()) {
            try {
                return "plugin://plugin.video.hdtrailers_net/video/" + matcher.group(1) + "/" + URLEncoder.encode(trailer.getUrl(), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                LOGGER.debug("failed to escape {} - {}", (Object)trailer.getUrl(), (Object)e.getMessage());
            }
        }
        return trailer.getUrl();
    }
}

