/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.scraper.http.Url;

public class TvShowThemeDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowThemeDownloadTask.class);
    private final List<TvShow> tvShows = new ArrayList<TvShow>();
    private final boolean overwrite;

    public TvShowThemeDownloadTask(List<TvShow> tvShows, boolean overwrite) {
        super(TmmResourceBundle.getString("theme.download"));
        this.tvShows.addAll(tvShows);
        this.overwrite = overwrite;
    }

    @Override
    protected void doInBackground() {
        this.initThreadPool(3, "themeDownload");
        this.start();
        for (TvShow tvShow : this.tvShows) {
            this.submitTask(new Worker(tvShow, this.overwrite));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done downloading themes");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private static class Worker
    implements Runnable {
        private final TvShow tvShow;
        private final boolean overwrite;

        Worker(TvShow tvShow, boolean overwrite) {
            this.tvShow = tvShow;
            this.overwrite = overwrite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block27: {
                    block25: {
                        if (!this.overwrite && !this.tvShow.getMediaFiles(new MediaFileType[]{MediaFileType.THEME}).isEmpty()) {
                            return;
                        }
                        tvdbId = this.tvShow.getIdAsInt("tvdb");
                        if (tvdbId <= 0) return;
                        TvShowThemeDownloadTask.LOGGER.debug("found tvdbId '{}' - try to download the theme for it", (Object)tvdbId);
                        filename = "theme.mp3";
                        destFile = this.tvShow.getPathNIO().resolve(filename);
                        tempFile = null;
                        try {
                            block26: {
                                uuid = UUID.randomUUID().toString();
                                try {
                                    tempFolder = Paths.get(Utils.getTempFolder(), new String[0]);
                                    if (!Files.exists(tempFolder, new LinkOption[0])) {
                                        Files.createDirectory(tempFolder, new FileAttribute[0]);
                                    }
                                    tempFile = tempFolder.resolve("theme." + tvdbId + "." + uuid + ".part");
                                }
                                catch (Exception e) {
                                    TvShowThemeDownloadTask.LOGGER.debug("could not write to temp folder: {}", (Object)e.getMessage());
                                    tempFile = destFile.resolveSibling("theme." + tvdbId + "." + uuid + ".part");
                                }
                                urlAsString = "http://tvthemes.plexapp.com/" + tvdbId + ".mp3";
                                try {
                                    url = new Url(urlAsString);
                                }
                                catch (Exception e) {
                                    TvShowThemeDownloadTask.LOGGER.error("url is invalid {} - {}", (Object)urlAsString, (Object)e.getMessage());
                                    throw e;
                                }
                                is = url.getInputStreamWithRetry(5);
                                outputStream = new FileOutputStream(tempFile.toFile());
                                if (is != null) break block25;
                                outputStream.close();
                                if (is == null) break block26;
                                is.close();
                            }
                            if (tempFile == null) return;
                        }
                        catch (Throwable var12_17) {
                            if (tempFile == null) throw var12_17;
                            if (Files.exists(tempFile, new LinkOption[0]) == false) throw var12_17;
                            Utils.deleteFileSafely(tempFile);
                            throw var12_17;
                        }
                        if (Files.exists(tempFile, new LinkOption[0]) == false) return;
                        Utils.deleteFileSafely(tempFile);
                        return;
                    }
                    ** try [egrp 8[TRYBLOCK] [3 : 288->301)] { 
lbl58:
                    // 1 sources

                    break block27;
lbl59:
                    // 1 sources

                    finally {
                        outputStream.close();
                    }
                }
                IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                Utils.flushFileOutputStreamToDisk(outputStream);
                if (Files.exists(tempFile, new LinkOption[0]) && Files.size(tempFile) != 0L) ** GOTO lbl-1000
                FileUtils.deleteQuietly((File)tempFile.toFile());
                if (tempFile == null) return;
                if (Files.exists(tempFile, new LinkOption[0]) == false) return;
                Utils.deleteFileSafely(tempFile);
                return;
lbl-1000:
                // 1 sources

                {
                    Utils.deleteFileSafely(destFile);
                    if (!Utils.moveFileSafe(tempFile, destFile)) {
                        throw new IOException("renaming temp file failed: " + filename);
                    }
                    mediaFile = new MediaFile(destFile);
                    mediaFile.gatherMediaInformation();
                    this.tvShow.addToMediaFiles(mediaFile);
                    this.tvShow.saveToDb();
                    if (tempFile == null) return;
                }
                if (Files.exists(tempFile, new LinkOption[0]) == false) return;
                Utils.deleteFileSafely(tempFile);
                return;
            }
            catch (Exception e) {
                TvShowThemeDownloadTask.LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"ThemeDownloader", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

