/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.fanarttv;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.fanarttv.FanartTvMetadataProvider;
import org.tinymediamanager.scraper.fanarttv.entities.Images;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import retrofit2.Response;

public class FanartTvTvShowArtworkProvider
extends FanartTvMetadataProvider
implements ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FanartTvTvShowArtworkProvider.class);

    @Override
    protected String getSubId() {
        return "tvshow_artwork";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        if (options.getMediaType() != MediaType.TV_SHOW) {
            return Collections.emptyList();
        }
        LOGGER.debug("getArtwork() - {}", (Object)options);
        this.initAPI();
        MediaArtwork.MediaArtworkType artworkType = options.getArtworkType();
        List<MediaArtwork> returnArtwork = new ArrayList<MediaArtwork>();
        int tvdbId = options.getIdAsInt("tvdb");
        if (tvdbId == 0) {
            tvdbId = options.getIdAsInt("tvdb");
        }
        if (tvdbId == 0) {
            return Collections.emptyList();
        }
        Response images = null;
        try {
            LOGGER.debug("getArtwork with TVDB id: {}", (Object)tvdbId);
            images = this.api.getTvShowService().getTvShowImages(tvdbId).execute();
        }
        catch (Exception e) {
            LOGGER.debug("failed to get artwork: {}", (Object)e.getMessage());
            if (e instanceof InterruptedException || e instanceof InterruptedIOException) {
                return returnArtwork;
            }
            throw new ScrapeException(e);
        }
        if (images == null) {
            LOGGER.info("got no result");
            return returnArtwork;
        }
        if (!images.isSuccessful()) {
            String message = "";
            try {
                message = images.errorBody().string();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.warn("request was not successful: HTTP/{} - {}", (Object)images.code(), (Object)message);
            return returnArtwork;
        }
        returnArtwork = this.getArtwork((Images)images.body(), artworkType);
        MediaMetadata md = options.getMetadata();
        if (md != null && !returnArtwork.isEmpty()) {
            md.addMediaArt(returnArtwork);
        }
        return returnArtwork;
    }
}

