/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbTvShowParser;
import org.tinymediamanager.scraper.interfaces.ITvShowTrailerProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public class ImdbTvShowTrailerProvider
extends ImdbMetadataProvider
implements ITvShowTrailerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbTvShowTrailerProvider.class);

    @Override
    protected String getSubId() {
        return "tvshow_trailer";
    }

    @Override
    public List<MediaTrailer> getTrailers(TrailerSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getTrailers(): {}", (Object)options);
        if (options.getMediaType() != MediaType.TV_SHOW && options.getMediaType() != MediaType.TV_EPISODE) {
            return Collections.emptyList();
        }
        String imdbId = "";
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MediaIdUtil.isValidImdbId(imdbId) && options.getTmdbId() > 0) {
            imdbId = MediaIdUtil.getTvShowImdbIdViaTmdbId(options.getTmdbId());
        }
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            LOGGER.warn("not possible to scrape from IMDB - no imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        LOGGER.debug("getTrailers(): {}", (Object)options);
        MovieSearchAndScrapeOptions mso = new MovieSearchAndScrapeOptions();
        mso.setImdbId(options.getImdbId());
        MediaMetadata md = new ImdbTvShowParser(this, EXECUTOR).getMetadata(mso);
        return md.getTrailers();
    }

    public String getUrlForId(MediaTrailer trailer) {
        try {
            return new ImdbTvShowParser(this, EXECUTOR).getFreshUrlForTrailer(trailer, TvShowModuleManager.getInstance().getSettings().getScraperLanguage().getLanguage(), TvShowModuleManager.getInstance().getSettings().getCertificationCountry().getAlpha2());
        }
        catch (Exception e) {
            LOGGER.warn("Could not fetch video: {}", (Object)e.getMessage());
            return "";
        }
    }
}

