/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.mdblist;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.IRatingProvider;
import org.tinymediamanager.scraper.mdblist.MdbListController;
import org.tinymediamanager.scraper.mdblist.entities.MdbMediaEntity;
import org.tinymediamanager.scraper.mdblist.entities.MdbRating;
import retrofit2.Response;

public class MdbListMetadataProvider
implements IMediaProvider,
IRatingProvider {
    public static final String ID = "mdblist";
    private static final Logger LOGGER = LoggerFactory.getLogger(MdbListMetadataProvider.class);
    protected final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    protected MdbListController controller;

    protected MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, "", "mdblist.com", "MDBLIst - The Ultimate Dynamic List Manager<br><br>mdblist.com is your go-to tool for creating dynamic, auto-updating movie and show lists tailored to your preferences. Seamlessly integrated with Stremio, it combines the power of multiple rating platforms like IMDb, TMDb, Letterboxd, Rotten Tomatoes, Metacritic, MyAnimeList, and RogerEbert. Whether you\u2019re building a watchlist, tracking ratings, or syncing your library progress, mdblist.com makes it effortless.", MdbListMetadataProvider.class.getResource("/org/tinymediamanager/scraper/mdblist.png"));
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(Settings.getInstance().getMdbListApiKey());
    }

    protected synchronized void initAPI() throws ScrapeException {
        if (this.controller == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            try {
                this.controller = new MdbListController();
                String apiKey = Settings.getInstance().getMdbListApiKey();
                if (apiKey.isBlank()) {
                    throw new ScrapeException("apiKey missing - skipping");
                }
                this.controller.setApiKey(apiKey);
            }
            catch (Exception e) {
                LOGGER.error("could not initialize the API: {}", (Object)e.getMessage());
                this.controller = null;
                throw new ScrapeException(e);
            }
        }
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public List<MediaRating> getRatings(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        this.initAPI();
        ArrayList<MediaRating> mediaRatingList = new ArrayList<MediaRating>();
        if (mediaType == MediaType.TV_EPISODE) {
            return mediaRatingList;
        }
        Response response = null;
        for (Map.Entry<String, Object> entry : ids.entrySet()) {
            try {
                response = this.controller.getMediaEntity(entry.getKey(), mediaType, entry.getValue().toString()).execute();
                if (response.isSuccessful()) break;
                String message = "";
                try {
                    message = response.errorBody().string();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LOGGER.debug("request was not successful: HTTP/{} - {}", (Object)response.code(), (Object)message);
            }
            catch (Exception e) {
                LOGGER.debug("request was not successful : '{}'", (Object)e.getMessage());
            }
        }
        if (response == null || response.body() == null) {
            throw new NothingFoundException();
        }
        List<MdbRating> ratings = ((MdbMediaEntity)response.body()).ratings;
        for (MdbRating rating : ratings) {
            if (rating.source == null || rating.value == 0.0f && !rating.source.equals("rogerebert")) continue;
            MediaRating mediaRating = new MediaRating(rating.source, rating.value, rating.votes);
            switch (rating.source) {
                case "letterboxd": {
                    mediaRating.setMaxValue(5);
                    break;
                }
                case "rogerebert": {
                    mediaRating.setMaxValue(4);
                }
            }
            mediaRatingList.add(mediaRating);
        }
        return mediaRatingList;
    }
}

