/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.rating;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.IRatingProvider;
import org.tinymediamanager.scraper.mdblist.MdbListMetadataProvider;
import org.tinymediamanager.scraper.rating.ImdbRating;
import org.tinymediamanager.scraper.rating.WikidataRating;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public class RatingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RatingProvider.class);

    private RatingProvider() {
        throw new IllegalAccessError();
    }

    public static MediaRating getImdbRating(String imdbId) {
        List<MediaRating> ratings = RatingProvider.getRatings(Collections.singletonMap("imdb", imdbId), Collections.singletonList(RatingSource.IMDB), null);
        if (!ratings.isEmpty()) {
            return ratings.get(0);
        }
        return null;
    }

    public static List<MediaRating> getRatings(Map<String, Object> ids, MediaType mediaType) {
        return RatingProvider.getRatings(ids, Arrays.asList(RatingSource.values()), mediaType);
    }

    public static List<MediaRating> getRatings(Map<String, Object> ids, List<RatingSource> sources, MediaType mediaType) {
        MediaRating rating;
        ArrayList<MediaRating> ratings = new ArrayList<MediaRating>();
        ArrayList<RatingSource> missingRatings = new ArrayList<RatingSource>(sources);
        String imdbId = MediaIdUtil.getIdAsString(ids, "imdb");
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            MediaIdUtil.injectMissingIds(ids, mediaType);
        }
        if (missingRatings.contains((Object)RatingSource.IMDB) && MediaIdUtil.isValidImdbId(imdbId) && (rating = new ImdbRating().getImdbRating(imdbId)) != null) {
            ratings.add(rating);
            missingRatings.remove((Object)RatingSource.IMDB);
        }
        if (missingRatings.contains((Object)RatingSource.TMDB)) {
            RatingProvider.callScraper("tmdb", mediaType, missingRatings, ids, ratings);
        }
        if (missingRatings.contains((Object)RatingSource.TRAKT_TV)) {
            RatingProvider.callScraper("trakt", mediaType, missingRatings, ids, ratings);
        }
        if (ListUtils.containsAny(missingRatings, RatingSource.METACRITIC, RatingSource.ROTTEN_TOMATOES_AVG_RATING, RatingSource.ROTTEN_TOMATOES_AVG_RATING, RatingSource.LETTERBOXD, RatingSource.MAL, RatingSource.ROGER_EBERT)) {
            try {
                MdbListMetadataProvider mdbListMetadataProvider = new MdbListMetadataProvider();
                if (mdbListMetadataProvider.isActive()) {
                    List<MediaRating> ratingsFromMdblist = mdbListMetadataProvider.getRatings(ids, mediaType);
                    for (MediaRating rating2 : ratingsFromMdblist) {
                        RatingSource source = RatingProvider.parseRatingSource(rating2.getId());
                        if (!missingRatings.contains((Object)source) || ratings.contains(rating2)) continue;
                        ratings.add(rating2);
                        missingRatings.remove((Object)source);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not get mbdlist ratings - '{}'", (Object)e.getMessage());
            }
        }
        if (missingRatings.contains((Object)RatingSource.METACRITIC)) {
            RatingProvider.callScraper("imdb", mediaType, missingRatings, ids, ratings);
        }
        if (ListUtils.containsAny(missingRatings, RatingSource.ROTTEN_TOMATOES_AVG_RATING, RatingSource.ROTTEN_TOMATOES_AVG_RATING) && MediaIdUtil.isValidImdbId(imdbId)) {
            RatingProvider.callScraper("omdbapi", mediaType, missingRatings, ids, ratings);
        }
        if (ListUtils.containsAny(missingRatings, RatingSource.METACRITIC, RatingSource.ROTTEN_TOMATOES_AVG_RATING, RatingSource.ROTTEN_TOMATOES_AVG_RATING) && MediaIdUtil.isValidImdbId(imdbId)) {
            List<MediaRating> ratingsFromWikidata = new WikidataRating().getRatings(imdbId);
            for (MediaRating rating3 : ratingsFromWikidata) {
                RatingSource source = RatingProvider.parseRatingSource(rating3.getId());
                if (!missingRatings.contains((Object)source) || ratings.contains(rating3)) continue;
                ratings.add(rating3);
                missingRatings.remove((Object)source);
            }
        }
        return ratings;
    }

    private static void callScraper(String scraperId, MediaType mediaType, List<RatingSource> sources, Map<String, Object> ids, List<MediaRating> ratings) {
        IMediaProvider iMediaProvider;
        MediaScraper scraper = MediaScraper.getMediaScraperById(scraperId, MediaType.getScraperTypeForMediaType(mediaType));
        if (scraper != null && (iMediaProvider = scraper.getMediaProvider()) instanceof IRatingProvider) {
            IRatingProvider ratingProvider = (IRatingProvider)((Object)iMediaProvider);
            if (scraper.isEnabled()) {
                try {
                    List<MediaRating> ratingsFromScraper = ratingProvider.getRatings(ids, mediaType);
                    for (MediaRating rating : ratingsFromScraper) {
                        RatingSource source = RatingProvider.parseRatingSource(rating.getId());
                        if (!sources.contains((Object)source) || ratings.contains(rating)) continue;
                        ratings.add(rating);
                        sources.remove((Object)source);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("could not get {} ratings - '{}'", (Object)scraperId, (Object)e.getMessage());
                }
            }
        }
    }

    public static synchronized void shutdown() {
        ImdbRating.shutdown();
    }

    public static RatingSource parseRatingSource(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return switch (id) {
            case "metacritic" -> RatingSource.METACRITIC;
            case "metacriticuser" -> RatingSource.METACRITIC_USER;
            case "imdb" -> RatingSource.IMDB;
            case "tmdb" -> RatingSource.TMDB;
            case "tomatometerallcritics" -> RatingSource.ROTTEN_TOMATOES_TOMATOMETER;
            case "tomatometeravgcritics" -> RatingSource.ROTTEN_TOMATOES_AVG_RATING;
            case "trakt" -> RatingSource.TRAKT_TV;
            case "letterboxd" -> RatingSource.LETTERBOXD;
            case "myanimelist" -> RatingSource.MAL;
            case "rogerebert" -> RatingSource.ROGER_EBERT;
            default -> null;
        };
    }

    public static String getRatingSourceId(@Nonnull RatingSource ratingSource) {
        return switch (ratingSource) {
            default -> throw new IncompatibleClassChangeError();
            case RatingSource.IMDB -> "imdb";
            case RatingSource.TMDB -> "tmdb";
            case RatingSource.METACRITIC -> "metacritic";
            case RatingSource.METACRITIC_USER -> "metacriticuser";
            case RatingSource.ROTTEN_TOMATOES_TOMATOMETER -> "tomatometerallcritics";
            case RatingSource.ROTTEN_TOMATOES_AVG_RATING -> "tomatometeravgcritics";
            case RatingSource.TRAKT_TV -> "trakt";
            case RatingSource.LETTERBOXD -> "letterboxd";
            case RatingSource.MAL -> "myanimelist";
            case RatingSource.ROGER_EBERT -> "rogerebert";
        };
    }

    public static enum RatingSource {
        IMDB("IMDb"),
        TMDB("TMDB"),
        METACRITIC("Metacritic Metascore"),
        METACRITIC_USER("Metacritic Userscore"),
        ROTTEN_TOMATOES_TOMATOMETER("Rotten Tomatoes - Tomatometer"),
        ROTTEN_TOMATOES_AVG_RATING("Rotten Tomatoes - Audience Score"),
        TRAKT_TV("Trakt.tv"),
        LETTERBOXD("Letterboxd"),
        MAL("MyAnimeList"),
        ROGER_EBERT("RogerEbert.com");

        private final String title;

        private RatingSource(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }

        public static List<RatingSource> getRatingSourcesForMovies() {
            return Arrays.asList(RatingSource.values());
        }

        public static List<RatingSource> getRatingSourcesForTvShows() {
            ArrayList<RatingSource> ratingSources = new ArrayList<RatingSource>();
            for (RatingSource ratingSource : RatingSource.values()) {
                if (ratingSource == METACRITIC || ratingSource == ROTTEN_TOMATOES_AVG_RATING || ratingSource == ROTTEN_TOMATOES_TOMATOMETER) continue;
                ratingSources.add(ratingSource);
            }
            return ratingSources;
        }
    }
}

