/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviders;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaIdProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;

public class MediaIdUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaIdUtil.class);

    private MediaIdUtil() {
        throw new IllegalAccessError();
    }

    public static String getImdbIdFromTvdbId(String tvdbId) {
        if (StringUtils.isBlank((CharSequence)tvdbId)) {
            return "";
        }
        String imdbId = "";
        try {
            MediaScraper scraper = MediaScraper.getMediaScraperById("tvdb", ScraperType.TV_SHOW);
            TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
            options.setId("tvdb", tvdbId);
            MediaMetadata md = ((ITvShowMetadataProvider)scraper.getMediaProvider()).getMetadata(options);
            imdbId = (String)md.getId("imdb");
        }
        catch (Exception e) {
            LOGGER.error("could not get imdb id from tvdb id: {}", (Object)e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            return "";
        }
        return imdbId;
    }

    public static String getMovieImdbIdViaTmdbId(int tmdbId) {
        if (tmdbId == 0) {
            return "";
        }
        try {
            IMovieMetadataProvider tmdb = MediaProviders.getProviderById("tmdb", IMovieMetadataProvider.class);
            if (tmdb == null) {
                return "";
            }
            MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
            options.setId("tmdb", Integer.toString(tmdbId));
            MediaMetadata md = tmdb.getMetadata(options);
            return md.getId("imdb").toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getTvShowImdbIdViaTmdbId(int tmdbId) {
        if (tmdbId == 0) {
            return "";
        }
        try {
            ITvShowMetadataProvider tmdb = MediaProviders.getProviderById("tmdb", ITvShowMetadataProvider.class);
            if (tmdb == null) {
                return "";
            }
            TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
            options.setId("tmdb", Integer.toString(tmdbId));
            MediaMetadata md = tmdb.getMetadata(options);
            return md.getId("imdb").toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void injectMissingIds(Map<String, Object> ids, MediaType mediaType) {
        if (mediaType == null) {
            return;
        }
        switch (mediaType) {
            case MOVIE: {
                MediaIdUtil.injectMovieIds(ids);
                break;
            }
            case TV_SHOW: {
                MediaIdUtil.injectTvShowIds(ids);
                break;
            }
            case TV_EPISODE: {
                MediaIdUtil.injectEpisodeIds(ids);
                break;
            }
        }
    }

    private static void injectMovieIds(Map<String, Object> ids) {
        List<String> missingIds = MediaIdUtil.getMissingMovieIds(ids);
        if (missingIds.isEmpty()) {
            return;
        }
        if (!missingIds.contains("imdb") || !missingIds.contains("tmdb")) {
            MediaIdUtil.callScraper("tmdb", MediaType.MOVIE, ids);
            missingIds = MediaIdUtil.getMissingMovieIds(ids);
            if (missingIds.isEmpty()) {
                return;
            }
        }
    }

    private static List<String> getMissingMovieIds(Map<String, Object> ids) {
        ArrayList<String> missingIds = new ArrayList<String>();
        if (!MediaIdUtil.isValidImdbId(MediaIdUtil.getIdAsString(ids, "imdb"))) {
            missingIds.add("imdb");
        }
        if (MediaIdUtil.getIdAsInt(ids, "tmdb") <= 0) {
            missingIds.add("tmdb");
        }
        return missingIds;
    }

    private static void injectTvShowIds(Map<String, Object> ids) {
        List<String> missingIds = MediaIdUtil.getMissingTvShowIds(ids);
        if (missingIds.isEmpty()) {
            return;
        }
        if (!missingIds.contains("imdb") || !missingIds.contains("tvdb")) {
            MediaIdUtil.callScraper("tvdb", MediaType.TV_SHOW, ids);
            missingIds = MediaIdUtil.getMissingTvShowIds(ids);
            if (missingIds.isEmpty()) {
                return;
            }
        }
        if (!missingIds.contains("imdb") || !missingIds.contains("tmdb")) {
            MediaIdUtil.callScraper("tmdb", MediaType.TV_SHOW, ids);
            missingIds = MediaIdUtil.getMissingTvShowIds(ids);
            if (missingIds.isEmpty()) {
                return;
            }
        }
    }

    private static List<String> getMissingTvShowIds(Map<String, Object> ids) {
        ArrayList<String> missingIds = new ArrayList<String>();
        if (!MediaIdUtil.isValidImdbId(MediaIdUtil.getIdAsString(ids, "imdb"))) {
            missingIds.add("imdb");
        }
        if (MediaIdUtil.getIdAsInt(ids, "tmdb") <= 0) {
            missingIds.add("tmdb");
        }
        if (MediaIdUtil.getIdAsInt(ids, "trakt") <= 0) {
            missingIds.add("trakt");
        }
        if (MediaIdUtil.getIdAsInt(ids, "tvdb") <= 0) {
            missingIds.add("tvdb");
        }
        return missingIds;
    }

    private static void injectEpisodeIds(Map<String, Object> ids) {
        HashMap<String, Object> showIds = new HashMap<String, Object>();
        try {
            showIds.putAll((Map)ids.get("tvShowIds"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (showIds.isEmpty()) {
            return;
        }
        List<String> missingTvShowIds = MediaIdUtil.getMissingTvShowIds(showIds);
        if (missingTvShowIds.contains("imdb")) {
            return;
        }
        List<String> missingEpisodeIds = MediaIdUtil.getMissingTvShowIds(ids);
        if (missingEpisodeIds.isEmpty()) {
            return;
        }
        if (!missingTvShowIds.contains("imdb") || !missingTvShowIds.contains("trakt")) {
            MediaIdUtil.callScraper("trakt", MediaType.TV_EPISODE, ids);
            missingEpisodeIds = MediaIdUtil.getMissingTvShowIds(ids);
            if (missingEpisodeIds.isEmpty()) {
                return;
            }
        }
    }

    private static void callScraper(String scraperId, MediaType mediaType, Map<String, Object> ids) {
        MediaScraper scraper = MediaScraper.getMediaScraperById(scraperId, MediaType.getScraperTypeForMediaType(mediaType));
        if (scraper != null && scraper.isEnabled() && scraper.getMediaProvider() instanceof IMediaIdProvider) {
            try {
                Map<String, Object> idsFromScraper = ((IMediaIdProvider)((Object)scraper.getMediaProvider())).getMediaIds(ids, mediaType);
                idsFromScraper.forEach(ids::putIfAbsent);
            }
            catch (ScrapeException idsFromScraper) {
            }
            catch (Exception e) {
                LOGGER.debug("could not get {} ratings - '{}'", (Object)scraperId, (Object)e.getMessage());
            }
        }
    }

    public static boolean isValidImdbId(String imdbId) {
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            return false;
        }
        return imdbId.matches("tt\\d{6,}");
    }

    public static String getIdAsString(Map<String, Object> ids, String key) {
        if (ids == null) {
            return "";
        }
        Object obj = ids.get(key);
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    public static int getIdAsInt(Map<String, Object> ids, String key) {
        return MediaIdUtil.getIdAsIntOrDefault(ids, key, 0);
    }

    public static int getIdAsIntOrDefault(Map<String, Object> ids, String key, int defaultValue) {
        if (ids == null) {
            return defaultValue;
        }
        Object obj = ids.get(key);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse int: {}", (Object)e.getMessage());
            }
        }
        return defaultValue;
    }
}

