/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class StrgUtils {
    private static final Map<Integer, Replacement> REPLACEMENTS = new HashMap<Integer, Replacement>(20);
    private static final String[] COMMON_TITLE_PREFIXES = StrgUtils.buildCommonTitlePrefixes();
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final byte[] DIGITS_LOWER = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final Pattern NORMALIZE_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final char[] CAP_DELIMS = new char[]{' ', '-', '_', '.', '\'', '(', '[', '*'};
    private static final String[] NON_CAP = new String[]{"'S", "'M", "'Ll", "'T", "'D", "'Ve", "'Re"};

    private static String[] buildCommonTitlePrefixes() {
        return new String[]{"A", "An", "The", "Der", "Die", "Das", "Ein", "Eine", "Eines", "Einer", "Einem", "Einen", "Le", "La", "Une", "Des", "El", "Los", "La", "Las", "Un", "Unos", "Una", "Unas"};
    }

    private StrgUtils() {
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String encodeHex(byte[] data) {
        int dataLength = data.length;
        int outLength = dataLength << 1;
        byte[] out = new byte[outLength];
        int j = 0;
        for (int i = 0; i < dataLength; ++i) {
            out[j++] = DIGITS_LOWER[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS_LOWER[0xF & data[i]];
        }
        return new String(out, 0, outLength, StandardCharsets.ISO_8859_1);
    }

    public static String encodeHex(int data) {
        byte[] out = new byte[]{DIGITS_LOWER[data >>> 28 & 0xF], DIGITS_LOWER[data >>> 24 & 0xF], DIGITS_LOWER[data >>> 20 & 0xF], DIGITS_LOWER[data >>> 16 & 0xF], DIGITS_LOWER[data >>> 12 & 0xF], DIGITS_LOWER[data >>> 8 & 0xF], DIGITS_LOWER[data >>> 4 & 0xF], DIGITS_LOWER[data >>> 0 & 0xF]};
        return new String(out, 0, 8, StandardCharsets.ISO_8859_1);
    }

    public static String encodeHex(long data) {
        byte[] out = new byte[]{DIGITS_LOWER[(int)(data >>> 60 & 0xFL)], DIGITS_LOWER[(int)(data >>> 56 & 0xFL)], DIGITS_LOWER[(int)(data >>> 52 & 0xFL)], DIGITS_LOWER[(int)(data >>> 48 & 0xFL)], DIGITS_LOWER[(int)(data >>> 44 & 0xFL)], DIGITS_LOWER[(int)(data >>> 40 & 0xFL)], DIGITS_LOWER[(int)(data >>> 36 & 0xFL)], DIGITS_LOWER[(int)(data >>> 32 & 0xFL)], DIGITS_LOWER[(int)(data >>> 28 & 0xFL)], DIGITS_LOWER[(int)(data >>> 24 & 0xFL)], DIGITS_LOWER[(int)(data >>> 20 & 0xFL)], DIGITS_LOWER[(int)(data >>> 16 & 0xFL)], DIGITS_LOWER[(int)(data >>> 12 & 0xFL)], DIGITS_LOWER[(int)(data >>> 8 & 0xFL)], DIGITS_LOWER[(int)(data >>> 4 & 0xFL)], DIGITS_LOWER[(int)(data >>> 0 & 0xFL)]};
        return new String(out, 0, 16, StandardCharsets.ISO_8859_1);
    }

    public static String removeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("<[^>]+>", "");
    }

    public static String unquote(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceFirst("^\\\"(.*)\\\"$", "$1");
    }

    public static String mapToString(Map map) {
        if (map == null) {
            return "null";
        }
        if (map.isEmpty()) {
            return "empty";
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry me = o = iterator.next();
            sb.append(me.getKey()).append(": ").append(me.getValue()).append(",");
        }
        return sb.toString();
    }

    public static String zeroPad(String encodeString, int padding) {
        if (StringUtils.isBlank((CharSequence)encodeString)) {
            return encodeString;
        }
        try {
            int v = Integer.parseInt(encodeString);
            String format = "%0" + padding + "d";
            return String.format(format, v);
        }
        catch (Exception e) {
            return encodeString;
        }
    }

    public static String substr(String str, String pattern) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        Pattern regex = Pattern.compile(pattern);
        Matcher m = regex.matcher(str);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static String removeDuplicateWhitespace(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int length = s.length();
        boolean isPreviousWhiteSpace = false;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            boolean thisCharWhiteSpace = Character.isWhitespace(c);
            if (!isPreviousWhiteSpace || !thisCharWhiteSpace) {
                result.append(c);
            }
            isPreviousWhiteSpace = thisCharWhiteSpace;
        }
        return result.toString();
    }

    public static String convertToAscii(String input, boolean replaceAllCapitalLetters) {
        String result = null;
        if (input != null) {
            String normalized = Normalizer.normalize(input, Normalizer.Form.NFKD);
            int len = normalized.length();
            result = StrgUtils.processSpecialChars(normalized.toCharArray(), 0, len, replaceAllCapitalLetters);
        }
        return result;
    }

    private static String processSpecialChars(char[] target, int offset, int len, boolean uppercase) {
        StringBuilder result = new StringBuilder();
        boolean skip = false;
        block5: for (int i = 0; i < len; ++i) {
            if (skip) {
                skip = false;
                continue;
            }
            char c = target[i];
            if (c > ' ' && c < '@' || c > 'z' && c < '\u00c0' || c > 'Z' && c < 'a' || c == '\u00d7' || c == '\u00f7') {
                result.append(c);
                continue;
            }
            if (Character.isDigit(c) || Character.isISOControl(c)) {
                result.append(c);
                continue;
            }
            if (Character.isWhitespace(c) || Character.isLetter(c)) {
                boolean isUpper = false;
                switch (c) {
                    case '\u00df': {
                        result.append("ss");
                        break;
                    }
                    case 'A': 
                    case 'O': 
                    case 'U': {
                        isUpper = true;
                    }
                    case 'a': 
                    case 'o': 
                    case 'u': {
                        result.append(c);
                        if (i + 1 >= target.length || target[i + 1] != '\u0308') continue block5;
                        result.append((char)(isUpper && uppercase ? 69 : 101));
                        skip = true;
                        break;
                    }
                    default: {
                        Replacement rep = REPLACEMENTS.get(c);
                        if (rep != null) {
                            result.append(uppercase ? rep.UPPER : rep.LOWER);
                            break;
                        }
                        result.append(c);
                        break;
                    }
                }
                continue;
            }
            Replacement rep = REPLACEMENTS.get(c);
            if (rep == null) continue;
            result.append(uppercase ? rep.UPPER : rep.LOWER);
        }
        return result.toString();
    }

    public static String removeCommonSortableName(String title) {
        if (title == null || title.isEmpty()) {
            return "";
        }
        for (String prfx : COMMON_TITLE_PREFIXES) {
            String delim = " ";
            if (prfx.matches(".*['`\u00b4]$")) {
                delim = "";
            }
            title = title.replaceAll("(?i)(.*), " + prfx, prfx + delim + "$1");
        }
        return title.strip();
    }

    public static int compareVersion(String v1, String v2) {
        if (v1.contains("-SNAPSHOT") && v1.equals(v2) || v1.equals("SVN") || v1.equals("GIT")) {
            return -1;
        }
        String s1 = StrgUtils.normalisedVersion(v1);
        String s2 = StrgUtils.normalisedVersion(v2);
        return s1.compareTo(s2);
    }

    private static String normalisedVersion(String version) {
        return StrgUtils.normalisedVersion(version, ".", 4);
    }

    private static String normalisedVersion(String version, String sep, int maxWidth) {
        version = !((String)version).contains("-SNAPSHOT") ? (String)version + ".0.0.1" : ((String)version).replace("-SNAPSHOT", "");
        String[] split = Pattern.compile(sep, 16).split((CharSequence)version);
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            sb.append(String.format("%" + maxWidth + "s", s));
        }
        return sb.toString();
    }

    public static String getLongestString(String[] array) {
        int maxLength = 0;
        String longestString = null;
        for (String s : array) {
            if (s.length() <= maxLength) continue;
            maxLength = s.length();
            longestString = s;
        }
        return longestString;
    }

    public static String getNonNullString(String originalString) {
        if (originalString == null) {
            return "";
        }
        return originalString;
    }

    public static String normalizeString(String original) {
        String nfdNormalizedString = Normalizer.normalize(original, Normalizer.Form.NFD);
        return StrgUtils.removeDuplicateWhitespace(NORMALIZE_PATTERN.matcher(nfdNormalizedString).replaceAll(""));
    }

    public static String[] convertStringToArray(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return new String[0];
        }
        return source.replace("[", "").replace("]", "").replaceAll("\\s", "").split(",");
    }

    public static String capitalize(String text) {
        String ret = WordUtils.capitalize((String)text, (char[])CAP_DELIMS);
        for (String n : NON_CAP) {
            ret = ret.replaceAll(n + " ", n.toLowerCase(Locale.ROOT) + " ");
            ret = ret.replaceAll(n + "$", n.toLowerCase(Locale.ROOT));
        }
        return ret;
    }

    static {
        REPLACEMENTS.put(198, new Replacement("AE", "Ae"));
        REPLACEMENTS.put(230, new Replacement("ae"));
        REPLACEMENTS.put(208, new Replacement("D"));
        REPLACEMENTS.put(273, new Replacement("d"));
        REPLACEMENTS.put(216, new Replacement("O"));
        REPLACEMENTS.put(248, new Replacement("o"));
        REPLACEMENTS.put(338, new Replacement("OE", "Oe"));
        REPLACEMENTS.put(339, new Replacement("oe"));
        REPLACEMENTS.put(358, new Replacement("T"));
        REPLACEMENTS.put(359, new Replacement("t"));
        REPLACEMENTS.put(321, new Replacement("L"));
        REPLACEMENTS.put(322, new Replacement("l"));
        REPLACEMENTS.put(8216, new Replacement("'"));
        REPLACEMENTS.put(8217, new Replacement("'"));
        REPLACEMENTS.put(8242, new Replacement("'"));
        REPLACEMENTS.put(700, new Replacement("'"));
        REPLACEMENTS.put(1523, new Replacement("'"));
        REPLACEMENTS.put(42892, new Replacement("'"));
        REPLACEMENTS.put(8220, new Replacement("\""));
        REPLACEMENTS.put(8221, new Replacement("\""));
        REPLACEMENTS.put(733, new Replacement("\""));
        REPLACEMENTS.put(1524, new Replacement("\""));
        REPLACEMENTS.put(8243, new Replacement("\""));
        REPLACEMENTS.put(12291, new Replacement("\""));
    }

    private static class Replacement {
        private final String UPPER;
        private final String LOWER;

        Replacement(String ucReplacement, String lcReplacement) {
            this.UPPER = ucReplacement;
            this.LOWER = lcReplacement;
        }

        Replacement(String caseInsensitiveReplacement) {
            this(caseInsensitiveReplacement, caseInsensitiveReplacement);
        }
    }
}

