/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.registry.Registry;
import org.fourthline.cling.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpnpListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpnpListener.class);

    private UpnpListener() {
        throw new IllegalAccessError();
    }

    public static RegistryListener getListener() {
        return new RegistryListener(){

            public void remoteDeviceDiscoveryStarted(Registry registry, RemoteDevice device) {
                LOGGER.debug("Discovery started: '{}'", (Object)device.getDisplayString());
            }

            public void remoteDeviceDiscoveryFailed(Registry registry, RemoteDevice device, Exception ex) {
                LOGGER.debug("Discovery failed: '{}'", (Object)(device.getDisplayString() + " => " + ex));
            }

            public void remoteDeviceAdded(Registry registry, RemoteDevice device) {
                LOGGER.debug("Remote device available: '{}'", (Object)device.getDisplayString());
            }

            public void remoteDeviceUpdated(Registry registry, RemoteDevice device) {
            }

            public void remoteDeviceRemoved(Registry registry, RemoteDevice device) {
                LOGGER.debug("Remote device removed: '{}'", (Object)device.getDisplayString());
            }

            public void localDeviceAdded(Registry registry, LocalDevice device) {
                LOGGER.debug("Local device added: '{}", (Object)device.getDisplayString());
            }

            public void localDeviceRemoved(Registry registry, LocalDevice device) {
                LOGGER.debug("Local device removed: '{}'", (Object)device.getDisplayString());
            }

            public void beforeShutdown(Registry registry) {
                LOGGER.debug("Before shutdown, the registry has devices: '{}'", (Object)registry.getDevices().size());
            }

            public void afterShutdown() {
                LOGGER.debug("Shutdown of registry complete!");
            }
        };
    }
}

