/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import com.formdev.flatlaf.FlatLaf;
import io.github.jacksonbrienen.jwfd.FileExtension;
import io.github.jacksonbrienen.jwfd.JWindowsFileDialog;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.FontUIResource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.thirdparty.TinyFileDialogs;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.components.label.ImageLabel;
import org.tinymediamanager.ui.components.label.LinkLabel;
import org.tinymediamanager.ui.dialogs.ImagePreviewDialog;
import org.tinymediamanager.ui.dialogs.UpdateDialog;
import org.tinymediamanager.ui.plaf.dark.TmmDarkLaf;
import org.tinymediamanager.ui.plaf.light.TmmLightLaf;
import org.tinymediamanager.updater.UpdateCheck;
import org.tinymediamanager.updater.UpdaterTask;

public class TmmUIHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmUIHelper.class);

    private TmmUIHelper() {
        throw new IllegalAccessError();
    }

    public static void setLookAndFeel() {
        try {
            LOGGER.trace("load theme");
            TmmUIHelper.setTheme();
            ToolTipManager.sharedInstance().setInitialDelay(300);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize LaF - {}", (Object)e.getMessage());
        }
        try {
            LOGGER.trace("load font settings");
            Font font = Font.decode(Settings.getInstance().getFontFamily());
            FontUIResource savedFont = new FontUIResource(font.getFamily(), font.getStyle(), Settings.getInstance().getFontSize());
            UIManager.put("defaultFont", savedFont);
        }
        catch (Exception e) {
            LOGGER.warn("could not set default font - {}", (Object)e.getMessage());
        }
    }

    public static Path selectDirectory(String title, String initialPath) {
        if ("true".equalsIgnoreCase(System.getProperty("tmm.legacy.filechooser"))) {
            return TmmUIHelper.openJFileChooser(1, title, initialPath, true, null, null);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            String path = JWindowsFileDialog.showDirectoryDialog(null, (String)title, (String)initialPath);
            if (StringUtils.isNotBlank((CharSequence)path)) {
                return Paths.get(path, new String[0]);
            }
            return null;
        }
        if (SystemUtils.IS_OS_MAC) {
            try {
                Path path = TmmUIHelper.openDirectoryDialog(title, initialPath);
                return path;
            }
            catch (Error | Exception e) {
                LOGGER.warn("cannot open AWT directory chooser: {}", (Object)e.getMessage());
            }
            finally {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
        } else {
            try {
                if (StringUtils.isBlank((CharSequence)initialPath) || !Files.exists(Paths.get(initialPath, new String[0]), new LinkOption[0])) {
                    initialPath = System.getProperty("user.home");
                }
                return new TinyFileDialogs().chooseDirectory(title, Paths.get(initialPath, new String[0]));
            }
            catch (Error | Exception e) {
                LOGGER.error("could not call TinyFileDialogs - {}", (Object)e.getMessage());
            }
        }
        return TmmUIHelper.openJFileChooser(1, title, initialPath, true, null, null);
    }

    private static Path openDirectoryDialog(String title, String initialPath) throws Exception, Error {
        Path path;
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        FileDialog chooser = new FileDialog((Frame)MainWindow.getFrame(), title);
        if (StringUtils.isNotBlank((CharSequence)initialPath) && Files.exists(path = Paths.get(initialPath, new String[0]), new LinkOption[0])) {
            chooser.setDirectory(path.toFile().getAbsolutePath());
        }
        chooser.setVisible(true);
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        if (StringUtils.isNotEmpty((CharSequence)chooser.getFile())) {
            return Paths.get(chooser.getDirectory(), chooser.getFile());
        }
        return null;
    }

    private static Path openJFileChooser(int mode, String dialogTitle, String initialPath, boolean open, String filename, FileNameExtensionFilter filter) {
        Path path;
        JFileChooser fileChooser = null;
        if (StringUtils.isNotBlank((CharSequence)initialPath) && Files.exists(path = Paths.get(initialPath, new String[0]), new LinkOption[0])) {
            fileChooser = new JFileChooser(path.toFile());
        }
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        fileChooser.setFileSelectionMode(mode);
        fileChooser.setDialogTitle(dialogTitle);
        int result = -1;
        if (open) {
            result = fileChooser.showOpenDialog(MainWindow.getFrame());
        } else {
            if (StringUtils.isNotBlank((CharSequence)filename)) {
                fileChooser.setSelectedFile(new File(filename));
                fileChooser.setFileFilter(filter);
            }
            result = fileChooser.showSaveDialog(MainWindow.getFrame());
        }
        if (result == 0) {
            return fileChooser.getSelectedFile().toPath();
        }
        return null;
    }

    public static Path selectFile(String title, String initialPath, FileNameExtensionFilter filter) {
        if ("true".equalsIgnoreCase(System.getProperty("tmm.legacy.filechooser"))) {
            return TmmUIHelper.openJFileChooser(0, title, initialPath, true, null, filter);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            String path = JWindowsFileDialog.showOpenDialog(null, (String)title, (String)initialPath, (FileExtension[])new FileExtension[0]);
            if (StringUtils.isNotBlank((CharSequence)path)) {
                return Paths.get(path, new String[0]);
            }
            return null;
        }
        if (SystemUtils.IS_OS_MAC) {
            try {
                return TmmUIHelper.openFileDialog(title, initialPath, 0, null);
            }
            catch (Error | Exception e) {
                LOGGER.warn("cannot open AWT filechooser: {}", (Object)e.getMessage());
            }
        } else {
            try {
                if (StringUtils.isBlank((CharSequence)initialPath) || !Files.exists(Paths.get(initialPath, new String[0]), new LinkOption[0])) {
                    initialPath = System.getProperty("user.home");
                }
                String[] filterList = null;
                String filterDescription = null;
                if (filter != null) {
                    ArrayList<CallSite> extensions = new ArrayList<CallSite>();
                    filterDescription = filter.getDescription();
                    for (String extension : filter.getExtensions()) {
                        extensions.add((CallSite)((Object)("*" + extension)));
                    }
                    filterList = extensions.toArray(new String[0]);
                }
                return new TinyFileDialogs().openFile(title, Paths.get(initialPath, new String[0]), filterList, filterDescription);
            }
            catch (Error | Exception e) {
                LOGGER.error("could not call TinyFileDialogs - {}", (Object)e.getMessage());
            }
        }
        return TmmUIHelper.openJFileChooser(0, title, initialPath, true, null, filter);
    }

    public static Path selectApplication(String title, String initialPath) {
        if (SystemUtils.IS_OS_MAC) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"/usr/bin/osascript", "-e", "set selectedFolder to choose application as alias\nreturn POSIX path of selectedFolder"});
                int result = process.waitFor();
                if (result == 0) {
                    String selectedFolder = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
                    return Paths.get(selectedFolder, new String[0]);
                }
            }
            catch (Exception e) {
                LOGGER.error("could not call osascript - '{}'", (Object)e.getMessage());
            }
            return null;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return TmmUIHelper.selectFile(title, initialPath, new FileNameExtensionFilter(TmmResourceBundle.getString("tmm.executables"), ".exe"));
        }
        return TmmUIHelper.selectFile(title, initialPath, null);
    }

    private static Path openFileDialog(String title, String initialPath, int mode, String filename) throws Exception, Error {
        Path path;
        FileDialog chooser = new FileDialog((Frame)MainWindow.getFrame(), title, mode);
        if (StringUtils.isNotBlank((CharSequence)initialPath) && Files.exists(path = Paths.get(initialPath, new String[0]), new LinkOption[0])) {
            chooser.setDirectory(path.toFile().getAbsolutePath());
        }
        if (mode == 1) {
            chooser.setFile(filename);
        }
        chooser.setVisible(true);
        if (StringUtils.isNotEmpty((CharSequence)chooser.getFile())) {
            return Paths.get(chooser.getDirectory(), chooser.getFile());
        }
        return null;
    }

    public static Path saveFile(String title, String initialPath, String filename, FileNameExtensionFilter filter) {
        if ("true".equalsIgnoreCase(System.getProperty("tmm.legacy.filechooser"))) {
            return TmmUIHelper.openJFileChooser(0, title, initialPath, false, filename, filter);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            String path = JWindowsFileDialog.showSaveDialog(null, (String)title, (String)(initialPath + File.separator + filename), (FileExtension[])new FileExtension[0]);
            if (StringUtils.isNotBlank((CharSequence)path)) {
                return Paths.get(path, new String[0]);
            }
            return null;
        }
        if (SystemUtils.IS_OS_MAC) {
            try {
                return TmmUIHelper.openFileDialog(title, initialPath, 1, filename);
            }
            catch (Error | Exception e) {
                LOGGER.warn("cannot open AWT filechooser: {}", (Object)e.getMessage());
            }
        } else {
            try {
                String[] filterList = null;
                String filterDescription = null;
                if (filter != null) {
                    ArrayList<CallSite> extensions = new ArrayList<CallSite>();
                    filterDescription = filter.getDescription();
                    for (String extension : filter.getExtensions()) {
                        extensions.add((CallSite)((Object)("*" + extension)));
                    }
                    filterList = extensions.toArray(new String[0]);
                }
                return new TinyFileDialogs().saveFile(title, Paths.get(initialPath, filename), filterList, filterDescription);
            }
            catch (Error | Exception e) {
                LOGGER.error("could not call TinyFileDialogs - {}", (Object)e.getMessage());
            }
        }
        return TmmUIHelper.openJFileChooser(0, title, initialPath, false, filename, filter);
    }

    public static void openFile(Path file) throws Exception {
        String fileType;
        if (file == null) {
            return;
        }
        String abs = file.toAbsolutePath().toString();
        if (StringUtils.isBlank((CharSequence)abs)) {
            return;
        }
        boolean rootFolder = false;
        if (file.getFileName() == null) {
            rootFolder = true;
        }
        String string = fileType = rootFolder ? ".mkv" : "." + FilenameUtils.getExtension((String)file.getFileName().toString().toLowerCase(Locale.ROOT));
        if (!rootFolder && StringUtils.isNotBlank((CharSequence)Settings.getInstance().getMediaPlayer()) && Settings.getInstance().getAllSupportedFileTypes().contains(fileType)) {
            if (SystemUtils.IS_OS_MAC) {
                TmmUIHelper.exec(new String[]{"open", Settings.getInstance().getMediaPlayer(), "--args", abs});
            } else {
                TmmUIHelper.exec(new String[]{Settings.getInstance().getMediaPlayer(), abs});
            }
        } else if (SystemUtils.IS_OS_WINDOWS) {
            try {
                Desktop.getDesktop().open(file.toFile());
            }
            catch (Exception e) {
                LOGGER.debug("could not open file with the default app - '{}'", (Object)e.getMessage());
                TmmUIHelper.exec(new String[]{"explorer", abs});
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            boolean started = false;
            try {
                TmmUIHelper.exec(new String[]{"gio", "open", abs});
                started = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!started) {
                try {
                    TmmUIHelper.exec(new String[]{"xdg-open", abs});
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!started && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(file.toFile());
            }
        } else if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().open(file.toFile());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void openFolder(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                TmmUIHelper.openFile(path);
            } else {
                LOGGER.debug("could not open folder '{}' -> does not exist?", (Object)path);
                BasicFileAttributes fileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                LOGGER.debug("isDir {}", (Object)fileAttributes.isDirectory());
                LOGGER.debug("isRegularFile {}", (Object)fileAttributes.isRegularFile());
                LOGGER.debug("isOther {}", (Object)fileAttributes.isOther());
                LOGGER.debug("isSymlink {}", (Object)fileAttributes.isSymbolicLink());
                LOGGER.debug("creationTime {}", (Object)fileAttributes.creationTime());
            }
        }
        catch (Exception ex) {
            LOGGER.error("open filemanager", (Throwable)ex);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
        }
    }

    public static void browseUrl(String url) throws Exception {
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(new URI(url));
        } else if (SystemUtils.IS_OS_LINUX) {
            boolean started = false;
            try {
                TmmUIHelper.exec(new String[]{"gio", "open", url});
                started = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!started) {
                try {
                    TmmUIHelper.exec(new String[]{"xdg-open", url});
                }
                catch (IOException iOException) {}
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void browseUrlSilently(String url) {
        try {
            TmmUIHelper.browseUrl(url);
        }
        catch (Exception e) {
            LOGGER.error("could not open url '{}' - {}", (Object)url, (Object)e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    private static void exec(String[] cmdline) throws IOException {
        Process p = Runtime.getRuntime().exec(cmdline);
        StreamRedirectThread stdoutReader = new StreamRedirectThread(p.getInputStream(), new NirvanaOutputStream());
        StreamRedirectThread stderrReader = new StreamRedirectThread(p.getErrorStream(), new NirvanaOutputStream());
        new Thread(stdoutReader).start();
        new Thread(stderrReader).start();
    }

    public static LinkLabel createLinkForImage(LinkLabel linklabel, ImageLabel image) {
        linklabel.addActionListener(e -> {
            if (StringUtils.isNotBlank((CharSequence)image.getImagePath())) {
                ImagePreviewDialog dialog = new ImagePreviewDialog(Paths.get(image.getImagePath(), new String[0]));
                dialog.setVisible(true);
            } else {
                ImagePreviewDialog dialog = new ImagePreviewDialog(image.getImageUrl());
                dialog.setVisible(true);
            }
        });
        return linklabel;
    }

    public static void updateUI() {
        for (Window w : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(w);
        }
        IconManager.updateIcons();
    }

    public static void setTheme() throws Exception {
        switch (Settings.getInstance().getTheme()) {
            case "Dark": {
                FlatLaf.setup((LookAndFeel)((Object)new TmmDarkLaf()));
                break;
            }
            default: {
                FlatLaf.setup((LookAndFeel)((Object)new TmmLightLaf()));
            }
        }
    }

    public static boolean shouldCheckForUpdate() {
        if (ReleaseInfo.isNightly()) {
            return true;
        }
        if (!Settings.getInstance().isEnableAutomaticUpdate()) {
            return false;
        }
        try {
            String lastUpdateCheck = TmmProperties.getInstance().getProperty("lastUpdateCheck", "0");
            long old = Long.parseLong(lastUpdateCheck);
            long now = new Date().getTime();
            return (float)now > (float)old + (float)((long)Settings.getInstance().getAutomaticUpdateInterval() * 1000L * 3600L) * 24.0f;
        }
        catch (Exception e) {
            LOGGER.debug("Could not check the update interval - '{}'", (Object)e.getMessage());
            return true;
        }
    }

    public static void checkForUpdate(int delayInSeconds) {
        Runnable runnable = () -> {
            try {
                UpdateCheck updateCheck = new UpdateCheck();
                if (updateCheck.isUpdateAvailable()) {
                    LOGGER.info("update available");
                    if (Globals.isSelfUpdatable() && updateCheck.isForcedUpdate()) {
                        LOGGER.info("Updating (forced)...");
                        TmmTaskManager.getInstance().addDownloadTask(new UpdaterTask());
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        if (StringUtils.isNotBlank((CharSequence)updateCheck.getChangelog())) {
                            UpdateDialog dialog = new UpdateDialog(updateCheck.getChangelog(), updateCheck.getBaseUrl());
                            dialog.setVisible(true);
                        } else if (Globals.isSelfUpdatable()) {
                            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
                            int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.update.message"), TmmResourceBundle.getString("tmm.update.title"), 0, 3, null, options, null);
                            if (answer == 0) {
                                LOGGER.info("Updating...");
                                TmmTaskManager.getInstance().addDownloadTask(new UpdaterTask());
                            }
                        }
                    });
                } else if (delayInSeconds == 0) {
                    JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.update.notfound"), TmmResourceBundle.getString("tmm.update.title"), 1);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Update check failed - {}", (Object)e.getMessage());
            }
        };
        if (delayInSeconds > 0) {
            Timer timer = new Timer(delayInSeconds * 1000, e -> TmmTaskManager.getInstance().addUnnamedTask(runnable));
            timer.setRepeats(false);
            timer.start();
        } else {
            TmmTaskManager.getInstance().addUnnamedTask(runnable);
        }
    }

    public static <E> void removeSelectedRowsFromJTable(JTable table, List<E> list) {
        int[] indexRows;
        for (int indexRow : indexRows = TmmUIHelper.getSelectedRowsAsModelRows(table)) {
            try {
                list.remove(indexRow);
            }
            catch (Exception e) {
                LOGGER.debug("Could not remove entry from the list - '{}'", (Object)e.getMessage());
            }
        }
    }

    public static int[] getSelectedRowsAsModelRows(JTable table) {
        int[] tableRows = table.getSelectedRows();
        int[] modelRows = new int[tableRows.length];
        for (int i = 0; i < tableRows.length; ++i) {
            modelRows[i] = table.convertRowIndexToModel(tableRows[i]);
        }
        ArrayUtils.reverse((int[])modelRows);
        return modelRows;
    }

    public static class StreamRedirectThread
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        public StreamRedirectThread(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int length = -1;
                byte[] buffer = new byte[0x100000];
                while (this.in != null && (length = this.in.read(buffer)) >= 0) {
                    this.out.write(buffer, 0, length);
                }
            }
            catch (Exception e) {
                LOGGER.error("Couldn't redirect stream: {}", (Object)e.getLocalizedMessage());
            }
        }
    }

    private static class NirvanaOutputStream
    extends OutputStream {
        private NirvanaOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
        }
    }
}

