/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.filter.Filter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class TmmUILogAppender
extends OutputStreamAppender<ILoggingEvent> {
    private final CopyableByteArrayOutputStream BUFFER = new CopyableByteArrayOutputStream(0x200000);

    public TmmUILogAppender(String level) {
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(level);
        filter.start();
        this.addFilter((Filter)filter);
    }

    public void start() {
        this.setOutputStream(this.BUFFER);
        super.start();
    }

    public void setOutputStream(OutputStream outputStream) {
        if (outputStream != this.BUFFER) {
            throw new IllegalStateException("Invalid output stream (" + CopyableByteArrayOutputStream.class + " expected) !");
        }
        super.setOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogOutput getLogOutput(int from) {
        byte[] buffer;
        int size;
        try {
            this.streamWriteLock.lock();
            size = this.BUFFER.size();
            buffer = from < size ? this.BUFFER.toByteArray(from) : null;
        }
        finally {
            this.streamWriteLock.unlock();
        }
        return new LogOutput(size, buffer != null ? new String(buffer, 0, buffer.length) : "");
    }

    private static class CopyableByteArrayOutputStream
    extends ByteArrayOutputStream {
        protected CopyableByteArrayOutputStream(int size) {
            super(size);
        }

        protected synchronized byte[] toByteArray(int from) {
            int pos = from < 0 || from > this.count ? 0 : from;
            return CopyableByteArrayOutputStream.copyOfRange(this.buf, pos, this.count);
        }

        public static byte[] copyOfRange(byte[] original, int from, int to) {
            int newLength = to - from;
            if (newLength < 0) {
                throw new IllegalArgumentException(from + " > " + to);
            }
            byte[] copy = new byte[newLength];
            System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
            return copy;
        }
    }

    public static class LogOutput {
        private final int byteCount;
        private final String content;

        protected LogOutput(int byteCount, String content) {
            this.byteCount = byteCount;
            this.content = content;
        }

        public int getByteCount() {
            return this.byteCount;
        }

        public String getContent() {
            return this.content;
        }
    }
}

