/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class FeedbackAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackAction.class);

    public FeedbackAction() {
        this.putValue("Name", TmmResourceBundle.getString("Feedback"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("Feedback"));
        this.putValue("SmallIcon", IconManager.FEEDBACK);
        this.putValue("SwingLargeIconKey", IconManager.FEEDBACK);
    }

    @Override
    protected void processAction(ActionEvent e) {
        String url = StringEscapeUtils.unescapeHtml4((String)"https://www.reddit.com/r/tinyMediaManager/");
        try {
            TmmUIHelper.browseUrl(url);
        }
        catch (Exception e1) {
            LOGGER.error("FAQ", (Throwable)e1);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
        }
    }
}

