/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import org.tinymediamanager.ui.components.table.TmmTable;

public abstract class TmmEditorTable
extends TmmTable {
    public TmmEditorTable() {
        TableButtonListener listener = new TableButtonListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        ActionMap am = this.getActionMap();
        am.put("edit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TmmEditorTable.this.editButtonClicked(TmmEditorTable.this.convertRowIndexToModel(TmmEditorTable.this.getSelectedRow()));
            }
        });
        am.put("tabPressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = TmmEditorTable.this.getSelectedRow();
                if (selectedRow == TmmEditorTable.this.getRowCount() - 1) {
                    TmmEditorTable.this.clearSelection();
                    TmmEditorTable.this.transferFocus();
                } else {
                    TmmEditorTable.this.changeSelection(selectedRow + 1, 0, false, false);
                }
            }
        });
        am.put("tabPressedReverse", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = TmmEditorTable.this.getSelectedRow();
                if (selectedRow == 0) {
                    TmmEditorTable.this.clearSelection();
                    TmmEditorTable.this.transferFocusBackward();
                } else {
                    TmmEditorTable.this.changeSelection(selectedRow - 1, 0, false, false);
                }
            }
        });
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(69, 192), "edit");
        im.put(KeyStroke.getKeyStroke(9, 0), "tabPressed");
        im.put(KeyStroke.getKeyStroke(9, 64), "tabPressedReverse");
    }

    public TmmEditorTable(TableModel tableModel) {
        this();
        this.setModel(tableModel);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.paramString().startsWith("FOCUS_GAINED") && this.getRowCount() > 0 && this.getSelectedRow() == -1) {
            this.changeSelection(0, 0, false, false);
        }
    }

    protected boolean isEditorColumn(int column) {
        if (column < 0) {
            return false;
        }
        return "edit".equals(this.getColumnModel().getColumn(column).getIdentifier());
    }

    protected abstract void editButtonClicked(int var1);

    protected boolean isLinkCell(int row, int column) {
        return this.isEditorColumn(column);
    }

    protected void linkClicked(int row, int column) {
    }

    private class TableButtonListener
    extends MouseAdapter {
        private final JTable table;

        private TableButtonListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            this.click(arg0);
        }

        private void click(MouseEvent arg0) {
            int row = this.table.rowAtPoint(arg0.getPoint());
            int col = this.table.columnAtPoint(arg0.getPoint());
            if (TmmEditorTable.this.isEditorColumn(col)) {
                row = this.table.convertRowIndexToModel(row);
                TmmEditorTable.this.editButtonClicked(row);
            } else if (TmmEditorTable.this.isLinkCell(row, col)) {
                row = this.table.convertRowIndexToModel(row);
                TmmEditorTable.this.linkClicked(row, col);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Point point = new Point(e.getX(), e.getY());
            int row = this.table.rowAtPoint(point);
            int col = this.table.columnAtPoint(point);
            if (row == -1 || col == -1) {
                this.table.setCursor(new Cursor(0));
                return;
            }
            if (TmmEditorTable.this.isLinkCell(row, col)) {
                this.table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Point point = new Point(e.getX(), e.getY());
            int row = this.table.rowAtPoint(point);
            int col = this.table.columnAtPoint(point);
            if (row == -1 || col == -1) {
                this.table.setCursor(new Cursor(0));
                return;
            }
            if (!TmmEditorTable.this.isLinkCell(row, col)) {
                this.table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point point = new Point(e.getX(), e.getY());
            int row = this.table.rowAtPoint(point);
            int col = this.table.columnAtPoint(point);
            if (row == -1 || col == -1) {
                this.table.setCursor(new Cursor(0));
                return;
            }
            if (!TmmEditorTable.this.isLinkCell(row, col) && this.table.getCursor().getType() == 12) {
                this.table.setCursor(new Cursor(0));
            }
            if (TmmEditorTable.this.isLinkCell(row, col) && this.table.getCursor().getType() == 0) {
                this.table.setCursor(new Cursor(12));
            }
        }
    }
}

