/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.net.URLEncoder;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.movie.MovieComparator;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowComparator;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.ExportLogAction;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class BugReportDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(BugReportDialog.class);
    private static final String DIALOG_ID = "bugReportdialog";

    public BugReportDialog() {
        super(TmmResourceBundle.getString("BugReport"), DIALOG_ID);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][][450lp,grow]", "[][20lp][][][][][20lp][][][]"));
        JTextArea taDescription = new JTextArea();
        taDescription.setOpaque(false);
        taDescription.setWrapStyleWord(true);
        taDescription.setLineWrap(true);
        taDescription.setEditable(false);
        taDescription.setText(TmmResourceBundle.getString("BugReport.description"));
        panelContent.add((Component)taDescription, "cell 0 0 3 1,growx");
        JLabel lblStep1 = new JLabel(TmmResourceBundle.getString("BugReport.step1"));
        panelContent.add((Component)lblStep1, "cell 0 2");
        JTextArea taStep1 = new JTextArea();
        taStep1.setWrapStyleWord(true);
        taStep1.setLineWrap(true);
        taStep1.setText(TmmResourceBundle.getString("BugReport.step1.description"));
        taStep1.setOpaque(false);
        taStep1.setEditable(false);
        panelContent.add((Component)taStep1, "cell 2 2,growx");
        JComboBox<EntityContainer> cbMovieList = new JComboBox<EntityContainer>();
        Movie dummym = new Movie();
        dummym.setTitle("- select movie -");
        dummym.setDbId(null);
        cbMovieList.addItem(new EntityContainer(dummym));
        List<Movie> movies = MovieModuleManager.getInstance().getMovieList().getMovies();
        movies.sort(new MovieComparator());
        for (MediaEntity mediaEntity : movies) {
            cbMovieList.addItem(new EntityContainer(mediaEntity));
        }
        panelContent.add(cbMovieList, "cell 2 3,growx");
        JComboBox<EntityContainer> cbTvshowList = new JComboBox<EntityContainer>();
        TvShow tvShow = new TvShow();
        tvShow.setTitle("- select tvShow -");
        tvShow.setDbId(null);
        cbTvshowList.addItem(new EntityContainer(tvShow));
        List<TvShow> tvShows = TvShowModuleManager.getInstance().getTvShowList().getTvShows();
        tvShows.sort(new TvShowComparator());
        for (TvShow s : tvShows) {
            cbTvshowList.addItem(new EntityContainer(s));
        }
        panelContent.add(cbTvshowList, "cell 2 4,growx");
        JButton btnSaveLogs = new JButton(TmmResourceBundle.getString("BugReport.createlogs"));
        btnSaveLogs.addActionListener(e -> {
            Movie m = (Movie)((EntityContainer)cbMovieList.getSelectedItem()).entity;
            TvShow s = (TvShow)((EntityContainer)cbTvshowList.getSelectedItem()).entity;
            ExportLogAction ela = new ExportLogAction(m, s);
            ela.actionPerformed(e);
        });
        panelContent.add((Component)btnSaveLogs, "cell 2 5");
        JLabel lblStep2 = new JLabel(TmmResourceBundle.getString("BugReport.step2"));
        panelContent.add((Component)lblStep2, "cell 0 7");
        JTextArea taStep2 = new JTextArea();
        taStep2.setLineWrap(true);
        taStep2.setWrapStyleWord(true);
        taStep2.setOpaque(false);
        taStep2.setEditable(false);
        taStep2.setText(TmmResourceBundle.getString("BugReport.step2.description"));
        panelContent.add((Component)taStep2, "cell 2 7,growx");
        JButton btnCreateIssue = new JButton(TmmResourceBundle.getString("BugReport.craeteissue"));
        btnCreateIssue.addActionListener(e -> {
            String baseUrl = "https://gitlab.com/tinyMediaManager/tinyMediaManager/issues/new?issuable_template=Bug&issue[description]=";
            String params = "Version: " + ReleaseInfo.getRealVersion() + "  ";
            params = params + "\nBuild: " + ReleaseInfo.getRealBuildDate() + "  ";
            params = params + "\nOS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "  ";
            params = params + "\nJDK: " + System.getProperty("java.version") + " " + System.getProperty("os.arch") + " " + System.getProperty("java.vendor") + "  ";
            Object url = "";
            try {
                url = baseUrl + URLEncoder.encode(params, "UTF-8");
                TmmUIHelper.browseUrl((String)url);
            }
            catch (Exception e1) {
                LOGGER.error("FAQ", (Throwable)e1);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
            }
        });
        panelContent.add((Component)btnCreateIssue, "cell 2 8,alignx left,aligny center");
        JLabel lblHintIcon = new JLabel(IconManager.HINT);
        panelContent.add((Component)lblHintIcon, "cell 1 9,alignx left,aligny center");
        JLabel lblHint = new JLabel(TmmResourceBundle.getString("BugReport.languagehint"));
        panelContent.add((Component)lblHint, "cell 2 9,growx,aligny top");
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.setIcon(IconManager.CANCEL_INV);
        btnClose.addActionListener(e -> this.setVisible(false));
        this.addDefaultButton(btnClose);
    }

    class EntityContainer {
        MediaEntity entity;

        EntityContainer(MediaEntity entity) {
            this.entity = entity;
        }

        public String toString() {
            return this.entity.getTitle();
        }
    }
}

