/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPane;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.updater.UpdaterTask;

public class UpdateDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateDialog.class);

    public UpdateDialog(String changelog, String baseurl) {
        super(TmmResourceBundle.getString("tmm.update.title"), "update");
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][10lp:n][][400lp,grow]"));
        ReadOnlyTextPane lblUpdateInfo = new ReadOnlyTextPane();
        ((JEditorPane)lblUpdateInfo).setText(TmmResourceBundle.getString("tmm.update.message"));
        panelContent.add((Component)lblUpdateInfo, "cell 0 0,growx");
        JLabel lblChangelog = new JLabel(TmmResourceBundle.getString("whatsnew.title"));
        panelContent.add((Component)lblChangelog, "cell 0 2,growx");
        NoBorderScrollPane scrollPane = new NoBorderScrollPane();
        panelContent.add((Component)scrollPane, "cell 0 3,grow");
        JTextPane textPane = new JTextPane();
        textPane.setFont(new Font("Monospaced", 0, Settings.getInstance().getFontSize() + 1));
        scrollPane.setViewportView(textPane);
        textPane.setContentType("text/html");
        textPane.setText(this.prepareTextAsHtml(changelog));
        textPane.setEditable(false);
        textPane.setCaretPosition(0);
        textPane.addHyperlinkListener(hle -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                try {
                    TmmUIHelper.browseUrl(hle.getURL().toString());
                }
                catch (Exception e) {
                    LOGGER.error("error browsing to \"{}\" : {}", (Object)hle.getURL(), (Object)e.getMessage());
                }
            }
        });
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
        JButton btnUpdate = new JButton(TmmResourceBundle.getString("Button.update"));
        btnUpdate.addActionListener(arg0 -> {
            if (Globals.isSelfUpdatable()) {
                this.setVisible(false);
                LOGGER.info("Updating...");
                TmmTaskManager.getInstance().addDownloadTask(new UpdaterTask());
            } else {
                try {
                    TmmUIHelper.browseUrl(baseurl);
                }
                catch (Exception e) {
                    LOGGER.warn("could not open '{}' - '{}'", (Object)baseurl, (Object)e.getMessage());
                }
            }
        });
        if (Globals.isDocker() || !Globals.isSelfUpdatable() && StringUtils.isBlank((CharSequence)baseurl)) {
            btnUpdate.setEnabled(false);
        }
        this.addButton(btnUpdate);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superPref = super.getPreferredSize();
        return new Dimension((int)(700.0 > superPref.getWidth() ? superPref.getWidth() : 700.0), (int)(500.0 > superPref.getHeight() ? superPref.getHeight() : 500.0));
    }

    private String prepareTextAsHtml(String originalText) {
        originalText = originalText.replace("<", "&lt;").replace(">", "&gt;");
        Pattern pattern = Pattern.compile("(http[s]?://.*?)[\\n\\r\\s)]");
        Matcher matcher = pattern.matcher(originalText);
        while (matcher.find()) {
            originalText = originalText.replace(matcher.group(1), "<a href=\"" + matcher.group(1) + "\">" + matcher.group(1) + "</a>");
        }
        pattern = Pattern.compile("(#\\d{3,5})[\\n\\r\\s)]");
        matcher = pattern.matcher(originalText);
        while (matcher.find()) {
            originalText = originalText.replace(matcher.group(1), "<a href=\"https://gitlab.com/tinyMediaManager/tinyMediaManager/-/issues/" + matcher.group(1).replace("#", "") + "\">" + matcher.group(1) + "</a>");
        }
        Color foreground = UIManager.getColor("TextPane.foreground");
        String color = Integer.toHexString(foreground.getRed()) + Integer.toHexString(foreground.getGreen()) + Integer.toHexString(foreground.getBlue());
        return "<html><pre style=\"color: #" + color + "\">" + originalText + "</pre><html>";
    }
}

