/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieTrailerDownloadTask;
import org.tinymediamanager.core.tasks.QueueTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MovieChooserModel
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieChooserModel.class);
    public static final MovieChooserModel emptyResult = new MovieChooserModel();
    private final Movie movieToScrape;
    private MediaScraper metadataProvider = null;
    private List<MediaScraper> artworkScrapers = null;
    private List<MediaScraper> trailerScrapers = null;
    private MediaLanguages language = null;
    private MediaSearchResult result = null;
    private MediaMetadata metadata = null;
    private float score = 0.0f;
    private String title = "";
    private String originalTitle = "";
    private String overview = "";
    private int year = 0;
    private String id = "";
    private String combinedName = "";
    private String posterUrl = "";
    private String tagline = "";
    private final List<Person> castMembers = new ArrayList<Person>();
    private boolean scraped = false;
    private QueueTask queueTask;

    public MovieChooserModel(Movie movie, MediaScraper metadataProvider, List<MediaScraper> artworkScrapers, List<MediaScraper> trailerScrapers, MediaSearchResult result, MediaLanguages language) {
        this.movieToScrape = movie;
        this.metadataProvider = metadataProvider;
        this.artworkScrapers = artworkScrapers;
        this.trailerScrapers = trailerScrapers;
        this.result = result;
        this.language = language;
        this.score = result.getScore();
        this.setTitle(result.getTitle());
        this.setOriginalTitle(result.getOriginalTitle());
        this.setYear(result.getYear());
        Object obj = result.getId();
        if (obj != null) {
            this.setId(obj.toString());
        }
        this.setCombinedName();
    }

    private MovieChooserModel() {
        this.setTitle(TmmResourceBundle.getString("chooser.nothingfound"));
        this.movieToScrape = null;
        this.combinedName = this.title;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = StrgUtils.getNonNullString(title);
        this.firePropertyChange("title", oldValue, this.title);
    }

    public void setOriginalTitle(String originalTitle) {
        String oldValue = this.originalTitle;
        this.originalTitle = StrgUtils.getNonNullString(originalTitle);
        this.firePropertyChange("originalTitle", oldValue, this.originalTitle);
    }

    public void setOverview(String overview) {
        String oldValue = this.overview;
        this.overview = StrgUtils.getNonNullString(overview);
        this.firePropertyChange("overview", oldValue, this.overview);
    }

    public void setCastMembers(List<Person> castMembers) {
        this.castMembers.clear();
        this.castMembers.addAll(castMembers);
        this.firePropertyChange("castMembers", null, castMembers);
    }

    public float getScore() {
        return this.score;
    }

    public String getTitle() {
        return this.title;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public String getOverview() {
        return this.overview;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String oldValue = this.id;
        this.id = id;
        this.firePropertyChange("id", oldValue, this.id);
    }

    public List<Person> getCastMembers() {
        return this.castMembers;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public void setPosterUrl(String newValue) {
        String oldValue = this.posterUrl;
        this.posterUrl = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("posterUrl", oldValue, newValue);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        int oldValue = this.year;
        this.year = year;
        this.firePropertyChange("year", oldValue, this.year);
    }

    public void setCombinedName() {
        String oldValue = this.combinedName;
        this.combinedName = this.getYear() > 0 ? this.getTitle() + " (" + this.getYear() + ")" : this.getTitle();
        this.firePropertyChange("combinedName", oldValue, this.combinedName);
    }

    public String getCombinedName() {
        return this.combinedName;
    }

    public MediaScraper getMetadataProvider() {
        return this.metadataProvider;
    }

    public MediaLanguages getLanguage() {
        return this.language;
    }

    public void scrapeMetaData() {
        try {
            this.setPosterUrl(this.result.getPosterUrl());
            MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
            options.setSearchResult(this.result);
            options.setLanguage(this.language);
            options.setCertificationCountry(MovieModuleManager.getInstance().getSettings().getCertificationCountry());
            options.setReleaseDateCountry(MovieModuleManager.getInstance().getSettings().getReleaseDateCountry());
            options.setIds(this.result.getIds());
            LOGGER.info("=====================================================");
            LOGGER.info("Scrape movie metadata with scraper: '{}' - '{}'", (Object)this.metadataProvider.getMediaProvider().getProviderInfo().getId(), (Object)this.metadataProvider.getMediaProvider().getProviderInfo().getVersion());
            LOGGER.info("{}", (Object)options);
            LOGGER.info("=====================================================");
            try {
                int movieSetId;
                this.metadata = ((IMovieMetadataProvider)this.metadataProvider.getMediaProvider()).getMetadata(options);
                if (this.metadata.getIdAsInt("tmdbSet") == 0 && !this.metadataProvider.getId().equals("tmdb") && (movieSetId = MetadataUtil.getMovieSetId(this.metadata.getIds())) > 0) {
                    this.metadata.setId("tmdbSet", movieSetId);
                }
                MediaIdUtil.injectMissingIds(this.metadata.getIds(), MediaType.MOVIE);
            }
            catch (MissingIdException e) {
                LOGGER.warn("missing id for scrape");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "MovieChooser", "scraper.error.missingid"));
                return;
            }
            catch (ScrapeException e) {
                LOGGER.error("searchMovieFallback", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieChooser", "message.scrape.metadatamoviefailed", new String[]{":", e.getLocalizedMessage()}));
                return;
            }
            catch (Exception e) {
                LOGGER.error("unforeseen error: ", (Throwable)e);
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)this.metadata.getTitle())) {
                this.setTitle(this.metadata.getTitle());
            }
            this.setOriginalTitle(this.metadata.getOriginalTitle());
            ArrayList<Person> cast = new ArrayList<Person>();
            int i = 0;
            for (Person castMember : this.metadata.getCastMembers(Person.Type.DIRECTOR)) {
                cast.add(new Person(castMember));
                if (++i < 2) continue;
                break;
            }
            i = 0;
            for (Person castMember : this.metadata.getCastMembers(Person.Type.PRODUCER)) {
                cast.add(new Person(castMember));
                if (++i < 2) continue;
                break;
            }
            for (Person castMember : this.metadata.getCastMembers(Person.Type.ACTOR)) {
                cast.add(new Person(castMember));
            }
            this.setCastMembers(cast);
            this.setOverview(this.metadata.getPlot());
            this.setTagline(this.metadata.getTagline());
            if (StringUtils.isBlank((CharSequence)this.posterUrl) && !this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                this.setPosterUrl(this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0).getPreviewUrl());
            }
            this.setScraped(true);
        }
        catch (Exception e) {
            LOGGER.error("scrapeMedia", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieChooser", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    public boolean isDuplicate() {
        if (this == emptyResult) {
            return false;
        }
        for (Movie movie : MovieModuleManager.getInstance().getMovieList().getMovies()) {
            if (this.movieToScrape == movie) continue;
            for (Map.Entry<String, Object> entry : this.result.getIds().entrySet()) {
                Object id = movie.getId(entry.getKey());
                if (id == null || !id.toString().equals(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isScraped() {
        return this.scraped;
    }

    private void setScraped(boolean newvalue) {
        boolean oldValue = this.scraped;
        this.scraped = newvalue;
        this.firePropertyChange("scraped", oldValue, newvalue);
    }

    public void setTagline(String newValue) {
        String oldValue = this.tagline;
        this.tagline = newValue;
        this.firePropertyChange("tagline", oldValue, newValue);
    }

    public String getTagline() {
        return this.tagline;
    }

    public void addTask(TmmTask task) {
        if (this.queueTask == null) {
            this.queueTask = new QueueTask(TmmResourceBundle.getString("movie.scrape.metadata"));
        }
        this.queueTask.addTask(task);
    }

    public void startTasks() {
        if (this.queueTask != null) {
            TmmTaskManager.getInstance().addUnnamedTask(this.queueTask);
            this.queueTask = null;
        }
    }

    public void startArtworkScrapeTask(List<MovieScraperMetadataConfig> config, boolean overwrite) {
        this.addTask(new ArtworkScrapeTask(this.movieToScrape, config, overwrite));
    }

    public void startTrailerScrapeTask(boolean overwrite) {
        this.addTask(new TrailerScrapeTask(this.movieToScrape, overwrite));
    }

    public List<MediaArtwork> getArtwork() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.MOVIE);
        options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
        options.setMetadata(this.metadata);
        options.setIds(this.metadata.getIds());
        if (this.movieToScrape.isStacked()) {
            ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
            mfs.addAll(this.movieToScrape.getMediaFiles(MediaFileType.VIDEO));
            options.setId("mediaFile", mfs);
        } else {
            options.setId("mediaFile", this.movieToScrape.getMainFile());
        }
        options.setLanguage(MovieModuleManager.getInstance().getSettings().getDefaultImageScraperLanguage());
        options.setFanartSize(MovieModuleManager.getInstance().getSettings().getImageFanartSize());
        options.setPosterSize(MovieModuleManager.getInstance().getSettings().getImagePosterSize());
        this.artworkScrapers.parallelStream().forEach(artworkScraper -> {
            IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)artworkScraper.getMediaProvider();
            try {
                lock.writeLock().lock();
                artwork.addAll(artworkProvider.getArtwork(options));
            }
            catch (MissingIdException e) {
                LOGGER.debug("no id found for scraper {}", (Object)artworkScraper.getMediaProvider().getProviderInfo().getId());
            }
            catch (ScrapeException e) {
                LOGGER.error("getArtwork", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movieToScrape, "message.scrape.movieartworkfailed", new String[]{":", e.getLocalizedMessage()}));
            }
            catch (Error e) {
                LOGGER.debug("uncaught error", (Throwable)e);
            }
            finally {
                lock.writeLock().unlock();
            }
        });
        if (StringUtils.isNotBlank((CharSequence)this.getPosterUrl())) {
            MediaArtwork ma = new MediaArtwork(this.result.getProviderId(), MediaArtwork.MediaArtworkType.POSTER);
            ma.setOriginalUrl(this.getPosterUrl());
            ma.setPreviewUrl(this.getPosterUrl());
            ma.addImageSize(0, 0, this.getPosterUrl(), 0);
            artwork.add(ma);
        }
        return artwork;
    }

    private class ArtworkScrapeTask
    extends TmmTask {
        private final Movie movieToScrape;
        private final List<MovieScraperMetadataConfig> config;
        private final boolean overwrite;

        public ArtworkScrapeTask(Movie movie, List<MovieScraperMetadataConfig> config, boolean overwrite) {
            super(TmmResourceBundle.getString("message.scrape.artwork") + " " + movie.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.movieToScrape = movie;
            this.config = config;
            this.overwrite = overwrite;
        }

        @Override
        protected void doInBackground() {
            if (!MovieChooserModel.this.scraped) {
                return;
            }
            List<MediaArtwork> artwork = MovieChooserModel.this.getArtwork();
            this.movieToScrape.setArtwork(artwork, this.config, this.overwrite);
        }
    }

    private class TrailerScrapeTask
    extends TmmTask {
        private final Movie movieToScrape;
        private final boolean overwrite;

        public TrailerScrapeTask(Movie movie, boolean overwrite) {
            super(TmmResourceBundle.getString("message.scrape.trailer") + " " + movie.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.movieToScrape = movie;
            this.overwrite = overwrite;
        }

        @Override
        protected void doInBackground() {
            if (!MovieChooserModel.this.scraped) {
                return;
            }
            if (!this.overwrite && !this.movieToScrape.getTrailer().isEmpty()) {
                return;
            }
            ArrayList<MediaTrailer> trailer = new ArrayList<MediaTrailer>();
            TrailerSearchAndScrapeOptions options = new TrailerSearchAndScrapeOptions(MediaType.MOVIE);
            options.setMetadata(MovieChooserModel.this.metadata);
            options.setIds(MovieChooserModel.this.metadata.getIds());
            options.setLanguage(MovieChooserModel.this.language);
            for (MediaScraper trailerScraper : MovieChooserModel.this.trailerScrapers) {
                try {
                    IMovieTrailerProvider trailerProvider = (IMovieTrailerProvider)trailerScraper.getMediaProvider();
                    trailer.addAll(trailerProvider.getTrailers(options));
                }
                catch (MissingIdException ignored) {
                    LOGGER.debug("no id found for scraper {}", (Object)trailerScraper.getMediaProvider().getProviderInfo().getId());
                }
                catch (ScrapeException e) {
                    LOGGER.error("getTrailers {}", (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieChooser", "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
            this.movieToScrape.setTrailers(trailer);
            this.movieToScrape.saveToDb();
            this.movieToScrape.writeNFO();
            if (MovieModuleManager.getInstance().getSettings().isUseTrailerPreference() && MovieModuleManager.getInstance().getSettings().isAutomaticTrailerDownload() && this.movieToScrape.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !this.movieToScrape.getTrailer().isEmpty()) {
                MovieTrailerDownloadTask task = new MovieTrailerDownloadTask(this.movieToScrape);
                TmmTaskManager.getInstance().addDownloadTask(task);
            }
        }
    }
}

