/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieFetchRatingsTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieFetchRatingsDialog;

public class MovieFetchRatingsAction
extends TmmAction {
    public MovieFetchRatingsAction() {
        this.putValue("SwingLargeIconKey", IconManager.RATING_BLUE);
        this.putValue("SmallIcon", IconManager.RATING_BLUE);
        this.putValue("Name", TmmResourceBundle.getString("movie.fetchratings"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MovieFetchRatingsDialog dialog = new MovieFetchRatingsDialog();
        dialog.setVisible(true);
        List<RatingProvider.RatingSource> sources = dialog.getSelectedRatingSources();
        if (!sources.isEmpty()) {
            TmmTaskManager.getInstance().addUnnamedTask(new MovieFetchRatingsTask(selectedMovies, sources));
        }
    }
}

