/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MoviePlayAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoviePlayAction.class);

    public MoviePlayAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.play"));
        this.putValue("SmallIcon", IconManager.PLAY);
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.play.desc"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 128));
    }

    @Override
    protected void processAction(ActionEvent e) {
        MediaFile mf = MovieUIModule.getInstance().getSelectionModel().getSelectedMovie().getMainVideoFile();
        if (StringUtils.isNotBlank((CharSequence)mf.getFilename())) {
            try {
                TmmUIHelper.openFile(MediaFileHelper.getMainVideoFile(mf));
            }
            catch (Exception ex) {
                LOGGER.error("open file", (Throwable)ex);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
            }
        }
    }
}

