/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieComparator;
import org.tinymediamanager.core.movie.MovieRenamerPreview;
import org.tinymediamanager.core.movie.MovieRenamerPreviewContainer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieRenamerPreviewDialog
extends TmmDialog {
    private final EventList<MovieRenamerPreviewContainer> results;
    private final ResultSelectionModel resultSelectionModel;
    private final EventList<MediaFileContainer> oldMediaFileEventList = GlazedLists.eventList(new ArrayList());
    private final EventList<MediaFileContainer> newMediaFileEventList = GlazedLists.eventList(new ArrayList());
    private final TmmTable tableMovies;
    private final JLabel lblTitle;
    private final JLabel lblDatasource;
    private final JLabel lblFolderOld;
    private final JLabel lblFolderNew;
    private final JCheckBox cbFilter;
    private final MoviePreviewWorker worker;

    public MovieRenamerPreviewDialog(List<Movie> selectedMovies) {
        super(TmmResourceBundle.getString("movie.renamerpreview"), "movieRenamerPreview");
        this.results = GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()));
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[950lp,grow]", "[600lp,grow]"));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setName(this.getName() + ".splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        splitPane.setResizeWeight(0.4);
        panelContent.add((Component)splitPane, "cell 0 0,grow");
        TmmTableModel<MovieRenamerPreviewContainer> movieTableModel = new TmmTableModel<MovieRenamerPreviewContainer>((EventList<MovieRenamerPreviewContainer>)GlazedListsSwing.swingThreadProxyList(this.results), new ResultTableFormat());
        this.tableMovies = new TmmTable((TableModel)((Object)movieTableModel));
        DefaultEventSelectionModel tableSelectionModel = new DefaultEventSelectionModel(this.results);
        this.resultSelectionModel = new ResultSelectionModel();
        tableSelectionModel.addListSelectionListener((ListSelectionListener)this.resultSelectionModel);
        this.resultSelectionModel.selectedResults = tableSelectionModel.getSelected();
        this.tableMovies.setSelectionModel((ListSelectionModel)tableSelectionModel);
        movieTableModel.addTableModelListener(arg0 -> {
            ListSelectionModel selectionModel = this.tableMovies.getSelectionModel();
            if (selectionModel.isSelectionEmpty() && movieTableModel.getRowCount() > 0) {
                selectionModel.setSelectionInterval(0, 0);
            }
            if (selectionModel.isSelectionEmpty() && movieTableModel.getRowCount() == 0) {
                this.resultSelectionModel.setSelectedResult(null);
            }
        });
        JScrollPane scrollPaneMovies = new JScrollPane();
        this.tableMovies.configureScrollPane(scrollPaneMovies);
        splitPane.setLeftComponent(scrollPaneMovies);
        JPanel panelDetails = new JPanel();
        splitPane.setRightComponent(panelDetails);
        panelDetails.setLayout((LayoutManager)new MigLayout("", "[][][grow]", "[][][][][][][][grow]"));
        this.lblTitle = new JLabel("");
        TmmFontHelper.changeFont(this.lblTitle, 1.33, 1);
        panelDetails.add((Component)this.lblTitle, "cell 0 0 3 1,growx");
        TmmLabel lblDatasourceT = new TmmLabel(TmmResourceBundle.getString("metatag.datasource"));
        panelDetails.add((Component)lblDatasourceT, "cell 0 2");
        this.lblDatasource = new JLabel("");
        panelDetails.add((Component)this.lblDatasource, "cell 2 2,growx,aligny center");
        TmmLabel lblFolderOldT = new TmmLabel(TmmResourceBundle.getString("renamer.oldfolder"));
        panelDetails.add((Component)lblFolderOldT, "cell 0 4");
        this.lblFolderOld = new JLabel("");
        panelDetails.add((Component)this.lblFolderOld, "cell 2 4,growx,aligny center");
        TmmLabel lblFolderNewT = new TmmLabel(TmmResourceBundle.getString("renamer.newfolder"));
        panelDetails.add((Component)lblFolderNewT, "cell 0 5");
        this.lblFolderNew = new JLabel("");
        panelDetails.add((Component)this.lblFolderNew, "cell 2 5,growx,aligny center");
        JPanel panelMediaFiles = new JPanel();
        panelDetails.add((Component)panelMediaFiles, "cell 0 7 3 1,grow");
        panelMediaFiles.setLayout((LayoutManager)new MigLayout("", "[grow][grow]", "[15px][grow]"));
        TmmLabel lblOldfilesT = new TmmLabel(TmmResourceBundle.getString("renamer.oldfiles"));
        panelMediaFiles.add((Component)lblOldfilesT, "cell 0 0,alignx center");
        TmmLabel lblNewfilesT = new TmmLabel(TmmResourceBundle.getString("renamer.newfiles"));
        panelMediaFiles.add((Component)lblNewfilesT, "cell 1 0,alignx center");
        TmmTable tableMediaFilesOld = new TmmTable((TableModel)((Object)new TmmTableModel<MediaFileContainer>((EventList<MediaFileContainer>)GlazedListsSwing.swingThreadProxyList(this.oldMediaFileEventList), new MediaFileTableFormat())));
        JScrollPane scrollPaneMediaFilesOld = new JScrollPane();
        tableMediaFilesOld.configureScrollPane(scrollPaneMediaFilesOld);
        panelMediaFiles.add((Component)scrollPaneMediaFilesOld, "cell 0 1,grow");
        tableMediaFilesOld.getColumnModel().getColumn(0).setMaxWidth(40);
        TmmTable tableMediaFilesNew = new TmmTable((TableModel)((Object)new TmmTableModel<MediaFileContainer>((EventList<MediaFileContainer>)GlazedListsSwing.swingThreadProxyList(this.newMediaFileEventList), new MediaFileTableFormat())));
        JScrollPane scrollPaneMediaFilesNew = new JScrollPane(tableMediaFilesNew);
        tableMediaFilesNew.configureScrollPane(scrollPaneMediaFilesNew);
        panelMediaFiles.add((Component)scrollPaneMediaFilesNew, "cell 1 1,grow");
        tableMediaFilesNew.getColumnModel().getColumn(0).setMaxWidth(40);
        this.cbFilter = new JCheckBox(TmmResourceBundle.getString("renamer.hideunchanged"));
        this.cbFilter.addActionListener(l -> this.resultSelectionModel.updateSelectedResult());
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("", "[]", "[]"));
        bottomPanel.add((Component)this.cbFilter, "cell 0 0");
        this.setBottomInformationPanel(bottomPanel);
        JButton btnRename = new JButton(TmmResourceBundle.getString("Button.rename"));
        btnRename.setToolTipText(TmmResourceBundle.getString("movie.rename"));
        btnRename.addActionListener(arg0 -> {
            ArrayList<Movie> selectedMovies1 = new ArrayList<Movie>();
            ArrayList<MovieRenamerPreviewContainer> selectedResults = new ArrayList<MovieRenamerPreviewContainer>(this.resultSelectionModel.selectedResults);
            for (MovieRenamerPreviewContainer result : selectedResults) {
                selectedMovies1.add(result.getMovie());
            }
            MovieRenameTask renameTask = new MovieRenameTask(selectedMovies1);
            TmmTaskManager.getInstance().addMainTask(renameTask);
            this.results.removeAll(selectedResults);
        });
        this.addButton(btnRename);
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
        this.worker = new MoviePreviewWorker(selectedMovies);
        this.worker.execute();
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        super.setVisible(visible);
    }

    private static class ResultTableFormat
    extends TmmTableFormat<MovieRenamerPreviewContainer> {
        public ResultTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.movie"), "title", container -> container.getMovie().getTitleSortable(), String.class);
            col.setCellTooltip(container -> container.getMovie().getTitleSortable());
            this.addColumn(col);
        }
    }

    private class ResultSelectionModel
    extends AbstractModelObject
    implements ListSelectionListener {
        private final MovieRenamerPreviewContainer emptyResult;
        private MovieRenamerPreviewContainer selectedResult;
        private List<MovieRenamerPreviewContainer> selectedResults;

        ResultSelectionModel() {
            this.selectedResult = this.emptyResult = new MovieRenamerPreviewContainer(new Movie());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSelectedResult() {
            MediaFileContainer container;
            boolean found;
            MovieRenamerPreviewDialog.this.lblTitle.setText(this.selectedResult.getMovie().getTitleSortable());
            MovieRenamerPreviewDialog.this.lblDatasource.setText(this.selectedResult.getMovie().getDataSource());
            if (this.selectedResult != this.emptyResult) {
                MovieRenamerPreviewDialog.this.lblFolderOld.setText(this.selectedResult.getOldPathRelative().toString());
                MovieRenamerPreviewDialog.this.lblFolderNew.setText(this.selectedResult.getNewPathRelative().toString());
            } else {
                MovieRenamerPreviewDialog.this.lblFolderOld.setText("");
                MovieRenamerPreviewDialog.this.lblFolderNew.setText("");
            }
            try {
                MovieRenamerPreviewDialog.this.oldMediaFileEventList.getReadWriteLock().writeLock().lock();
                MovieRenamerPreviewDialog.this.oldMediaFileEventList.clear();
                for (MediaFile mf : this.selectedResult.getOldMediaFiles()) {
                    found = false;
                    container = new MediaFileContainer();
                    container.filename = this.selectedResult.getNewPath().relativize(mf.getFileAsPath()).toString();
                    if (this.selectedResult.getNewMediaFiles().contains(mf)) {
                        found = true;
                    }
                    if (!found) {
                        container.icon = IconManager.REMOVE;
                    }
                    if (found && MovieRenamerPreviewDialog.this.cbFilter.isSelected()) continue;
                    MovieRenamerPreviewDialog.this.oldMediaFileEventList.add((Object)container);
                }
            }
            catch (Exception exception) {
            }
            finally {
                MovieRenamerPreviewDialog.this.oldMediaFileEventList.getReadWriteLock().writeLock().unlock();
            }
            try {
                MovieRenamerPreviewDialog.this.newMediaFileEventList.getReadWriteLock().writeLock().lock();
                MovieRenamerPreviewDialog.this.newMediaFileEventList.clear();
                for (MediaFile mf : this.selectedResult.getNewMediaFiles()) {
                    found = false;
                    container = new MediaFileContainer();
                    container.filename = this.selectedResult.getNewPath().relativize(mf.getFileAsPath()).toString();
                    if (this.selectedResult.getOldMediaFiles().contains(mf)) {
                        found = true;
                    }
                    if (!found) {
                        container.icon = IconManager.ADD;
                    }
                    if (found && MovieRenamerPreviewDialog.this.cbFilter.isSelected()) continue;
                    MovieRenamerPreviewDialog.this.newMediaFileEventList.add((Object)container);
                }
            }
            catch (Exception exception) {
            }
            finally {
                MovieRenamerPreviewDialog.this.newMediaFileEventList.getReadWriteLock().writeLock().unlock();
            }
        }

        synchronized void setSelectedResult(MovieRenamerPreviewContainer newValue) {
            this.selectedResult = newValue == null ? this.emptyResult : newValue;
            this.updateSelectedResult();
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            if (arg0.getValueIsAdjusting()) {
                return;
            }
            if (!this.selectedResults.isEmpty() && this.selectedResult != this.selectedResults.get(0)) {
                this.setSelectedResult(this.selectedResults.get(0));
            }
            if (this.selectedResults.isEmpty()) {
                this.setSelectedResult(this.emptyResult);
            }
        }
    }

    private static class MediaFileTableFormat
    extends TmmTableFormat<MediaFileContainer> {
        public MediaFileTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, "", "indicator", container -> container.icon, ImageIcon.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", container -> container.filename, String.class);
            col.setCellTooltip(container -> container.filename);
            this.addColumn(col);
        }
    }

    private class MoviePreviewWorker
    extends SwingWorker<Void, Void> {
        private final List<Movie> moviesToProcess;

        private MoviePreviewWorker(List<Movie> movies) {
            this.moviesToProcess = new ArrayList<Movie>(movies);
        }

        @Override
        protected Void doInBackground() {
            this.moviesToProcess.sort(new MovieComparator());
            for (Movie movie : this.moviesToProcess) {
                if (this.isCancelled()) {
                    return null;
                }
                MovieRenamerPreviewContainer container = MovieRenamerPreview.renameMovie(movie);
                if (!container.isNeedsRename()) continue;
                MovieRenamerPreviewDialog.this.results.add((Object)container);
            }
            SwingUtilities.invokeLater(() -> {
                if (MovieRenamerPreviewDialog.this.results.isEmpty()) {
                    JOptionPane.showMessageDialog(MovieRenamerPreviewDialog.this, TmmResourceBundle.getString("movie.renamerpreview.nothingtorename"));
                    MovieRenamerPreviewDialog.this.setVisible(false);
                }
            });
            return null;
        }
    }

    private static class MediaFileContainer {
        ImageIcon icon = null;
        String filename;

        private MediaFileContainer() {
        }
    }
}

