/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieGenreFilter
extends AbstractCheckComboBoxMovieUIFilter<MediaGenres> {
    private final Comparator<MediaGenres> comparator;
    private final MovieList movieList;

    public MovieGenreFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.movieList = MovieModuleManager.getInstance().getMovieList();
        this.comparator = new MediaGenres.MediaGenresComparator();
        this.buildAndInstallMediaGenres();
        this.movieList.addPropertyChangeListener("genre", evt -> SwingUtilities.invokeLater(this::buildAndInstallMediaGenres));
    }

    @Override
    public String getId() {
        return "movieGenre";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        if (selectedItems.isEmpty() && movie.getGenres().isEmpty()) {
            return true;
        }
        for (MediaGenres genre : movie.getGenres()) {
            if (!selectedItems.contains(genre)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.genre"));
    }

    private void buildAndInstallMediaGenres() {
        ArrayList<MediaGenres> usedGenres = new ArrayList<MediaGenres>(this.movieList.getUsedGenres());
        usedGenres.sort(this.comparator);
        this.setValues(usedGenres);
    }

    @Override
    protected String parseTypeToString(MediaGenres type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaGenres parseStringToType(String string) throws Exception {
        return MediaGenres.getGenre(string);
    }
}

