/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieVideoCodecFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieVideoCodecFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallCodecArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallCodecArray();
        this.movieList.addPropertyChangeListener("videoCodec", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "movieVideoCodec";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        return selectedValues.contains(movie.getMediaInfoVideoCodec());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.videocodec"));
    }

    private void buildAndInstallCodecArray() {
        ArrayList<String> codecs = new ArrayList<String>(this.movieList.getVideoCodecsInMovies());
        Collections.sort(codecs);
        this.setValues(codecs);
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

