/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.MovieTextMatcherList;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.JHintCheckBox;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.combobox.AutocompleteSupport;
import org.tinymediamanager.ui.components.label.JHintLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;

class MovieUiSettingsPanel
extends JPanel {
    private static final int COL_COUNT = 7;
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private AutocompleteComboBox<String> cbRating;
    private JCheckBox chckbxMovieTableTooltips;
    private JList listRatings;
    private JButton btnAddRating;
    private JButton btnRemoveRating;
    private JButton btnMoveRatingUp;
    private JButton btnMoveRatingDown;
    private JCheckBox chckbxShowPoster;
    private JCheckBox chckbxShowFanart;
    private JCheckBox chckbxShowBanner;
    private JCheckBox chckbxShowThumb;
    private JCheckBox chckbxShowClearlogo;
    private JCheckBox chckbxTitle;
    private JCheckBox chckbxSortableTitle;
    private JCheckBox chckbxOriginalTitle;
    private JCheckBox chckbxSortableOriginalTitle;
    private JCheckBox chckbxSortTitle;
    private JCheckBox chckbxUniversalNote;
    private JCheckBox chckbxUniversalFilename;
    private JCheckBox chckbxUniversalTags;
    private JCheckBox chckbxUniversalProductionCompany;
    private JCheckBox chckbxUniversalCountry;
    private JCheckBox chckbxUniversalLanguages;
    private JCheckBox chckbxUniversalActors;
    private JCheckBox chckbxUniversalProducers;
    private JCheckBox chckbxUniversalDirectors;
    private JCheckBox chckbxUniversalWriters;
    private JCheckBox chckbxUniversalPlot;
    private JCheckBox chckbxUniversalTagLine;
    private JCheckBox chckbxStoreFilter;
    private JCheckBox chckbxDisplayAllMissingMetadata;
    private JCheckBox chckbxDisplayAllMissingArtwork;
    private final Map<MovieScraperMetadataConfig, JCheckBox> metadataCheckBoxes = new LinkedHashMap<MovieScraperMetadataConfig, JCheckBox>();
    private final Map<MovieScraperMetadataConfig, JCheckBox> artworkCheckBoxes = new LinkedHashMap<MovieScraperMetadataConfig, JCheckBox>();
    private final ItemListener checkBoxListener = e -> this.checkChanges();

    public MovieUiSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnAddRating.addActionListener(arg0 -> {
            String str;
            JTextField tf;
            String selectedText;
            Object selectedItem = this.cbRating.getSelectedItem();
            Component editorComponent = this.cbRating.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            if (selectedItem instanceof String && StringUtils.isNotBlank((CharSequence)(str = (String)selectedItem))) {
                MovieModuleManager.getInstance().getSettings().addRatingSource(str);
                if (editorComponent instanceof JTextField) {
                    AutocompleteSupport<String> autoCompleteSupport = this.cbRating.getAutoCompleteSupport();
                    autoCompleteSupport.setFirstItem(null);
                    this.cbRating.setSelectedIndex(0);
                    autoCompleteSupport.removeFirstItem();
                }
            }
        });
        this.btnRemoveRating.addActionListener(arg0 -> {
            int row = this.listRatings.getSelectedIndex();
            if (row != -1) {
                String ratingSource = this.settings.getRatingSources().get(row);
                MovieModuleManager.getInstance().getSettings().removeRatingSource(ratingSource);
            }
        });
        this.btnMoveRatingUp.addActionListener(arg0 -> {
            int row = this.listRatings.getSelectedIndex();
            if (row != -1 && row != 0) {
                this.settings.swapRatingSources(row, row - 1);
                this.listRatings.setSelectedIndex(--row);
                this.listRatings.updateUI();
            }
        });
        this.btnMoveRatingDown.addActionListener(arg0 -> {
            int row = this.listRatings.getSelectedIndex();
            if (row != -1 && row < this.listRatings.getModel().getSize() - 1) {
                this.settings.swapRatingSources(row, row + 1);
                this.listRatings.setSelectedIndex(++row);
                this.listRatings.updateUI();
            }
        });
        this.buildCheckBoxes();
    }

    private void checkChanges() {
        JCheckBox value;
        MovieScraperMetadataConfig key;
        ArrayList<MediaFileType> artworkTypes = new ArrayList<MediaFileType>();
        if (this.chckbxShowPoster.isSelected()) {
            artworkTypes.add(MediaFileType.POSTER);
        }
        if (this.chckbxShowFanart.isSelected()) {
            artworkTypes.add(MediaFileType.FANART);
        }
        if (this.chckbxShowBanner.isSelected()) {
            artworkTypes.add(MediaFileType.BANNER);
        }
        if (this.chckbxShowThumb.isSelected()) {
            artworkTypes.add(MediaFileType.THUMB);
        }
        if (this.chckbxShowClearlogo.isSelected()) {
            artworkTypes.add(MediaFileType.CLEARLOGO);
        }
        this.settings.setShowArtworkTypes(artworkTypes);
        ArrayList<AbstractSettings.UniversalFilterFields> universalFilterFields = new ArrayList<AbstractSettings.UniversalFilterFields>();
        if (this.chckbxUniversalNote.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.NOTE);
        }
        if (this.chckbxUniversalFilename.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.FILENAME);
        }
        if (this.chckbxUniversalTags.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.TAGS);
        }
        if (this.chckbxUniversalCountry.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.COUNTRY);
        }
        if (this.chckbxUniversalProductionCompany.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.PRODUCTION_COMPANY);
        }
        if (this.chckbxUniversalLanguages.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.SPOKEN_LANGUAGE);
        }
        if (this.chckbxUniversalActors.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.ACTOR);
        }
        if (this.chckbxUniversalProducers.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.PRODUCER);
        }
        if (this.chckbxUniversalWriters.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.WRITER);
        }
        if (this.chckbxUniversalDirectors.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.DIRECTOR);
        }
        if (this.chckbxUniversalPlot.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.PLOT);
        }
        if (this.chckbxUniversalTagLine.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.TAGLINE);
        }
        this.settings.setUniversalFilterFields(universalFilterFields);
        this.settings.clearMovieCheckMetadata();
        for (Map.Entry<MovieScraperMetadataConfig, JCheckBox> entry : this.metadataCheckBoxes.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!value.isSelected()) continue;
            this.settings.addMovieCheckMetadata(key);
        }
        this.settings.clearMovieCheckArtwork();
        for (Map.Entry<MovieScraperMetadataConfig, JCheckBox> entry : this.artworkCheckBoxes.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!value.isSelected()) continue;
            this.settings.addMovieCheckArtwork(key);
        }
    }

    private void buildCheckBoxes() {
        JCheckBox checkBox;
        for (MediaFileType artworkType : this.settings.getShowArtworkTypes()) {
            switch (artworkType) {
                case POSTER: {
                    this.chckbxShowPoster.setSelected(true);
                    break;
                }
                case FANART: {
                    this.chckbxShowFanart.setSelected(true);
                    break;
                }
                case BANNER: {
                    this.chckbxShowBanner.setSelected(true);
                    break;
                }
                case THUMB: {
                    this.chckbxShowThumb.setSelected(true);
                    break;
                }
                case CLEARLOGO: {
                    this.chckbxShowClearlogo.setSelected(true);
                }
            }
        }
        for (AbstractSettings.UniversalFilterFields filterField : this.settings.getUniversalFilterFields()) {
            switch (filterField) {
                case NOTE: {
                    this.chckbxUniversalNote.setSelected(true);
                    break;
                }
                case FILENAME: {
                    this.chckbxUniversalFilename.setSelected(true);
                    break;
                }
                case TAGS: {
                    this.chckbxUniversalTags.setSelected(true);
                    break;
                }
                case PRODUCTION_COMPANY: {
                    this.chckbxUniversalProductionCompany.setSelected(true);
                    break;
                }
                case COUNTRY: {
                    this.chckbxUniversalCountry.setSelected(true);
                    break;
                }
                case SPOKEN_LANGUAGE: {
                    this.chckbxUniversalLanguages.setSelected(true);
                    break;
                }
                case ACTOR: {
                    this.chckbxUniversalActors.setSelected(true);
                    break;
                }
                case DIRECTOR: {
                    this.chckbxUniversalDirectors.setSelected(true);
                    break;
                }
                case PRODUCER: {
                    this.chckbxUniversalProducers.setSelected(true);
                    break;
                }
                case WRITER: {
                    this.chckbxUniversalWriters.setSelected(true);
                    break;
                }
                case PLOT: {
                    this.chckbxUniversalPlot.setSelected(true);
                    break;
                }
                case TAGLINE: {
                    this.chckbxUniversalTagLine.setSelected(true);
                }
            }
        }
        this.chckbxShowPoster.addItemListener(this.checkBoxListener);
        this.chckbxShowFanart.addItemListener(this.checkBoxListener);
        this.chckbxShowBanner.addItemListener(this.checkBoxListener);
        this.chckbxShowThumb.addItemListener(this.checkBoxListener);
        this.chckbxShowClearlogo.addItemListener(this.checkBoxListener);
        this.chckbxUniversalNote.addItemListener(this.checkBoxListener);
        this.chckbxUniversalFilename.addItemListener(this.checkBoxListener);
        this.chckbxUniversalTags.addItemListener(this.checkBoxListener);
        this.chckbxUniversalProductionCompany.addItemListener(this.checkBoxListener);
        this.chckbxUniversalCountry.addItemListener(this.checkBoxListener);
        this.chckbxUniversalLanguages.addItemListener(this.checkBoxListener);
        this.chckbxUniversalActors.addItemListener(this.checkBoxListener);
        this.chckbxUniversalProducers.addItemListener(this.checkBoxListener);
        this.chckbxUniversalDirectors.addItemListener(this.checkBoxListener);
        this.chckbxUniversalWriters.addItemListener(this.checkBoxListener);
        this.chckbxUniversalPlot.addItemListener(this.checkBoxListener);
        this.chckbxUniversalTagLine.addItemListener(this.checkBoxListener);
        for (MovieScraperMetadataConfig value : this.settings.getMovieCheckMetadata()) {
            checkBox = this.metadataCheckBoxes.get(value);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (JCheckBox checkBox2 : this.metadataCheckBoxes.values()) {
            checkBox2.addItemListener(this.checkBoxListener);
        }
        for (MovieScraperMetadataConfig value : this.settings.getMovieCheckArtwork()) {
            checkBox = this.artworkCheckBoxes.get(value);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (JCheckBox checkBox2 : this.artworkCheckBoxes.values()) {
            checkBox2.addItemListener(this.checkBoxListener);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][][15lp!][]"));
        JPanel panelUiSettings = new JPanel();
        panelUiSettings.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][10lp!][][grow][][][][][][10lp!][][125lp,grow]"));
        TmmLabel lblUiSettings = new TmmLabel(TmmResourceBundle.getString("Settings.ui"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelUiSettings, lblUiSettings, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#ui-settings"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        JLabel lblNewLabel = new JLabel(TmmResourceBundle.getString("Settings.showartworktypes"));
        panelUiSettings.add((Component)lblNewLabel, "cell 1 0 2 1");
        this.chckbxShowPoster = new JCheckBox(TmmResourceBundle.getString("mediafiletype.poster"));
        panelUiSettings.add((Component)this.chckbxShowPoster, "flowx,cell 2 1");
        this.chckbxShowFanart = new JCheckBox(TmmResourceBundle.getString("mediafiletype.fanart"));
        panelUiSettings.add((Component)this.chckbxShowFanart, "cell 2 1");
        this.chckbxShowBanner = new JCheckBox(TmmResourceBundle.getString("mediafiletype.banner"));
        panelUiSettings.add((Component)this.chckbxShowBanner, "cell 2 1");
        this.chckbxShowThumb = new JCheckBox(TmmResourceBundle.getString("mediafiletype.thumb"));
        panelUiSettings.add((Component)this.chckbxShowThumb, "cell 2 1");
        this.chckbxShowClearlogo = new JCheckBox(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        panelUiSettings.add((Component)this.chckbxShowClearlogo, "cell 2 1");
        this.chckbxMovieTableTooltips = new JCheckBox(TmmResourceBundle.getString("Settings.movie.showtabletooltips"));
        panelUiSettings.add((Component)this.chckbxMovieTableTooltips, "cell 1 2 2 1");
        JLabel lblCheckMetadata = new JLabel(TmmResourceBundle.getString("Settings.checkmetadata"));
        panelUiSettings.add((Component)lblCheckMetadata, "cell 1 4 2 1");
        JPanel panelCheckMetadata = new JPanel();
        panelCheckMetadata.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        gbc.ipadx = 10;
        for (MovieScraperMetadataConfig value : MovieScraperMetadataConfig.values()) {
            if (!value.isMetaData()) continue;
            this.addMetadataCheckbox(panelCheckMetadata, value, this.metadataCheckBoxes, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        for (MovieScraperMetadataConfig value : MovieScraperMetadataConfig.values()) {
            if (!value.isCast()) continue;
            this.addMetadataCheckbox(panelCheckMetadata, value, this.metadataCheckBoxes, gbc);
        }
        panelUiSettings.add((Component)panelCheckMetadata, "cell 2 5");
        this.chckbxDisplayAllMissingMetadata = new JHintCheckBox(TmmResourceBundle.getString("Settings.checkmetadata.displayall"));
        this.chckbxDisplayAllMissingMetadata.setToolTipText(TmmResourceBundle.getString("Settings.checkmetadata.displayall.desc"));
        panelUiSettings.add((Component)this.chckbxDisplayAllMissingMetadata, "cell 2 6");
        JLabel lblCheckImages = new JLabel(TmmResourceBundle.getString("Settings.checkimages"));
        panelUiSettings.add((Component)lblCheckImages, "cell 1 8 2 1");
        JPanel panelCheckImages = new JPanel();
        panelCheckImages.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        gbc.ipadx = 10;
        for (MovieScraperMetadataConfig value : MovieScraperMetadataConfig.values()) {
            if (!value.isArtwork()) continue;
            this.addMetadataCheckbox(panelCheckImages, value, this.artworkCheckBoxes, gbc);
        }
        panelUiSettings.add((Component)panelCheckImages, "cell 2 9");
        this.chckbxDisplayAllMissingArtwork = new JHintCheckBox(TmmResourceBundle.getString("Settings.checkimages.displayall"));
        this.chckbxDisplayAllMissingArtwork.setToolTipText(TmmResourceBundle.getString("Settings.checkimages.displayall.desc"));
        panelUiSettings.add((Component)this.chckbxDisplayAllMissingArtwork, "cell 2 10");
        JLabel lblRating = new JLabel(TmmResourceBundle.getString("Settings.preferredrating"));
        panelUiSettings.add((Component)lblRating, "cell 1 12 2 1");
        JPanel panelRatingSource = new JPanel();
        panelUiSettings.add((Component)panelRatingSource, "cell 2 13,grow");
        panelRatingSource.setLayout((LayoutManager)new MigLayout("insets 0", "[100lp][]", "[grow][]"));
        this.listRatings = new JList();
        this.listRatings.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.listRatings);
        panelRatingSource.add((Component)scrollPane, "cell 0 0,grow");
        this.btnMoveRatingUp = new SquareIconButton(IconManager.ARROW_UP_INV);
        this.btnMoveRatingUp.setToolTipText(TmmResourceBundle.getString("Button.moveup"));
        panelRatingSource.add((Component)this.btnMoveRatingUp, "flowy,cell 1 0,aligny bottom");
        this.btnMoveRatingDown = new SquareIconButton(IconManager.ARROW_DOWN_INV);
        this.btnMoveRatingDown.setToolTipText(TmmResourceBundle.getString("Button.movedown"));
        panelRatingSource.add((Component)this.btnMoveRatingDown, "cell 1 0,aligny bottom");
        this.cbRating = new AutocompleteComboBox<String>(Arrays.asList("imdb", "tmdb", "metacritic", "tomatometerallcritics", "user"));
        panelRatingSource.add(this.cbRating, "cell 0 1,growx");
        this.btnRemoveRating = new SquareIconButton(IconManager.REMOVE_INV);
        this.btnRemoveRating.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        panelRatingSource.add((Component)this.btnRemoveRating, "cell 1 0");
        this.btnAddRating = new SquareIconButton(IconManager.ADD_INV);
        this.btnAddRating.setToolTipText(TmmResourceBundle.getString("Button.add"));
        panelRatingSource.add((Component)this.btnAddRating, "cell 1 1");
        JPanel panelFilter = new JPanel();
        panelFilter.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][10lp!][]"));
        TmmLabel lblAutomaticTasksT = new TmmLabel(TmmResourceBundle.getString("Settings.filters"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelFilter, lblAutomaticTasksT, true);
        JLabel lblMovieFilter = new JLabel(TmmResourceBundle.getString("Settings.movietitlefilter"));
        panelFilter.add((Component)lblMovieFilter, "cell 1 0 2 1");
        this.chckbxTitle = new JCheckBox(MovieTextMatcherList.TITLE.toString());
        panelFilter.add((Component)this.chckbxTitle, "flowx,cell 2 1");
        this.chckbxSortableTitle = new JCheckBox(MovieTextMatcherList.TITLE_SORTABLE.toString());
        panelFilter.add((Component)this.chckbxSortableTitle, "cell 2 1");
        JLabel lblSortableTitleHint = new JLabel(IconManager.HINT);
        panelFilter.add((Component)lblSortableTitleHint, "cell 2 1");
        lblSortableTitleHint.setToolTipText(TmmResourceBundle.getString("Settings.movie.renamer.${titleSortable}"));
        this.chckbxOriginalTitle = new JCheckBox(MovieTextMatcherList.ORIGINAL_TITLE.toString());
        panelFilter.add((Component)this.chckbxOriginalTitle, "cell 2 1");
        this.chckbxSortableOriginalTitle = new JCheckBox(MovieTextMatcherList.ORIGINAL_TITLE_SORTABLE.toString());
        panelFilter.add((Component)this.chckbxSortableOriginalTitle, "cell 2 1");
        JLabel lblSortableOriginalTitleHint = new JLabel(IconManager.HINT);
        panelFilter.add((Component)lblSortableOriginalTitleHint, "cell 2 1");
        lblSortableOriginalTitleHint.setToolTipText(TmmResourceBundle.getString("Settings.movie.renamer.${titleSortable}"));
        this.chckbxSortTitle = new JCheckBox(MovieTextMatcherList.SORTED_TITLE.toString());
        panelFilter.add((Component)this.chckbxSortTitle, "cell 2 1");
        JHintLabel lblUniversalFilter = new JHintLabel(TmmResourceBundle.getString("filter.universal"));
        panelFilter.add((Component)lblUniversalFilter, "cell 1 2 2 1");
        lblUniversalFilter.setHintIcon(IconManager.HINT);
        lblUniversalFilter.setToolTipText(TmmResourceBundle.getString("filter.universal.hint"));
        this.chckbxUniversalNote = new JCheckBox(TmmResourceBundle.getString("metatag.note"));
        panelFilter.add((Component)this.chckbxUniversalNote, "flowx,cell 2 3");
        this.chckbxUniversalFilename = new JCheckBox(TmmResourceBundle.getString("metatag.filename"));
        panelFilter.add((Component)this.chckbxUniversalFilename, "cell 2 3");
        this.chckbxUniversalTags = new JCheckBox(TmmResourceBundle.getString("metatag.tags"));
        panelFilter.add((Component)this.chckbxUniversalTags, "cell 2 3");
        this.chckbxUniversalProductionCompany = new JCheckBox(TmmResourceBundle.getString("metatag.production"));
        panelFilter.add((Component)this.chckbxUniversalProductionCompany, "cell 2 3");
        this.chckbxUniversalCountry = new JCheckBox(TmmResourceBundle.getString("metatag.country"));
        panelFilter.add((Component)this.chckbxUniversalCountry, "cell 2 3");
        this.chckbxUniversalLanguages = new JCheckBox(TmmResourceBundle.getString("metatag.spokenlanguages"));
        panelFilter.add((Component)this.chckbxUniversalLanguages, "cell 2 3");
        this.chckbxUniversalActors = new JCheckBox(TmmResourceBundle.getString("metatag.actors"));
        panelFilter.add((Component)this.chckbxUniversalActors, "flowx,cell 2 4");
        this.chckbxUniversalProducers = new JCheckBox(TmmResourceBundle.getString("metatag.producers"));
        panelFilter.add((Component)this.chckbxUniversalProducers, "cell 2 4");
        this.chckbxUniversalDirectors = new JCheckBox(TmmResourceBundle.getString("metatag.directors"));
        panelFilter.add((Component)this.chckbxUniversalDirectors, "cell 2 4");
        this.chckbxUniversalWriters = new JCheckBox(TmmResourceBundle.getString("metatag.writers"));
        panelFilter.add((Component)this.chckbxUniversalWriters, "cell 2 4");
        this.chckbxUniversalPlot = new JCheckBox(TmmResourceBundle.getString("metatag.plot"));
        panelFilter.add((Component)this.chckbxUniversalPlot, "cell 2 4");
        this.chckbxUniversalTagLine = new JCheckBox(TmmResourceBundle.getString("metatag.tagline"));
        panelFilter.add((Component)this.chckbxUniversalTagLine, "cell 2 4");
        this.chckbxStoreFilter = new JCheckBox(TmmResourceBundle.getString("Settings.movie.persistuifilter"));
        panelFilter.add((Component)this.chckbxStoreFilter, "cell 1 6 2 1");
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#filter"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
    }

    private void addMetadataCheckbox(JPanel panel, MovieScraperMetadataConfig config, Map<MovieScraperMetadataConfig, JCheckBox> map, GridBagConstraints gbc) {
        JCheckBox checkBox;
        if (StringUtils.isNotBlank((CharSequence)config.getToolTip())) {
            checkBox = new JHintCheckBox(config.getDescription());
            checkBox.setToolTipText(config.getToolTip());
            ((JHintCheckBox)checkBox).setHintIcon(IconManager.HINT);
        } else {
            checkBox = new JCheckBox(config.getDescription());
        }
        map.put(config, checkBox);
        if (gbc.gridx >= 7) {
            gbc.gridx = 0;
            ++gbc.gridy;
        }
        panel.add((Component)checkBox, gbc);
        ++gbc.gridx;
    }

    protected void initDataBindings() {
        BeanProperty movieSettingsBeanProperty_13 = BeanProperty.create((String)"title");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_13, (Object)this.chckbxTitle, (Property)jCheckBoxBeanProperty);
        autoBinding_13.bind();
        BeanProperty movieSettingsBeanProperty_14 = BeanProperty.create((String)"sortableTitle");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_14, (Object)this.chckbxSortableTitle, (Property)jCheckBoxBeanProperty);
        autoBinding_14.bind();
        BeanProperty movieSettingsBeanProperty_15 = BeanProperty.create((String)"originalTitle");
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_15, (Object)this.chckbxOriginalTitle, (Property)jCheckBoxBeanProperty);
        autoBinding_15.bind();
        BeanProperty movieSettingsBeanProperty_16 = BeanProperty.create((String)"sortableOriginalTitle");
        AutoBinding autoBinding_16 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_16, (Object)this.chckbxSortableOriginalTitle, (Property)jCheckBoxBeanProperty);
        autoBinding_16.bind();
        BeanProperty movieSettingsBeanProperty_17 = BeanProperty.create((String)"sortTitle");
        AutoBinding autoBinding_17 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_17, (Object)this.chckbxSortTitle, (Property)jCheckBoxBeanProperty);
        autoBinding_17.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"ratingSources");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (JList)this.listRatings);
        jListBinding.bind();
        BeanProperty movieSettingsBeanProperty_5 = BeanProperty.create((String)"showMovieTableTooltips");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_5, (Object)this.chckbxMovieTableTooltips, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty movieSettingsBeanProperty_19 = BeanProperty.create((String)"storeUiFilters");
        AutoBinding autoBinding_21 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_19, (Object)this.chckbxStoreFilter, (Property)jCheckBoxBeanProperty);
        autoBinding_21.bind();
        BeanProperty movieSettingsBeanProperty_20 = BeanProperty.create((String)"movieDisplayAllMissingMetadata");
        AutoBinding autoBinding_24 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_20, (Object)this.chckbxDisplayAllMissingMetadata, (Property)jCheckBoxBeanProperty);
        autoBinding_24.bind();
        BeanProperty movieSettingsBeanProperty_21 = BeanProperty.create((String)"movieDisplayAllMissingArtwork");
        AutoBinding autoBinding_25 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_21, (Object)this.chckbxDisplayAllMissingArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_25.bind();
    }
}

