/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableFormat;
import org.tinymediamanager.ui.renderer.DateTableCellRenderer;
import org.tinymediamanager.ui.renderer.IntegerTableCellRenderer;
import org.tinymediamanager.ui.renderer.RightAlignTableCellRenderer;
import org.tinymediamanager.ui.renderer.RuntimeTableCellRenderer;

public class MovieSetTableFormat
extends TmmTreeTableFormat<TmmTreeNode> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieSetTableFormat() {
        FontMetrics fontMetrics = this.getFontMetrics();
        TmmTableFormat.IntegerComparator integerComparator = new TmmTableFormat.IntegerComparator();
        TmmTableFormat.ImageComparator imageComparator = new TmmTableFormat.ImageComparator();
        TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
        TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("movieset.moviecount"), "seasons", this::getMovieCount, Integer.class);
        col.setHeaderIcon(IconManager.COUNT);
        col.setCellRenderer(new IntegerTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("99") + this.getCellPadding());
        col.setColumnComparator(integerComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.year"), "year", this::getYear, String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("2000 - 2000") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", this::getVideoFilename, String.class);
        col.setColumnResizeable(true);
        col.setCellTooltip(this::getVideoFilename);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.path"), "path", this::getMoviePath, String.class);
        col.setColumnResizeable(true);
        col.setCellTooltip(this::getMoviePath);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.rating"), "rating", this::getRating, String.class);
        col.setHeaderIcon(IconManager.RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("99.9") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.userrating"), "userrating", this::getUserRating, String.class);
        col.setHeaderIcon(IconManager.RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("99.9") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.votes"), "votes", this::getVotes, Integer.class);
        col.setHeaderIcon(IconManager.VOTES);
        col.setCellRenderer(new IntegerTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("1000000") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.dateadded"), "dateAdded", this::getDateAdded, Date.class);
        col.setHeaderIcon(IconManager.DATE_ADDED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        try {
            Date date = DateUtils.parseDate("2012-12-12");
            col.setMinWidth(fontMetrics.stringWidth(TmmDateFormat.MEDIUM_DATE_FORMAT.format(date)) + this.getCellPadding());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.runtime") + " [min]", "runtime", this::getRuntime, Integer.class);
        col.setHeaderIcon(IconManager.RUNTIME);
        col.setCellRenderer(new RuntimeTableCellRenderer(RuntimeTableCellRenderer.FORMAT.MINUTES));
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("200") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.runtime") + " [hh:mm]", "runtime2", this::getRuntime, Integer.class);
        col.setHeaderIcon(IconManager.RUNTIME);
        col.setCellRenderer(new RuntimeTableCellRenderer(RuntimeTableCellRenderer.FORMAT.HOURS_MINUTES));
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("4:00") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.format"), "format", this::getMediaInfoVideoFormat, String.class);
        col.setHeaderIcon(IconManager.VIDEO_FORMAT);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("1080p") + this.getCellPadding());
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videocodec"), "videoCodec", this::getMediaInfoVideoCodec, String.class);
        col.setHeaderIcon(IconManager.VIDEO_CODEC);
        col.setMinWidth(fontMetrics.stringWidth("MPEG-2") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videobitrate"), "videoBitrate", this::getMediaInfoVideoBitrate, String.class);
        col.setHeaderIcon(IconManager.VIDEO_BITRATE);
        col.setMinWidth(fontMetrics.stringWidth("20000") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.audio"), "audio", this::getAudioInformation, String.class);
        col.setHeaderIcon(IconManager.AUDIO);
        col.setMinWidth(fontMetrics.stringWidth("DTS 7ch") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videofilesize"), "fileSize", this::getFileSize, String.class);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("50000M") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.totalfilesize"), "totalFileSize", this::getTotalFileSize, String.class);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("50000M") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.metadata"), "metadata", this::hasMetadata, ImageIcon.class);
        col.setHeaderIcon(IconManager.NFO);
        col.setColumnResizeable(false);
        col.setColumnComparator(imageComparator);
        col.setCellTooltip(this::hasMetadataTooltip);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.images"), "images", this::hasImages, ImageIcon.class);
        col.setHeaderIcon(IconManager.IMAGES);
        col.setColumnResizeable(false);
        col.setColumnComparator(imageComparator);
        col.setCellTooltip(this::hasImagesTooltip);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.watched"), "watched", this::isWatched, ImageIcon.class);
        col.setHeaderIcon(IconManager.WATCHED);
        col.setColumnResizeable(false);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
    }

    @Override
    public String getColumnName(int i) {
        if (i == -1) {
            return TmmResourceBundle.getString("metatag.title");
        }
        return super.getColumnName(i);
    }

    private Integer getMovieCount(TmmTreeNode node) {
        MovieSet movieSet;
        int size;
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet && (size = (movieSet = (MovieSet)userObject).getMovies().size()) > 0) {
            return size;
        }
        return null;
    }

    private String getRating(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if (userObject instanceof Movie && (mediaRating = ((MediaEntity)userObject).getRating()) != null && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getRating());
        }
        return null;
    }

    private String getFileSize(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return Utils.formatFileSizeForDisplay(movie.getVideoFilesize());
        }
        return null;
    }

    private String getTotalFileSize(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return Utils.formatFileSizeForDisplay(movie.getTotalFilesize());
        }
        return null;
    }

    private ImageIcon hasMetadata(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)userObject;
            return this.getCheckIcon(this.movieList.detectMissingMetadata(movieSet).isEmpty());
        }
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return this.getCheckIcon(this.movieList.detectMissingMetadata(movie).isEmpty());
        }
        return null;
    }

    private String hasMetadataTooltip(TmmTreeNode node) {
        if (!MovieModuleManager.getInstance().getSettings().isShowMovieSetTableTooltips()) {
            return null;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)userObject;
            ArrayList<MovieSetScraperMetadataConfig> values = new ArrayList<MovieSetScraperMetadataConfig>();
            if (MovieModuleManager.getInstance().getSettings().isMovieSetDisplayAllMissingMetadata()) {
                for (MovieSetScraperMetadataConfig config : MovieSetScraperMetadataConfig.values()) {
                    if (!config.isMetaData() && !config.isCast()) continue;
                    values.add(config);
                }
            } else {
                values.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetCheckMetadata());
            }
            return this.getMissingToolTip(this.movieList.detectMissingFields(movieSet, values));
        }
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            ArrayList<MovieScraperMetadataConfig> values = new ArrayList<MovieScraperMetadataConfig>();
            if (MovieModuleManager.getInstance().getSettings().isMovieDisplayAllMissingMetadata()) {
                for (MovieScraperMetadataConfig config : MovieScraperMetadataConfig.values()) {
                    if (!config.isMetaData() && !config.isCast()) continue;
                    values.add(config);
                }
            } else {
                values.addAll(MovieModuleManager.getInstance().getSettings().getMovieCheckMetadata());
            }
            return this.getMissingToolTip(this.movieList.detectMissingFields(movie, values));
        }
        return null;
    }

    private ImageIcon hasImages(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)userObject;
            return this.getCheckIcon(this.movieList.detectMissingArtwork(movieSet).isEmpty());
        }
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return this.getCheckIcon(this.movieList.detectMissingArtwork(movie).isEmpty());
        }
        return null;
    }

    private String hasImagesTooltip(TmmTreeNode node) {
        if (!MovieModuleManager.getInstance().getSettings().isShowMovieSetTableTooltips()) {
            return null;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)userObject;
            ArrayList<MovieSetScraperMetadataConfig> values = new ArrayList<MovieSetScraperMetadataConfig>();
            if (MovieModuleManager.getInstance().getSettings().isMovieSetDisplayAllMissingArtwork()) {
                for (MovieSetScraperMetadataConfig config : MovieSetScraperMetadataConfig.values()) {
                    if (!config.isArtwork()) continue;
                    values.add(config);
                }
            } else {
                values.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetCheckArtwork());
            }
            return this.getMissingToolTip(this.movieList.detectMissingFields(movieSet, values));
        }
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            ArrayList<MovieScraperMetadataConfig> values = new ArrayList<MovieScraperMetadataConfig>();
            if (MovieModuleManager.getInstance().getSettings().isMovieDisplayAllMissingArtwork()) {
                for (MovieScraperMetadataConfig config : MovieScraperMetadataConfig.values()) {
                    if (!config.isArtwork()) continue;
                    values.add(config);
                }
            } else {
                values.addAll(MovieModuleManager.getInstance().getSettings().getMovieCheckArtwork());
            }
            return this.getMissingToolTip(this.movieList.detectMissingFields(movie, values));
        }
        return null;
    }

    private ImageIcon isWatched(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)userObject;
            return this.getCheckIcon(movieSet.isWatched());
        }
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return this.getCheckIcon(movie.isWatched());
        }
        return null;
    }

    private Integer getRuntime(TmmTreeNode node) {
        Movie movie;
        int runtime;
        Object userObject = node.getUserObject();
        if (userObject instanceof Movie && (runtime = (movie = (Movie)userObject).getRuntime()) > 0) {
            return runtime;
        }
        return null;
    }

    private String getYear(TmmTreeNode node) {
        Movie movie;
        int year;
        MovieSet movieSet;
        String years;
        Object userobject = node.getUserObject();
        if (userobject instanceof MovieSet && StringUtils.isNotBlank((CharSequence)(years = (movieSet = (MovieSet)userobject).getYears()))) {
            return years;
        }
        if (userobject instanceof Movie && (year = (movie = (Movie)userobject).getYear()) > 0) {
            return String.valueOf(year);
        }
        return null;
    }

    private String getMediaInfoVideoFormat(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return movie.getMediaInfoVideoFormat();
        }
        return null;
    }

    private String getMediaInfoVideoCodec(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return movie.getMediaInfoVideoCodec();
        }
        return null;
    }

    private String getMediaInfoVideoBitrate(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return String.valueOf(movie.getMediaInfoVideoBitrate());
        }
        return null;
    }

    private String getUserRating(TmmTreeNode node) {
        Movie movie;
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie && (mediaRating = (movie = (Movie)userObject).getUserRating()) != null && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getRating());
        }
        return null;
    }

    private Integer getVotes(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return movie.getRating().getVotes();
        }
        return null;
    }

    private Date getDateAdded(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return movie.getDateAddedForUi();
        }
        return null;
    }

    private String getAudioInformation(TmmTreeNode node) {
        MediaFile mediaFile;
        Movie movie;
        List<MediaFile> videos;
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie && !(videos = (movie = (Movie)userObject).getMediaFiles(MediaFileType.VIDEO)).isEmpty() && StringUtils.isNotBlank((CharSequence)(mediaFile = videos.get(0)).getAudioCodec())) {
            return mediaFile.getAudioCodec() + " " + mediaFile.getAudioChannels();
        }
        return null;
    }

    private String getMoviePath(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return movie.getPathNIO().toString();
        }
        return null;
    }

    private String getVideoFilename(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            return movie.getMainVideoFile().getFilename();
        }
        return null;
    }

    private String getMissingToolTip(List<? extends ScraperMetadataConfig> missingValues) {
        if (!missingValues.isEmpty()) {
            StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
            for (ScraperMetadataConfig scraperMetadataConfig : missingValues) {
                missing.append("\n").append(scraperMetadataConfig.getDescription());
            }
            return missing.toString();
        }
        return null;
    }
}

