/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetToggleWatchedFlagAction
extends TmmAction {
    public MovieSetToggleWatchedFlagAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.togglewatchedflag"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = new ArrayList<Movie>(MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if ((selectedMovies = selectedMovies.stream().filter(movie -> !(movie instanceof MovieSet.MovieSetMovie)).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        for (Movie movie2 : selectedMovies) {
            movie2.setWatched(!movie2.isWatched());
            movie2.writeNFO();
            movie2.saveToDb();
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

