/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowFetchRatingsTask;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowFetchRatingsDialog;

public class TvShowFetchRatingsAction
extends TmmAction {
    public TvShowFetchRatingsAction() {
        this.putValue("SwingLargeIconKey", IconManager.RATING_BLUE);
        this.putValue("SmallIcon", IconManager.RATING_BLUE);
        this.putValue("Name", TmmResourceBundle.getString("tvshow.fetchratings"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects(false, false);
        Set<TvShow> tvShows = selectedObjects.getTvShows();
        Set<TvShowEpisode> episodes = selectedObjects.getEpisodesRecursive();
        if (tvShows.isEmpty() && episodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TvShowFetchRatingsDialog dialog = new TvShowFetchRatingsDialog();
        dialog.setVisible(true);
        List<RatingProvider.RatingSource> sources = dialog.getSelectedRatingSources();
        if (!sources.isEmpty()) {
            TmmTaskManager.getInstance().addUnnamedTask(new TvShowFetchRatingsTask(tvShows, episodes, sources));
        }
    }
}

