/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.tasks.TvShowReloadMediaInformationTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowMediaInformationAction
extends TmmAction {
    public TvShowMediaInformationAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.updatemediainfo"));
        this.putValue("SmallIcon", IconManager.MEDIAINFO);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.updatemediainfo"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        TvShowReloadMediaInformationTask task = new TvShowReloadMediaInformationTask(selectedObjects.getTvShows(), selectedObjects.getEpisodesRecursive());
        TmmTaskManager.getInstance().addMainTask(task);
    }
}

