/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import com.floreysoft.jmte.Engine;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.tabbedpane.TmmTabbedPane;
import org.tinymediamanager.ui.components.table.MediaRatingTable;
import org.tinymediamanager.ui.components.table.NullSelectionModel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPane;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.panels.MediaFileSubtitleEditorPanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;
import org.tinymediamanager.ui.panels.PersonEditorPanel;
import org.tinymediamanager.ui.panels.RatingEditorPanel;

public class TvShowBulkEditorDialog
extends TmmDialog {
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final Collection<TvShow> tvShowsToEdit;
    private final Collection<TvShowEpisode> tvShowEpisodesToEdit;
    private JComboBox<BulkEditorProperty> cbTvShowProperty;
    private JComboBox<BulkEditorProperty> cbEpisodeProperty;
    private final EventList<TvShowValues> tvShowValuesEventList;
    private final EventList<EpisodeValues> episodeValuesEventList;
    private boolean episodesChanged = false;
    private boolean tvShowsChanged = false;

    public TvShowBulkEditorDialog(Collection<TvShow> tvShows, Collection<TvShowEpisode> episodes) {
        super(TmmResourceBundle.getString("tvshow.bulkedit"), "tvShowBulkEditor");
        this.tvShowsToEdit = tvShows;
        this.tvShowEpisodesToEdit = episodes;
        this.tvShowValuesEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(TvShowValues.class)));
        this.episodeValuesEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(EpisodeValues.class)));
        this.initComponents();
        for (TvShow tvShow : this.tvShowsToEdit) {
            TvShowValues tvShowValues = new TvShowValues(tvShow);
            tvShowValues.changeProperty(((BulkEditorProperty)this.cbTvShowProperty.getSelectedItem()).property);
            this.tvShowValuesEventList.add((Object)tvShowValues);
        }
        for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
            EpisodeValues episodeValues = new EpisodeValues(episode);
            episodeValues.changeProperty(((BulkEditorProperty)this.cbEpisodeProperty.getSelectedItem()).property);
            this.episodeValuesEventList.add((Object)episodeValues);
        }
    }

    private void initComponents() {
        TmmTabbedPane tabbedPane = new TmmTabbedPane();
        this.getContentPane().add((Component)tabbedPane, "Center");
        JPanel panelContent = new JPanel();
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][200lp:350lp,grow][]", "[][][][][][][][]"));
        tabbedPane.add(TmmResourceBundle.getString("metatag.tvshow"), panelContent);
        TmmLabel lblGenres = new TmmLabel(TmmResourceBundle.getString("metatag.genre"));
        panelContent.add((Component)lblGenres, "cell 0 0,alignx right");
        AutocompleteComboBox<MediaGenres> cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        panelContent.add(cbGenres, "cell 1 0,growx,wmin 0");
        cbGenres.setEditable(true);
        SquareIconButton btnAddGenre = new SquareIconButton(IconManager.ADD_INV);
        panelContent.add((Component)btnAddGenre, "flowx,cell 2 0");
        btnAddGenre.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = null;
            Object item = cbGenres.getSelectedItem();
            if (item instanceof MediaGenres) {
                MediaGenres mediaGenres;
                genre = mediaGenres = (MediaGenres)item;
            } else if (item instanceof String) {
                String string = (String)item;
                genre = MediaGenres.getGenre(string);
            }
            if (genre != null) {
                for (TvShow tvShow : this.tvShowsToEdit) {
                    tvShow.addToGenres(Collections.singletonList(genre));
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        SquareIconButton btnRemoveGenre = new SquareIconButton(IconManager.REMOVE_INV);
        panelContent.add((Component)btnRemoveGenre, "cell 2 0");
        btnRemoveGenre.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = (MediaGenres)cbGenres.getSelectedItem();
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.removeGenre(genre);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblTags = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        panelContent.add((Component)lblTags, "cell 0 1,alignx right");
        AutocompleteComboBox<String> cbTags = new AutocompleteComboBox<String>(ListUtils.asSortedList(this.tvShowList.getTagsInTvShows()));
        panelContent.add(cbTags, "cell 1 1,growx,wmin 0");
        cbTags.setEditable(true);
        SquareIconButton btnAddTag = new SquareIconButton(IconManager.ADD_INV);
        panelContent.add((Component)btnAddTag, "flowx,cell 2 1");
        btnAddTag.addActionListener(e -> {
            this.tvShowsChanged = true;
            Object selectedItem = cbTags.getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            String tag = (String)selectedItem;
            if (StringUtils.isBlank((CharSequence)tag)) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.addToTags(Collections.singletonList(tag));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        SquareIconButton btnRemoveTag = new SquareIconButton(IconManager.REMOVE_INV);
        panelContent.add((Component)btnRemoveTag, "cell 2 1");
        btnRemoveTag.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTags.getSelectedItem();
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.removeFromTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblCountry = new TmmLabel(TmmResourceBundle.getString("metatag.country"));
        panelContent.add((Component)lblCountry, "cell 0 2,alignx right");
        JTextField tfCountry = new JTextField();
        panelContent.add((Component)tfCountry, "cell 1 2,growx,wmin 0");
        SquareIconButton btnChgCountry = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnChgCountry, "flowx,cell 2 2");
        btnChgCountry.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setCountry(tfCountry.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblStudio = new TmmLabel(TmmResourceBundle.getString("metatag.studio"));
        panelContent.add((Component)lblStudio, "cell 0 3,alignx right");
        JTextField tfStudio = new JTextField();
        panelContent.add((Component)tfStudio, "cell 1 3,growx,wmin 0");
        SquareIconButton btnChgStudio = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnChgStudio, "flowx,cell 2 3");
        btnChgStudio.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setProductionCompany(tfStudio.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblTvShowNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        panelContent.add((Component)lblTvShowNoteT, "cell 0 4,alignx right");
        JTextField tfTvShowNote = new JTextField();
        panelContent.add((Component)tfTvShowNote, "cell 1 4,growx");
        SquareIconButton btnTvShowNote = new SquareIconButton(IconManager.APPLY_INV);
        btnTvShowNote.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setNote(tfTvShowNote.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnTvShowNote, "cell 2 4");
        TmmLabel lblCertificationT = new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
        panelContent.add((Component)lblCertificationT, "cell 0 5, alignx right");
        JComboBox<MediaCertification> cbCertification = new JComboBox<MediaCertification>();
        for (MediaCertification cert : MediaCertification.getCertificationsforCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry())) {
            cbCertification.addItem(cert);
        }
        panelContent.add(cbCertification, "cell 1 5, growx");
        MediaAiredStatus[] btnCertification = new SquareIconButton(IconManager.APPLY_INV);
        btnCertification.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaCertification cert = (MediaCertification)((Object)((Object)cbCertification.getSelectedItem()));
            for (TvShow tvshow : this.tvShowsToEdit) {
                tvshow.setCertification(cert);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnCertification, "cell 2 5");
        TmmLabel lblStatus = new TmmLabel(TmmResourceBundle.getString("metatag.status"));
        panelContent.add((Component)lblStatus, "cell 0 6,alignx right");
        JComboBox<MediaAiredStatus> cbStatus = new JComboBox<MediaAiredStatus>();
        for (MediaAiredStatus s : MediaAiredStatus.values()) {
            cbStatus.addItem(s);
        }
        panelContent.add(cbStatus, "cell 1 6,growx");
        SquareIconButton btnStatus = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnStatus, "cell 2 6");
        btnStatus.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaAiredStatus status = (MediaAiredStatus)((Object)((Object)cbStatus.getSelectedItem()));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setStatus(status);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblDateAddedT = new TmmLabel(TmmResourceBundle.getString("metatag.dateadded"));
        panelContent.add((Component)lblDateAddedT, "cell 0 7,alignx right");
        JSpinner spDateAdded = new JSpinner(new SpinnerDateModel());
        panelContent.add((Component)spDateAdded, "cell 1 7");
        SquareIconButton btnDateAdded = new SquareIconButton(IconManager.APPLY_INV);
        btnDateAdded.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setDateAdded((Date)spDateAdded.getValue());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnDateAdded, "cell 2 7");
        JButton btnAddRating = new JButton(TmmResourceBundle.getString("rating.add"));
        panelContent.add((Component)btnAddRating, "cell 1 8");
        btnAddRating.addActionListener(e -> {
            MediaRatingTable.Rating rating = new MediaRatingTable.Rating("");
            rating.maxValue = 10;
            rating.votes = 1;
            ModalPopupPanel popupPanel = this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("rating.add"));
            popupPanel.setOnCloseHandler(() -> {
                if (StringUtils.isNotBlank((CharSequence)rating.key) && rating.value > 0.0f && rating.maxValue > 0 && rating.votes > 0) {
                    this.tvShowsChanged = true;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShow tvShow : this.tvShowsToEdit) {
                        MediaRating mr = new MediaRating(rating.key);
                        mr.setVotes(rating.votes);
                        mr.setRating(rating.value);
                        mr.setMaxValue(rating.maxValue);
                        tvShow.setRating(mr);
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            RatingEditorPanel ratingEditorPanel = new RatingEditorPanel(rating);
            popupPanel.setContent(ratingEditorPanel);
            this.showModalPopupPanel(popupPanel);
        });
        panelContent = new JPanel();
        tabbedPane.addTab(TmmResourceBundle.getString("metatag.tvshow") + " - " + TmmResourceBundle.getString("bulkedit.expert"), panelContent);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][100lp:200lp,grow]", "[grow][20lp!][][50lp][][20lp!][200lp:250lp,grow]"));
        ReadOnlyTextPane tpDescription = new ReadOnlyTextPane(TmmResourceBundle.getString("bulkedit.description"));
        panelContent.add((Component)tpDescription, "cell 0 0 2 1,grow");
        TmmLabel lblPropertyT = new TmmLabel(TmmResourceBundle.getString("bulkedit.field"));
        panelContent.add((Component)lblPropertyT, "cell 0 2,alignx right");
        this.cbTvShowProperty = new JComboBox();
        this.cbTvShowProperty.addItem(new BulkEditorProperty("title", TmmResourceBundle.getString("metatag.title")));
        this.cbTvShowProperty.addItem(new BulkEditorProperty("originalTitle", TmmResourceBundle.getString("metatag.originaltitle")));
        this.cbTvShowProperty.addItem(new BulkEditorProperty("sortTitle", TmmResourceBundle.getString("metatag.sorttitle")));
        this.cbTvShowProperty.addItem(new BulkEditorProperty("plot", TmmResourceBundle.getString("metatag.plot")));
        this.cbTvShowProperty.addItem(new BulkEditorProperty("productionCompany", TmmResourceBundle.getString("metatag.production")));
        this.cbTvShowProperty.addItem(new BulkEditorProperty("country", TmmResourceBundle.getString("metatag.country")));
        this.cbTvShowProperty.addItem(new BulkEditorProperty("note", TmmResourceBundle.getString("metatag.note")));
        this.cbTvShowProperty.addItemListener(e -> this.tvShowValuesEventList.forEach(tvShowValues -> tvShowValues.changeProperty(((BulkEditorProperty)this.cbTvShowProperty.getSelectedItem()).property)));
        panelContent.add(this.cbTvShowProperty, "cell 1 2,growx,wmin 0");
        TmmLabel lblPatternT = new TmmLabel(TmmResourceBundle.getString("bulkedit.value"));
        panelContent.add((Component)lblPatternT, "cell 0 3,alignx right");
        final JTextArea taPattern = new JTextArea();
        taPattern.setBorder(UIManager.getBorder("ScrollPane.border"));
        taPattern.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changePattern();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changePattern();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changePattern();
            }

            private void changePattern() {
                TvShowBulkEditorDialog.this.tvShowValuesEventList.forEach(tvShowValues -> tvShowValues.changePattern(taPattern.getText()));
            }
        });
        taPattern.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                taPattern.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                taPattern.repaint();
            }
        });
        panelContent.add((Component)taPattern, "flowx,cell 1 3,wmin 0,grow");
        JButton btnApply = new JButton(TmmResourceBundle.getString("Button.apply"));
        btnApply.setIcon(IconManager.APPLY_INV);
        btnApply.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.tvShowValuesEventList.forEach(TvShowValues::applyValue);
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnApply, "cell 1 4,alignx right");
        TmmTable tableValues = new TmmTable((TableModel)((Object)new TmmTableModel<TvShowValues>(this.tvShowValuesEventList, new TvShowValuesTableFormat())));
        tableValues.setSelectionModel(new NullSelectionModel());
        JScrollPane scrollPane = new JScrollPane();
        tableValues.configureScrollPane(scrollPane);
        panelContent.add((Component)scrollPane, "cell 0 6 2 1,grow");
        scrollPane.setViewportView(tableValues);
        panelContent = new JPanel();
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][200lp:350lp,grow][]", "[][][][][][][][][][][]"));
        tabbedPane.add(TmmResourceBundle.getString("metatag.episode"), panelContent);
        ReadOnlyTextArea textArea = new ReadOnlyTextArea(TmmResourceBundle.getString("tvshow.bulkedit.episodesfromshows"));
        textArea.setWrapStyleWord(true);
        panelContent.add((Component)textArea, "cell 0 0 2 1,wmin 0,grow");
        TmmLabel lblWatched = new TmmLabel(TmmResourceBundle.getString("metatag.watched"));
        panelContent.add((Component)lblWatched, "cell 0 1,alignx right");
        JCheckBox chckbxWatched = new JCheckBox("");
        panelContent.add((Component)chckbxWatched, "cell 1 1");
        SquareIconButton btnWatched = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnWatched, "cell 2 1");
        btnWatched.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                if (chckbxWatched.isSelected()) {
                    episode.setWatched(true);
                    if (episode.getPlaycount() != 0) continue;
                    episode.setPlaycount(1);
                    episode.setLastWatched(new Date());
                    continue;
                }
                episode.setWatched(false);
                episode.setPlaycount(0);
                episode.setLastWatched(null);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblSeason = new TmmLabel(TmmResourceBundle.getString("metatag.season"));
        panelContent.add((Component)lblSeason, "cell 0 2,alignx right");
        JSpinner spSeason = new JSpinner();
        spSeason.setModel(new SpinnerNumberModel(0, -1, 9999, 1));
        panelContent.add((Component)spSeason, "cell 1 2");
        SquareIconButton btnSeason = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnSeason, "cell 2 2");
        btnSeason.addActionListener(arg0 -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                Integer season = (Integer)spSeason.getValue();
                MediaEpisodeGroup episodeGroup = episode.getTvShow().getEpisodeGroup();
                if (episodeGroup == null) continue;
                MediaEpisodeNumber existingEpisodeNumber = episode.getEpisodeNumber(episodeGroup);
                if (existingEpisodeNumber != null) {
                    episode.setEpisode(new MediaEpisodeNumber(episodeGroup, season, existingEpisodeNumber.episode()));
                    continue;
                }
                episode.setEpisode(new MediaEpisodeNumber(episodeGroup, season, -1));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblTagsEpisode = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        panelContent.add((Component)lblTagsEpisode, "cell 0 5,alignx right");
        AutocompleteComboBox<Object> cbTagsEpisode = new AutocompleteComboBox<Object>(this.tvShowList.getTagsInEpisodes().toArray());
        panelContent.add(cbTagsEpisode, "cell 1 5,growx,wmin 0");
        cbTagsEpisode.setEditable(true);
        SquareIconButton btnAddTagEpisode = new SquareIconButton(IconManager.ADD_INV);
        panelContent.add((Component)btnAddTagEpisode, "flowx,cell 2 5");
        btnAddTagEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            Object selectedItem = cbTagsEpisode.getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            String tag = (String)selectedItem;
            if (StringUtils.isBlank((CharSequence)tag)) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.addToTags(Collections.singletonList(tag));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        SquareIconButton btnRemoveTagEpisode = new SquareIconButton(IconManager.REMOVE_INV);
        panelContent.add((Component)btnRemoveTagEpisode, "cell 2 5");
        btnRemoveTagEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTagsEpisode.getSelectedItem();
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.removeFromTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblMediasourceEpisode = new TmmLabel(TmmResourceBundle.getString("metatag.source"));
        panelContent.add((Component)lblMediasourceEpisode, "cell 0 6,alignx right");
        JComboBox<MediaSource> cbMediaSourceEpisode = new JComboBox<MediaSource>(MediaSource.values());
        panelContent.add(cbMediaSourceEpisode, "cell 1 6,growx,wmin 0");
        SquareIconButton btnMediaSourceEpisode = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnMediaSourceEpisode, "cell 2 6");
        btnMediaSourceEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            Object obj = cbMediaSourceEpisode.getSelectedItem();
            if (obj instanceof MediaSource) {
                MediaSource mediaSource = (MediaSource)obj;
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                    episode.setMediaSource(mediaSource);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        TmmLabel lblEpisodeNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        panelContent.add((Component)lblEpisodeNoteT, "cell 0 7,alignx right");
        JTextField tfEpisodeNote = new JTextField();
        panelContent.add((Component)tfEpisodeNote, "cell 1 7,growx");
        SquareIconButton btnEpisodeNote = new SquareIconButton(IconManager.APPLY_INV);
        btnEpisodeNote.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.setNote(tfEpisodeNote.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnEpisodeNote, "cell 2 7");
        TmmLabel lblEpisodePlotT = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        panelContent.add((Component)lblEpisodePlotT, "cell 0 8,alignx right");
        JTextField tfEpisodePlot = new JTextField();
        panelContent.add((Component)tfEpisodePlot, "cell 1 8,growx");
        SquareIconButton btnEpisodePlot = new SquareIconButton(IconManager.APPLY_INV);
        btnEpisodePlot.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.setPlot(tfEpisodePlot.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnEpisodePlot, "cell 2 8");
        TmmLabel lblDateAdded = new TmmLabel(TmmResourceBundle.getString("metatag.dateadded"));
        panelContent.add((Component)lblDateAdded, "cell 0 9,alignx right");
        JSpinner spDateAdded2 = new JSpinner(new SpinnerDateModel());
        panelContent.add((Component)spDateAdded2, "cell 1 9");
        SquareIconButton btnDateAdded2 = new SquareIconButton(IconManager.APPLY_INV);
        btnDateAdded2.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.setDateAdded((Date)spDateAdded2.getValue());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnDateAdded2, "cell 2 9");
        JButton btnAddActors = new JButton(TmmResourceBundle.getString("cast.actor.add"));
        panelContent.add((Component)btnAddActors, "cell 1 10");
        btnAddActors.addActionListener(e -> {
            Person person = new Person(Person.Type.ACTOR, TmmResourceBundle.getString("cast.actor.unknown"), TmmResourceBundle.getString("cast.role.unknown"));
            ModalPopupPanel popupPanel = this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("cast.actor.add"));
            popupPanel.setOnCloseHandler(() -> {
                if (StringUtils.isNotBlank((CharSequence)person.getName()) && !person.getName().equals(TmmResourceBundle.getString("cast.actor.unknown"))) {
                    if (person.getRole().equals(TmmResourceBundle.getString("cast.role.unknown"))) {
                        person.setRole("");
                    }
                    this.episodesChanged = true;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                        ArrayList<Person> actors = new ArrayList<Person>();
                        actors.add(new Person(person));
                        episode.addToActors(actors);
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            PersonEditorPanel personEditorPanel = new PersonEditorPanel(person);
            popupPanel.setContent(personEditorPanel);
            this.showModalPopupPanel(popupPanel);
        });
        JButton btnAddDirectors = new JButton(TmmResourceBundle.getString("cast.director.add"));
        panelContent.add((Component)btnAddDirectors, "cell 1 10");
        btnAddDirectors.addActionListener(e -> {
            Person person = new Person(Person.Type.DIRECTOR, TmmResourceBundle.getString("director.name.unknown"), "Director");
            ModalPopupPanel popupPanel = this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("cast.director.add"));
            popupPanel.setOnCloseHandler(() -> {
                if (StringUtils.isNotBlank((CharSequence)person.getName()) && !person.getName().equals(TmmResourceBundle.getString("director.name.unknown"))) {
                    if (person.getRole().equals(TmmResourceBundle.getString("cast.role.unknown"))) {
                        person.setRole("");
                    }
                    this.episodesChanged = true;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                        ArrayList<Person> directors = new ArrayList<Person>();
                        directors.add(new Person(person));
                        episode.addToDirectors(directors);
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            PersonEditorPanel personEditorPanel = new PersonEditorPanel(person);
            popupPanel.setContent(personEditorPanel);
            this.showModalPopupPanel(popupPanel);
        });
        JButton btnAddRating2 = new JButton(TmmResourceBundle.getString("rating.add"));
        panelContent.add((Component)btnAddRating2, "cell 1 11");
        btnAddRating2.addActionListener(e -> {
            MediaRatingTable.Rating rating = new MediaRatingTable.Rating("");
            rating.maxValue = 10;
            rating.votes = 1;
            ModalPopupPanel popupPanel = this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("rating.add"));
            popupPanel.setOnCloseHandler(() -> {
                if (StringUtils.isNotBlank((CharSequence)rating.key) && rating.value > 0.0f && rating.maxValue > 0 && rating.votes > 0) {
                    this.episodesChanged = true;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                        MediaRating mr = new MediaRating(rating.key);
                        mr.setVotes(rating.votes);
                        mr.setRating(rating.value);
                        mr.setMaxValue(rating.maxValue);
                        episode.setRating(mr);
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            RatingEditorPanel ratingEditorPanel = new RatingEditorPanel(rating);
            popupPanel.setContent(ratingEditorPanel);
            this.showModalPopupPanel(popupPanel);
        });
        JButton btnAddSubtitle = new JButton(TmmResourceBundle.getString("subtitle.add"));
        panelContent.add((Component)btnAddSubtitle, "cell 1 11");
        btnAddSubtitle.addActionListener(e -> {
            MediaFileSubtitle subtitle = new MediaFileSubtitle();
            ModalPopupPanel popupPanel = this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("subtitle.add"));
            popupPanel.setOnCloseHandler(() -> {
                this.episodesChanged = true;
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                    episode.getMainFile().addSubtitle(subtitle);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            });
            MediaFileSubtitleEditorPanel subtitleEditorPanel = new MediaFileSubtitleEditorPanel(subtitle);
            popupPanel.setContent(subtitleEditorPanel);
            this.showModalPopupPanel(popupPanel);
        });
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.setIcon(IconManager.APPLY_INV);
        btnClose.addActionListener(arg0 -> {
            if (this.tvShowsChanged) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShow tvShow : this.tvShowsToEdit) {
                    tvShow.writeNFO();
                    tvShow.saveToDb();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (this.episodesChanged) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode tvShowEpisode : this.tvShowEpisodesToEdit) {
                    tvShowEpisode.writeNFO();
                    tvShowEpisode.saveToDb();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (TvShowModuleManager.getInstance().getSettings().getSyncTrakt()) {
                HashSet<TvShow> tvShows1 = new HashSet<TvShow>();
                for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                    tvShows1.add(episode.getTvShow());
                }
                tvShows1.addAll(this.tvShowsToEdit);
                TvShowSyncTraktTvTask tvShowSyncTraktTvTask = new TvShowSyncTraktTvTask(new ArrayList<TvShow>(tvShows1));
                tvShowSyncTraktTvTask.setSyncCollection(TvShowModuleManager.getInstance().getSettings().getSyncTraktCollection());
                tvShowSyncTraktTvTask.setSyncWatched(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
                tvShowSyncTraktTvTask.setSyncRating(TvShowModuleManager.getInstance().getSettings().getSyncTraktRating());
                TmmTaskManager.getInstance().addUnnamedTask(tvShowSyncTraktTvTask);
            }
            this.setVisible(false);
        });
        this.addDefaultButton(btnClose);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TvShowBulkEditorDialog.this.tvShowsChanged) {
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShow tvShow : TvShowBulkEditorDialog.this.tvShowsToEdit) {
                        tvShow.writeNFO();
                        tvShow.saveToDb();
                    }
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (TvShowBulkEditorDialog.this.episodesChanged) {
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShowEpisode episode : TvShowBulkEditorDialog.this.tvShowEpisodesToEdit) {
                        episode.writeNFO();
                        episode.saveToDb();
                    }
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        panelContent = new JPanel();
        tabbedPane.addTab(TmmResourceBundle.getString("metatag.episode") + " - " + TmmResourceBundle.getString("bulkedit.expert"), panelContent);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][100lp:200lp,grow]", "[grow][20lp!][][50lp][][20lp!][200lp:250lp,grow]"));
        tpDescription = new ReadOnlyTextPane(TmmResourceBundle.getString("bulkedit.description"));
        panelContent.add((Component)tpDescription, "cell 0 0 2 1,grow");
        lblPropertyT = new TmmLabel(TmmResourceBundle.getString("bulkedit.field"));
        panelContent.add((Component)lblPropertyT, "cell 0 2,alignx right");
        this.cbEpisodeProperty = new JComboBox();
        this.cbEpisodeProperty.addItem(new BulkEditorProperty("title", TmmResourceBundle.getString("metatag.title")));
        this.cbEpisodeProperty.addItem(new BulkEditorProperty("originalTitle", TmmResourceBundle.getString("metatag.originaltitle")));
        this.cbEpisodeProperty.addItem(new BulkEditorProperty("sortTitle", TmmResourceBundle.getString("metatag.sorttitle")));
        this.cbEpisodeProperty.addItem(new BulkEditorProperty("tagline", TmmResourceBundle.getString("metatag.tagline")));
        this.cbEpisodeProperty.addItem(new BulkEditorProperty("plot", TmmResourceBundle.getString("metatag.plot")));
        this.cbEpisodeProperty.addItem(new BulkEditorProperty("productionCompany", TmmResourceBundle.getString("metatag.production")));
        this.cbEpisodeProperty.addItem(new BulkEditorProperty("spokenLanguages", TmmResourceBundle.getString("metatag.spokenlanguages")));
        this.cbEpisodeProperty.addItem(new BulkEditorProperty("country", TmmResourceBundle.getString("metatag.country")));
        this.cbEpisodeProperty.addItem(new BulkEditorProperty("note", TmmResourceBundle.getString("metatag.note")));
        this.cbEpisodeProperty.addItem(new BulkEditorProperty("originalFilename", TmmResourceBundle.getString("metatag.originalfile")));
        this.cbEpisodeProperty.addItemListener(e -> this.episodeValuesEventList.forEach(episodeValues -> episodeValues.changeProperty(((BulkEditorProperty)this.cbEpisodeProperty.getSelectedItem()).property)));
        panelContent.add(this.cbEpisodeProperty, "cell 1 2,growx,wmin 0");
        lblPatternT = new TmmLabel(TmmResourceBundle.getString("bulkedit.value"));
        panelContent.add((Component)lblPatternT, "cell 0 3,alignx right");
        taPattern = new JTextArea();
        taPattern.setBorder(UIManager.getBorder("ScrollPane.border"));
        taPattern.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changePattern();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changePattern();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changePattern();
            }

            private void changePattern() {
                TvShowBulkEditorDialog.this.episodeValuesEventList.forEach(episodeValues -> episodeValues.changePattern(taPattern.getText()));
            }
        });
        taPattern.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                taPattern.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                taPattern.repaint();
            }
        });
        panelContent.add((Component)taPattern, "flowx,cell 1 3,wmin 0,grow");
        btnApply = new JButton(TmmResourceBundle.getString("Button.apply"));
        btnApply.setIcon(IconManager.APPLY_INV);
        btnApply.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.episodeValuesEventList.forEach(EpisodeValues::applyValue);
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnApply, "cell 1 4,alignx right");
        tableValues = new TmmTable((TableModel)((Object)new TmmTableModel<EpisodeValues>(this.episodeValuesEventList, new EpisodeValuesTableFormat())));
        tableValues.setSelectionModel(new NullSelectionModel());
        scrollPane = new JScrollPane();
        tableValues.configureScrollPane(scrollPane);
        panelContent.add((Component)scrollPane, "cell 0 6 2 1,grow");
        scrollPane.setViewportView(tableValues);
    }

    private static class TvShowValues
    extends AbstractModelObject {
        private final TvShow tvShow;
        private String property;
        private String propertyValue = "";
        private String patternValue = "";

        public TvShowValues(TvShow tvShow) {
            this.tvShow = tvShow;
        }

        public void changeProperty(String property) {
            this.property = property;
            String oldValue = this.propertyValue;
            this.propertyValue = "";
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(property, Movie.class);
                Object value = descriptor.getReadMethod().invoke((Object)this.tvShow, new Object[0]);
                if (value != null) {
                    this.propertyValue = value.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.firePropertyChange("propertyValue", oldValue, this.propertyValue);
        }

        public void changePattern(String pattern) {
            String oldValue = this.patternValue;
            this.patternValue = this.getPatternValue(pattern);
            this.firePropertyChange("patternValue", oldValue, this.patternValue);
        }

        private String getPatternValue(String pattern) {
            try {
                Engine engine = TvShowRenamer.createEngine();
                HashMap<String, TvShow> root = new HashMap<String, TvShow>();
                root.put("tvShow", this.tvShow);
                return engine.transform(JmteUtils.morphTemplate(pattern, TvShowRenamer.getTokenMap()), root);
            }
            catch (Exception e) {
                return pattern;
            }
        }

        public void applyValue() {
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(this.property, TvShow.class);
                descriptor.getWriteMethod().invoke((Object)this.tvShow, this.patternValue);
                String oldValue = this.propertyValue;
                this.propertyValue = this.patternValue;
                this.firePropertyChange("propertyValue", oldValue, this.propertyValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getTvShowTitle() {
            return this.tvShow.getTitle();
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public String getPatternValue() {
            return this.patternValue;
        }
    }

    private static class EpisodeValues
    extends AbstractModelObject {
        private final TvShowEpisode episode;
        private String property;
        private String propertyValue = "";
        private String patternValue = "";

        public EpisodeValues(TvShowEpisode tvShowEpisode) {
            this.episode = tvShowEpisode;
        }

        public void changeProperty(String property) {
            this.property = property;
            String oldValue = this.propertyValue;
            this.propertyValue = "";
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(property, TvShowEpisode.class);
                Object value = descriptor.getReadMethod().invoke((Object)this.episode, new Object[0]);
                if (value != null) {
                    this.propertyValue = value.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.firePropertyChange("propertyValue", oldValue, this.propertyValue);
        }

        public void changePattern(String pattern) {
            String oldValue = this.patternValue;
            this.patternValue = this.getPatternValue(pattern);
            this.firePropertyChange("patternValue", oldValue, this.patternValue);
        }

        private String getPatternValue(String pattern) {
            try {
                Engine engine = MovieRenamer.createEngine();
                HashMap<String, MediaEntity> root = new HashMap<String, MediaEntity>();
                root.put("tvShow", this.episode.getTvShow());
                root.put("episode", this.episode);
                return engine.transform(JmteUtils.morphTemplate(pattern, TvShowRenamer.getTokenMap()), root);
            }
            catch (Exception e) {
                return pattern;
            }
        }

        public void applyValue() {
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(this.property, TvShowEpisode.class);
                descriptor.getWriteMethod().invoke((Object)this.episode, this.patternValue);
                String oldValue = this.propertyValue;
                this.propertyValue = this.patternValue;
                this.firePropertyChange("propertyValue", oldValue, this.propertyValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getEpisodeTitle() {
            return String.format("S%2dE%2d - %s", this.episode.getSeason(), this.episode.getEpisode(), this.episode.getTitle());
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public String getPatternValue() {
            return this.patternValue;
        }
    }

    private record BulkEditorProperty(String property, String description) {
        @Override
        public String toString() {
            return this.description;
        }
    }

    private static class TvShowValuesTableFormat
    extends TmmTableFormat<TvShowValues> {
        public TvShowValuesTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", TvShowValues::getTvShowTitle, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("bulkedit.oldvalue"), "oldValue", TvShowValues::getPropertyValue, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("bulkedit.newvalue"), "newValue", TvShowValues::getPatternValue, String.class);
            this.addColumn(col);
        }
    }

    private static class EpisodeValuesTableFormat
    extends TmmTableFormat<EpisodeValues> {
        public EpisodeValuesTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", EpisodeValues::getEpisodeTitle, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("bulkedit.oldvalue"), "oldValue", EpisodeValues::getPropertyValue, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("bulkedit.newvalue"), "newValue", EpisodeValues::getPatternValue, String.class);
            this.addColumn(col);
        }
    }
}

