/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowFetchRatingsDialog
extends TmmDialog {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String PROPERTY_NAME = "ratingSources";
    private final TmmCheckComboBox<RatingProvider.RatingSource> cbSources;

    public TvShowFetchRatingsDialog() {
        super(TmmResourceBundle.getString("tvshow.fetchratings"), "tvShowFetchRatings");
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][250lp]", "[][50lp]"));
        TmmLabel lblRatingSource = new TmmLabel(TmmResourceBundle.getString("metatag.rating.source"));
        panelContent.add((Component)lblRatingSource, "cell 0 0,alignx right");
        this.cbSources = new TmmCheckComboBox<RatingProvider.RatingSource>(RatingProvider.RatingSource.getRatingSourcesForTvShows());
        panelContent.add(this.cbSources, "cell 1 0,growx");
        JButton cancelButton = new JButton(TmmResourceBundle.getString("Button.cancel"));
        cancelButton.setIcon(IconManager.CANCEL_INV);
        cancelButton.addActionListener(e -> {
            this.cbSources.clearSelection();
            this.setVisible(false);
        });
        this.addButton(cancelButton);
        JButton btnOk = new JButton(TmmResourceBundle.getString("Button.ok"));
        btnOk.setIcon(IconManager.APPLY_INV);
        btnOk.addActionListener(e -> {
            this.storeDefaults();
            this.setVisible(false);
        });
        this.addButton(btnOk);
    }

    public List<RatingProvider.RatingSource> getSelectedRatingSources() {
        return this.cbSources.getSelectedItems();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.loadDefaults();
        }
        super.setVisible(visible);
    }

    private void loadDefaults() {
        ArrayList<RatingProvider.RatingSource> selectedItems = new ArrayList<RatingProvider.RatingSource>();
        try {
            String storedValues = TmmProperties.getInstance().getProperty(this.getName() + ".ratingSources");
            if (StringUtils.isNotBlank((CharSequence)storedValues)) {
                List values = (List)OBJECT_MAPPER.readValue(storedValues, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class));
                for (String valueAsString : values) {
                    selectedItems.add(RatingProvider.RatingSource.valueOf(valueAsString));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cbSources.setSelectedItems(selectedItems);
    }

    private void storeDefaults() {
        try {
            ArrayList<String> values = new ArrayList<String>();
            for (RatingProvider.RatingSource source : this.getSelectedRatingSources()) {
                values.add(source.name());
            }
            TmmProperties.getInstance().putProperty(this.getName() + ".ratingSources", OBJECT_MAPPER.writeValueAsString(values));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

