/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowVideoFormatFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    public TvShowVideoFormatFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.setValues(MediaFileHelper.getVideoFormats());
    }

    @Override
    public String getId() {
        return "tvShowVideoFormat";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
            for (MediaFile mf : mfs) {
                if (!(invert ^ (selectedValues.contains(mf.getVideoFormat()) || selectedValues.contains(mf.getVideoDefinitionCategory())))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.resolution"));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

